/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.decorators.ComputedField;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.datamodel.decorators.FieldDecorator;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.implementations.aggregated.JobUsageRecord;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.NotEmptyIfNotNull;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.datamodel.validations.annotations.ValidOperationResult;
import org.gcube.accounting.exception.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicUsageRecord
implements UsageRecord,
Serializable {
    private static final long serialVersionUID = -2060728578456796388L;
    private static Logger logger = LoggerFactory.getLogger(BasicUsageRecord.class);
    @RequiredField
    @NotEmpty
    public static final String ID = "id";
    @RequiredField
    @NotEmpty
    public static final String CREATOR_ID = "creatorId";
    @RequiredField
    @NotEmpty
    public static final String CONSUMER_ID = "consumerId";
    @RequiredField
    @ValidLong
    public static final String CREATION_TIME = "creationTime";
    @AggregatedField
    @ValidLong
    protected static final String START_TIME = "startTime";
    @AggregatedField
    @ValidLong
    protected static final String END_TIME = "endTime";
    @RequiredField
    @NotEmpty
    protected static final String USAGE_RECORD_TYPE = "usageRecordType";
    @RequiredField
    @NotEmpty
    public static final String RESOURCE_SCOPE = "resourceScope";
    @AggregatedField
    @NotEmptyIfNotNull
    protected static final String AGGREGATED = "aggregated";
    @AggregatedField
    @NotEmptyIfNotNull
    protected static final String AGGREGATED_USAGE_RECORD_ID = "aggregatedUsageRecordId";
    @RequiredField
    @ValidOperationResult
    public static final String OPERATION_RESULT = "operationResult";
    protected Map<String, Serializable> resourceProperties;
    protected Map<String, List<FieldAction>> validation;
    protected Set<String> requiredFields;
    protected Set<String> aggregatedFields;
    protected Set<String> computedFields;

    protected void initializeValidation() {
        logger.debug("Initializing Field Validators");
        List<Field> fields = Arrays.asList(this.getClass().getDeclaredFields());
        for (Field field : fields) {
            String keyString;
            try {
                keyString = (String)field.get(null);
            }
            catch (Exception e) {
                continue;
            }
            ArrayList<FieldAction> fieldValidators = new ArrayList<FieldAction>();
            this.validation.put(keyString, fieldValidators);
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation.annotationType().isAnnotationPresent(FieldDecorator.class)) {
                    FieldAction validator;
                    Class<? extends FieldAction> managedClass = annotation.annotationType().getAnnotation(FieldDecorator.class).managed();
                    try {
                        validator = managedClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        continue;
                    }
                    fieldValidators.add(validator);
                }
                if (annotation.annotationType().isAssignableFrom(RequiredField.class)) {
                    this.requiredFields.add(keyString);
                }
                if (annotation.annotationType().isAssignableFrom(AggregatedField.class)) {
                    this.aggregatedFields.add(keyString);
                }
                if (!annotation.annotationType().isAssignableFrom(ComputedField.class)) continue;
                this.computedFields.add(keyString);
            }
        }
    }

    private void init() {
        this.validation = new HashMap<String, List<FieldAction>>();
        this.requiredFields = new HashSet<String>();
        this.aggregatedFields = new HashSet<String>();
        this.computedFields = new HashSet<String>();
        this.initializeValidation();
    }

    public BasicUsageRecord() {
        this.init();
        this.resourceProperties = new HashMap<String, Serializable>();
        this.resourceProperties.put(ID, (Serializable)((Object)UUID.randomUUID().toString()));
        this.resourceProperties.put(USAGE_RECORD_TYPE, (Serializable)((Object)this.getClass().getSimpleName()));
        Calendar calendar = Calendar.getInstance();
        this.resourceProperties.put(CREATION_TIME, Long.valueOf(calendar.getTimeInMillis()));
    }

    public BasicUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        this.init();
        this.setResourceProperties(properties);
    }

    @Override
    public String getId() {
        return (String)((Object)this.resourceProperties.get(ID));
    }

    @Override
    public void setId(String id) throws InvalidValueException {
        this.setResourceProperty(ID, (Serializable)((Object)id));
    }

    @Override
    public String getCreatorId() {
        return (String)((Object)this.resourceProperties.get(CREATOR_ID));
    }

    @Override
    public void setCreatorId(String creatorId) throws InvalidValueException {
        this.setResourceProperty(CREATOR_ID, (Serializable)((Object)creatorId));
    }

    @Override
    public String getConsumerId() {
        return (String)((Object)this.resourceProperties.get(CONSUMER_ID));
    }

    @Override
    public void setConsumerId(String consumerId) throws InvalidValueException {
        this.setResourceProperty(CONSUMER_ID, (Serializable)((Object)consumerId));
    }

    protected Calendar timestampStringToCalendar(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    @Override
    public Calendar getCreationTime() {
        long millis = (Long)this.resourceProperties.get(CREATION_TIME);
        return this.timestampStringToCalendar(millis);
    }

    @Override
    public void setCreationTime(Calendar creationTime) throws InvalidValueException {
        this.setResourceProperty(CREATION_TIME, Long.valueOf(creationTime.getTimeInMillis()));
    }

    protected Calendar getStartTimeAsCalendar() {
        long millis = (Long)this.resourceProperties.get(START_TIME);
        return this.timestampStringToCalendar(millis);
    }

    protected void setStartTime(Calendar startTime) throws InvalidValueException {
        this.setResourceProperty(START_TIME, Long.valueOf(startTime.getTimeInMillis()));
    }

    protected Calendar getEndTimeAsCalendar() {
        long millis = (Long)this.resourceProperties.get(END_TIME);
        return this.timestampStringToCalendar(millis);
    }

    protected void setEndTime(Calendar endTime) throws InvalidValueException {
        this.setResourceProperty(END_TIME, Long.valueOf(endTime.getTimeInMillis()));
    }

    @Override
    public String getResourceScope() {
        return (String)((Object)this.resourceProperties.get(RESOURCE_SCOPE));
    }

    @Override
    public void setResourceScope(String scope) throws InvalidValueException {
        this.setResourceProperty(RESOURCE_SCOPE, (Serializable)((Object)scope));
    }

    @Override
    public String getAggregatedUsageRecordId() {
        return (String)((Object)this.resourceProperties.get(AGGREGATED_USAGE_RECORD_ID));
    }

    @Override
    public void setAggregatedUsageRecordId(String aggregatedId) throws InvalidValueException {
        this.setResourceProperty(AGGREGATED_USAGE_RECORD_ID, (Serializable)((Object)aggregatedId));
    }

    @Override
    public Map<String, Serializable> getResourceProperties() {
        return new HashMap<String, Serializable>(this.resourceProperties);
    }

    @Override
    public void setResourceProperties(Map<String, Serializable> properties) throws InvalidValueException {
        this.validateProperties(properties);
        this.resourceProperties = new HashMap<String, Serializable>(properties);
    }

    @Override
    public Serializable getResourceProperty(String key) {
        return this.resourceProperties.get(key);
    }

    @Override
    public void setResourceProperty(String key, Serializable value) throws InvalidValueException {
        Serializable checkedValue = this.validateField(key, value);
        if (checkedValue == null) {
            this.resourceProperties.remove(key);
        } else {
            this.resourceProperties.put(key, checkedValue);
        }
    }

    protected Serializable validateField(String key, Serializable serializable) throws InvalidValueException {
        if (key == null) {
            throw new InvalidValueException("The key of property to set cannot be null");
        }
        Serializable checkedValue = serializable;
        List<FieldAction> fieldValidators = this.validation.get(key);
        if (fieldValidators != null) {
            for (FieldAction fieldValidator : fieldValidators) {
                if (this.aggregatedFields.contains(key)) {
                    // empty if block
                }
                if (this.computedFields.contains(key)) {
                    logger.debug("{} is a computed field. To be calculated all the required fields to calcutalate it MUST be set. In any case the provided value is ignored.");
                }
                checkedValue = fieldValidator.validate(key, checkedValue, this);
            }
        }
        return checkedValue;
    }

    protected void validateProperties(Map<String, Serializable> properties) throws InvalidValueException {
        for (String key : properties.keySet()) {
            Serializable serializable = properties.get(key);
            this.validateField(key, serializable);
        }
    }

    @Override
    public void validate() throws InvalidValueException {
        this.validateProperties(this.resourceProperties);
        HashSet<String> notPresentProperties = new HashSet<String>();
        for (String key : this.requiredFields) {
            if (this.resourceProperties.containsKey(key)) continue;
            notPresentProperties.add(key);
        }
        if (!notPresentProperties.isEmpty()) {
            String pluralManagement = notPresentProperties.size() == 1 ? "y" : "ies";
            throw new InvalidValueException(String.format("The Usage Record does not contain the following required propert%s %s", pluralManagement, ((Object)notPresentProperties).toString()));
        }
    }

    public String toString() {
        return this.resourceProperties.toString();
    }

    @Override
    public UsageRecord.OperationResult getOperationResult() {
        return UsageRecord.OperationResult.valueOf((String)((Object)this.resourceProperties.get(OPERATION_RESULT)));
    }

    @Override
    public void setOperationResult(UsageRecord.OperationResult operationResult) throws InvalidValueException {
        this.setResourceProperty(OPERATION_RESULT, (Serializable)((Object)operationResult));
    }

    @Override
    public int compareTo(UsageRecord usageRecord) {
        Set<Map.Entry<String, Serializable>> thisSet = this.resourceProperties.entrySet();
        Set<Map.Entry<String, Serializable>> usageRecordSet = usageRecord.getResourceProperties().entrySet();
        if (thisSet.size() != usageRecordSet.size()) {
            return thisSet.size() - usageRecordSet.size();
        }
        if (usageRecordSet.containsAll(thisSet)) {
            return 0;
        }
        return 1;
    }

    protected static Class<? extends UsageRecord> getClass(String usageRecordName, boolean aggregated) throws ClassNotFoundException {
        Class<?> clz = null;
        Class<org.gcube.accounting.datamodel.implementations.JobUsageRecord> utilityClass = org.gcube.accounting.datamodel.implementations.JobUsageRecord.class;
        if (aggregated) {
            utilityClass = JobUsageRecord.class;
        }
        String classCanonicalName = utilityClass.getCanonicalName();
        classCanonicalName.replace(utilityClass.getSimpleName(), usageRecordName);
        try {
            clz = Class.forName(classCanonicalName);
        }
        catch (ClassNotFoundException e) {
            logger.error("Unable to retrieve class {}", (Object)classCanonicalName);
            throw e;
        }
        return clz;
    }

    public static UsageRecord getUsageRecord(Map<String, Serializable> usageRecordMap) throws Exception {
        String className = (String)((Object)usageRecordMap.get(USAGE_RECORD_TYPE));
        boolean aggregated = false;
        try {
            aggregated = (Boolean)usageRecordMap.get(AGGREGATED);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Class<? extends UsageRecord> clz = BasicUsageRecord.getClass(className, aggregated);
        logger.debug("Trying to instantiate {}", (Object)clz.getClass().getSimpleName());
        Class[] usageRecordArgTypes = new Class[]{Map.class};
        Constructor<? extends UsageRecord> usageRecordConstructor = clz.getDeclaredConstructor(usageRecordArgTypes);
        Object[] usageRecordArguments = new Object[]{usageRecordMap};
        UsageRecord usageRecord = usageRecordConstructor.newInstance(usageRecordArguments);
        logger.debug("Created Usage Record : {}", (Object)usageRecord);
        return usageRecord;
    }
}

