/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.datamodel.decorators.FieldDecorator;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.DeprecatedWarning;
import org.gcube.accounting.datamodel.implementations.JobUsageRecord;
import org.gcube.accounting.datamodel.implementations.PortletUsageRecord;
import org.gcube.accounting.datamodel.implementations.ServiceUsageRecord;
import org.gcube.accounting.datamodel.implementations.StorageUsageRecord;
import org.gcube.accounting.datamodel.implementations.TaskUsageRecord;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.NotEmptyIfNotNull;
import org.gcube.accounting.datamodel.validations.validators.NotEmptyIfNotNullValidator;
import org.gcube.accounting.exception.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RawUsageRecord
extends BasicUsageRecord {
    private static final long serialVersionUID = 1203390363640634895L;
    private static Logger logger = LoggerFactory.getLogger(RawUsageRecord.class);
    @DeprecatedWarning
    @NotEmpty
    protected static final String RESOURCE_OWNER = "resourceOwner";
    @DeprecatedWarning
    @MoveToCreationTime
    protected static final String CREATE_TIME = "createTime";
    private static final Map<String, String> resourceTypeMapping = new HashMap<String, String>();
    private static final String JOB = "job";
    private static final String TASK = "task";
    private static final String PORTLET = "portlet";
    private static final String SERVICE = "service";
    private static final String STORAGE_USAGE = "storage-usage";
    @DeprecatedWarning
    @MoveToUsageRecordType
    protected static final String RESOURCE_TYPE = "resourceType";
    @DeprecatedWarning
    @MoveToAggregatedUsageRecordId
    protected static final String AGGREGATED_ID = "aggregatedId";
    @NotEmptyIfNotNull
    @DeprecatedWarning
    protected static final String FULLY_QUALIFIED_CONSUMER_ID = "fullyQualifiedConsumerId";

    public RawUsageRecord() {
        this.resourceProperties.remove("usageRecordType");
    }

    public RawUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    @Override
    public void setConsumerId(String consumerId) {
        try {
            this.setConsumerId(consumerId);
        }
        catch (Exception e) {
            logger.error("Unable to Set {}", (Object)"consumerId");
        }
    }

    @Override
    public void setResourceScope(String scope) {
        try {
            this.setResourceScope(scope);
        }
        catch (Exception e) {
            logger.error("Unable to Set {}", (Object)"resourceScope");
        }
    }

    @Deprecated
    public String getResourceType() {
        return (String)this.resourceProperties.get(RESOURCE_TYPE);
    }

    @Deprecated
    public void setResourceType(String resourceType) {
        try {
            this.setResourceProperty(RESOURCE_TYPE, (Serializable)((Object)resourceType));
        }
        catch (InvalidValueException e) {
            logger.error("Unable to Set {}", (Object)RESOURCE_TYPE);
        }
    }

    @Deprecated
    public Date getCreateTime() {
        long millis = (Long)this.resourceProperties.get("creationTime");
        return this.timestampStringToCalendar(millis).getTime();
    }

    @Deprecated
    public void setCreateTime(Date createTime) {
        logger.warn("The method is deprecated. Please modify your code as soon as possible");
    }

    @Deprecated
    public Date getStartTime() {
        long millis = (Long)this.resourceProperties.get("startTime");
        return this.timestampStringToCalendar(millis).getTime();
    }

    @Deprecated
    public void setStartTime(Date startTime) throws InvalidValueException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        this.setStartTime(calendar);
    }

    @Deprecated
    public Date getEndTime() {
        long millis = (Long)this.resourceProperties.get("endTime");
        return this.timestampStringToCalendar(millis).getTime();
    }

    @Deprecated
    public void setEndTime(Date endTime) throws InvalidValueException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endTime);
        this.setEndTime(calendar);
    }

    @Deprecated
    public String getResourceOwner() {
        return (String)this.resourceProperties.get(RESOURCE_OWNER);
    }

    @Deprecated
    public void setResourceOwner(String owner) {
        try {
            this.setResourceProperty(RESOURCE_OWNER, (Serializable)((Object)owner));
        }
        catch (InvalidValueException e) {
            logger.error("Unable to Set {}", (Object)RESOURCE_OWNER);
        }
    }

    @Deprecated
    public String getAggregatedId() {
        return (String)this.resourceProperties.get(AGGREGATED_ID);
    }

    @Deprecated
    public void setAggregatedId(String aggregatedId) throws InvalidValueException {
        this.setResourceProperty(AGGREGATED_ID, (Serializable)((Object)aggregatedId));
    }

    @Deprecated
    public Map<String, String> getResourceSpecificProperties() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String key : this.resourceProperties.keySet()) {
            String value = ((Serializable)this.resourceProperties.get(key)).toString();
            ret.put(key, value);
        }
        return ret;
    }

    @Deprecated
    public void setResourceSpecificProperties(Map<String, String> properties) throws InvalidValueException {
        HashMap<String, String> map = new HashMap<String, String>(properties);
        this.setResourceProperties(map);
    }

    @Deprecated
    public String getResourceSpecificProperty(String key) {
        return this.getResourceProperty(key).toString();
    }

    @Deprecated
    public void setResourceSpecificProperty(String key, Serializable value) {
        try {
            this.setResourceProperty(key, value);
        }
        catch (InvalidValueException e) {
            logger.error("Unable to Set {}", (Object)key);
        }
    }

    @Deprecated
    public String getFullyQualifiedConsumerId() {
        return (String)this.resourceProperties.get(FULLY_QUALIFIED_CONSUMER_ID);
    }

    @Deprecated
    public void setFullyQualifiedConsumerId(String fqcid) {
        try {
            this.setResourceProperty(FULLY_QUALIFIED_CONSUMER_ID, (Serializable)((Object)fqcid));
        }
        catch (InvalidValueException e) {
            logger.error("Unable to Set {}", (Object)FULLY_QUALIFIED_CONSUMER_ID);
        }
    }

    static {
        resourceTypeMapping.put(JOB, JobUsageRecord.class.getSimpleName());
        resourceTypeMapping.put(TASK, TaskUsageRecord.class.getSimpleName());
        resourceTypeMapping.put(PORTLET, PortletUsageRecord.class.getSimpleName());
        resourceTypeMapping.put(SERVICE, ServiceUsageRecord.class.getSimpleName());
        resourceTypeMapping.put(STORAGE_USAGE, StorageUsageRecord.class.getSimpleName());
    }

    protected class MoveToAggregatedUsageRecordIdAction
    implements FieldAction {
        protected MoveToAggregatedUsageRecordIdAction() {
        }

        @Override
        public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException {
            NotEmptyIfNotNullValidator neinnv = new NotEmptyIfNotNullValidator();
            value = neinnv.validate(key, value, usageRecord);
            usageRecord.setAggregatedUsageRecordId((String)((Object)value));
            return value;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @FieldDecorator(managed=MoveToAggregatedUsageRecordIdAction.class)
    protected static @interface MoveToAggregatedUsageRecordId {
    }

    protected class MoveToUsageRecordTypeAction
    implements FieldAction {
        protected MoveToUsageRecordTypeAction() {
        }

        @Override
        public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException {
            String newValue;
            if (value instanceof String) {
                newValue = (String)resourceTypeMapping.get(value);
                if (newValue == null) {
                    throw new InvalidValueException();
                }
            } else {
                throw new InvalidValueException();
            }
            RawUsageRecord.this.resourceProperties.put("usageRecordType", newValue);
            return value;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @FieldDecorator(managed=MoveToUsageRecordTypeAction.class)
    protected static @interface MoveToUsageRecordType {
    }

    protected class MoveToCreationTimeAction
    implements FieldAction {
        protected MoveToCreationTimeAction() {
        }

        @Override
        public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException {
            Calendar calendar;
            if (value instanceof Date) {
                calendar = Calendar.getInstance();
                calendar.setTime((Date)value);
                value = calendar;
            }
            if (value instanceof Long) {
                calendar = Calendar.getInstance();
                calendar.setTimeInMillis((Long)value);
                value = calendar;
            }
            if (!(value instanceof Calendar)) {
                throw new InvalidValueException();
            }
            usageRecord.setCreationTime((Calendar)value);
            return value;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @FieldDecorator(managed=MoveToCreationTimeAction.class)
    protected static @interface MoveToCreationTime {
    }
}

