/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.validations.validators;

import java.io.Serializable;
import java.util.Map;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.exception.InvalidValueException;

public class NotEmptyValidator
implements FieldAction {
    private static final String ERROR = "Is Empty";

    protected boolean isValid(Serializable toValidate) {
        if (toValidate == null) {
            return false;
        }
        if (toValidate.getClass().isArray()) {
            return ((Object[])toValidate).length > 0;
        }
        if (toValidate instanceof Iterable) {
            return ((Iterable)((Object)toValidate)).iterator().hasNext();
        }
        if (toValidate instanceof Map) {
            return ((Map)((Object)toValidate)).size() > 0;
        }
        if (toValidate instanceof String) {
            return !((String)((Object)toValidate)).isEmpty();
        }
        return true;
    }

    @Override
    public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException {
        try {
            if (this.isValid(value)) {
                return value;
            }
        }
        catch (Exception e) {
            throw new InvalidValueException(ERROR, e.getCause());
        }
        throw new InvalidValueException(ERROR);
    }
}

