/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.decorators.ComputedField;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.datamodel.decorators.FieldDecorator;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.usagerecords.JobUsageRecord;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.NotEmptyIfNotNull;
import org.gcube.accounting.datamodel.validations.annotations.ValidInteger;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.datamodel.validations.annotations.ValidOperationResult;
import org.gcube.accounting.exception.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicUsageRecord
implements UsageRecord,
Serializable {
    private static final long serialVersionUID = -2060728578456796388L;
    private static Logger logger = LoggerFactory.getLogger(BasicUsageRecord.class);
    @RequiredField
    @NotEmpty
    protected static final String ID = "id";
    @RequiredField
    @NotEmpty
    public static final String CONSUMER_ID = "consumerId";
    @RequiredField
    @ValidLong
    public static final String CREATION_TIME = "creationTime";
    @RequiredField
    @NotEmpty
    protected static final String USAGE_RECORD_TYPE = "usageRecordType";
    @RequiredField
    @NotEmpty
    public static final String SCOPE = "scope";
    @RequiredField
    @ValidOperationResult
    public static final String OPERATION_RESULT = "operationResult";
    protected Map<String, Serializable> resourceProperties;
    protected Map<String, List<FieldAction>> validation;
    protected Set<String> requiredFields;
    protected Set<String> computedFields;
    @AggregatedField
    @ValidLong
    protected static final String START_TIME = "startTime";
    @AggregatedField
    @ValidLong
    protected static final String END_TIME = "endTime";
    @AggregatedField
    @NotEmptyIfNotNull
    protected static final String AGGREGATED = "aggregated";
    @AggregatedField
    @ValidInteger
    protected static final String OPERATION_COUNT = "operationCount";
    protected Set<String> aggregatedFields;

    public Set<String> getRequiredFields() {
        return this.requiredFields;
    }

    protected static Set<Field> getAllFields(Class<?> type) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    protected void initializeValidation() {
        logger.debug("Initializing Field Validators");
        Set<Field> fields = BasicUsageRecord.getAllFields(this.getClass());
        for (Field field : fields) {
            String keyString;
            boolean defaultAccessibility = field.isAccessible();
            field.setAccessible(true);
            try {
                keyString = (String)field.get(null);
            }
            catch (Exception e) {
                continue;
            }
            ArrayList<FieldAction> fieldValidators = new ArrayList<FieldAction>();
            this.validation.put(keyString, fieldValidators);
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation.annotationType().isAnnotationPresent(FieldDecorator.class)) {
                    FieldAction validator;
                    Class<? extends FieldAction> managedClass = annotation.annotationType().getAnnotation(FieldDecorator.class).managed();
                    try {
                        validator = managedClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        continue;
                    }
                    fieldValidators.add(validator);
                }
                if (annotation.annotationType().isAssignableFrom(RequiredField.class)) {
                    this.requiredFields.add(keyString);
                }
                if (annotation.annotationType().isAssignableFrom(AggregatedField.class)) {
                    this.aggregatedFields.add(keyString);
                }
                if (!annotation.annotationType().isAssignableFrom(ComputedField.class)) continue;
                this.computedFields.add(keyString);
            }
            field.setAccessible(defaultAccessibility);
        }
        logger.trace("Required Fields {}", this.requiredFields);
        logger.trace("Aggregated Fields {}", this.aggregatedFields);
        logger.trace("Computed Fields {}", this.computedFields);
    }

    private void init() {
        this.validation = new HashMap<String, List<FieldAction>>();
        this.requiredFields = new HashSet<String>();
        this.aggregatedFields = new HashSet<String>();
        this.computedFields = new HashSet<String>();
        this.initializeValidation();
    }

    public BasicUsageRecord() {
        this.init();
        this.resourceProperties = new HashMap<String, Serializable>();
        this.resourceProperties.put(ID, (Serializable)((Object)UUID.randomUUID().toString()));
        this.resourceProperties.put(USAGE_RECORD_TYPE, (Serializable)((Object)this.getClass().getSimpleName()));
        Calendar calendar = Calendar.getInstance();
        this.resourceProperties.put(CREATION_TIME, Long.valueOf(calendar.getTimeInMillis()));
    }

    public BasicUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        this.init();
        this.setResourceProperties(properties);
    }

    @Override
    public String getId() {
        return (String)((Object)this.resourceProperties.get(ID));
    }

    @Override
    public void setId(String id) throws InvalidValueException {
        this.setResourceProperty(ID, (Serializable)((Object)id));
    }

    @Override
    public String getConsumerId() {
        return (String)((Object)this.resourceProperties.get(CONSUMER_ID));
    }

    @Override
    public void setConsumerId(String consumerId) throws InvalidValueException {
        this.setResourceProperty(CONSUMER_ID, (Serializable)((Object)consumerId));
    }

    protected Calendar timestampStringToCalendar(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    @Override
    public Calendar getCreationTime() {
        long millis = (Long)this.resourceProperties.get(CREATION_TIME);
        return this.timestampStringToCalendar(millis);
    }

    @Override
    public void setCreationTime(Calendar creationTime) throws InvalidValueException {
        this.setResourceProperty(CREATION_TIME, Long.valueOf(creationTime.getTimeInMillis()));
    }

    @Override
    public String getScope() {
        return (String)((Object)this.resourceProperties.get(SCOPE));
    }

    @Override
    public void setScope(String scope) throws InvalidValueException {
        this.setResourceProperty(SCOPE, (Serializable)((Object)scope));
    }

    @Override
    public Map<String, Serializable> getResourceProperties() {
        return new HashMap<String, Serializable>(this.resourceProperties);
    }

    @Override
    public void setResourceProperties(Map<String, Serializable> properties) throws InvalidValueException {
        Map<String, Serializable> validated = this.validateProperties(properties);
        this.resourceProperties = new HashMap<String, Serializable>(validated);
    }

    @Override
    public Serializable getResourceProperty(String key) {
        return this.resourceProperties.get(key);
    }

    @Override
    public void setResourceProperty(String key, Serializable value) throws InvalidValueException {
        Serializable checkedValue = this.validateField(key, value);
        if (checkedValue == null) {
            this.resourceProperties.remove(key);
        } else {
            this.resourceProperties.put(key, checkedValue);
        }
    }

    protected long getStartTimeInMillis() {
        return (Long)this.resourceProperties.get(START_TIME);
    }

    protected Calendar getStartTimeAsCalendar() {
        long millis = this.getStartTimeInMillis();
        return this.timestampStringToCalendar(millis);
    }

    protected void setStartTime(Calendar startTime) throws InvalidValueException {
        this.setResourceProperty(START_TIME, Long.valueOf(startTime.getTimeInMillis()));
    }

    protected long getEndTimeInMillis() {
        return (Long)this.resourceProperties.get(END_TIME);
    }

    protected Calendar getEndTimeAsCalendar() {
        long millis = this.getEndTimeInMillis();
        return this.timestampStringToCalendar(millis);
    }

    protected void setEndTime(Calendar endTime) throws InvalidValueException {
        this.setResourceProperty(END_TIME, Long.valueOf(endTime.getTimeInMillis()));
    }

    protected int getOperationCount() {
        return (Integer)this.resourceProperties.get(OPERATION_COUNT);
    }

    protected void setOperationCount(int operationCount) throws InvalidValueException {
        this.setResourceProperty(OPERATION_COUNT, Integer.valueOf(operationCount));
    }

    protected Serializable validateField(String key, Serializable serializable) throws InvalidValueException {
        if (key == null) {
            throw new InvalidValueException("The key of property to set cannot be null");
        }
        Serializable checkedValue = serializable;
        List<FieldAction> fieldValidators = this.validation.get(key);
        if (fieldValidators != null) {
            for (FieldAction fieldValidator : fieldValidators) {
                if (this.aggregatedFields.contains(key)) {
                    // empty if block
                }
                if (this.computedFields.contains(key)) {
                    logger.debug("{} is a computed field. To be calculated all the required fields to calcutalate it MUST be set. In any case the provided value is ignored.");
                }
                checkedValue = fieldValidator.validate(key, checkedValue, this);
            }
        }
        return checkedValue;
    }

    protected Map<String, Serializable> validateProperties(Map<String, Serializable> properties) throws InvalidValueException {
        HashMap<String, Serializable> validated = new HashMap<String, Serializable>();
        for (String key : properties.keySet()) {
            Serializable serializable = properties.get(key);
            validated.put(key, this.validateField(key, serializable));
        }
        return validated;
    }

    @Override
    public void validate() throws InvalidValueException {
        this.validateProperties(this.resourceProperties);
        HashSet<String> notPresentProperties = new HashSet<String>();
        for (String key : this.requiredFields) {
            if (this.resourceProperties.containsKey(key)) continue;
            notPresentProperties.add(key);
        }
        if (!notPresentProperties.isEmpty()) {
            String pluralManagement = notPresentProperties.size() == 1 ? "y" : "ies";
            throw new InvalidValueException(String.format("The Usage Record does not contain the following required propert%s %s", pluralManagement, ((Object)notPresentProperties).toString()));
        }
    }

    public String toString() {
        return this.resourceProperties.toString();
    }

    @Override
    public UsageRecord.OperationResult getOperationResult() {
        return UsageRecord.OperationResult.valueOf((String)((Object)this.resourceProperties.get(OPERATION_RESULT)));
    }

    @Override
    public void setOperationResult(UsageRecord.OperationResult operationResult) throws InvalidValueException {
        this.setResourceProperty(OPERATION_RESULT, (Serializable)((Object)operationResult));
    }

    @Override
    public int compareTo(UsageRecord usageRecord) {
        Set<Map.Entry<String, Serializable>> thisSet = this.resourceProperties.entrySet();
        Set<Map.Entry<String, Serializable>> usageRecordSet = usageRecord.getResourceProperties().entrySet();
        if (thisSet.size() != usageRecordSet.size()) {
            return thisSet.size() - usageRecordSet.size();
        }
        if (usageRecordSet.containsAll(thisSet)) {
            return 0;
        }
        return 1;
    }

    protected static Class<? extends UsageRecord> getClass(String usageRecordName, boolean aggregated) throws ClassNotFoundException {
        Class<?> clz = null;
        Class utilityClass = JobUsageRecord.class;
        if (aggregated) {
            utilityClass = org.gcube.accounting.aggregation.JobUsageRecord.class;
        }
        String classCanonicalName = utilityClass.getCanonicalName();
        classCanonicalName = classCanonicalName.replace(utilityClass.getSimpleName(), usageRecordName);
        try {
            clz = Class.forName(classCanonicalName);
        }
        catch (ClassNotFoundException e) {
            logger.error("Unable to retrieve class {}", (Object)classCanonicalName);
            throw e;
        }
        return clz;
    }

    public static UsageRecord getUsageRecord(Map<String, Serializable> usageRecordMap) throws Exception {
        String className = (String)((Object)usageRecordMap.get(USAGE_RECORD_TYPE));
        boolean aggregated = false;
        try {
            aggregated = (Boolean)usageRecordMap.get(AGGREGATED);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Class<? extends UsageRecord> clz = BasicUsageRecord.getClass(className, aggregated);
        logger.debug("Trying to instantiate {}", (Object)clz.getClass().getSimpleName());
        Class[] usageRecordArgTypes = new Class[]{Map.class};
        Constructor<? extends UsageRecord> usageRecordConstructor = clz.getDeclaredConstructor(usageRecordArgTypes);
        Object[] usageRecordArguments = new Object[]{usageRecordMap};
        UsageRecord usageRecord = usageRecordConstructor.newInstance(usageRecordArguments);
        logger.debug("Created Usage Record : {}", (Object)usageRecord);
        return usageRecord;
    }
}

