/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.util.concurrent.TimeUnit;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.persistence.PersistenceBackendFactory;
import org.gcube.documentstore.records.Record;

public class AccountingPersistence {
    private static final AccountingPersistence accountingPersistence = new AccountingPersistence();

    private AccountingPersistence() {
    }

    protected static synchronized AccountingPersistence getInstance() {
        return accountingPersistence;
    }

    public void account(Record record) throws InvalidValueException {
        String scope = ScopeProvider.instance.get();
        try {
            PersistenceBackendFactory.getPersistenceBackend((String)scope).account(record);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException((Throwable)e);
        }
    }

    public void flushAll(long timeout, TimeUnit timeUnit) throws Exception {
        PersistenceBackendFactory.flushAll((long)timeout, (TimeUnit)timeUnit);
    }

    public void flush(long timeout, TimeUnit timeUnit) throws Exception {
        String scope = ScopeProvider.instance.get();
        PersistenceBackendFactory.flush((String)scope, (long)timeout, (TimeUnit)timeUnit);
    }

    public void close() throws Exception {
        String scope = ScopeProvider.instance.get();
        PersistenceBackendFactory.getPersistenceBackend((String)scope).close();
    }
}

