/**
 * 
 */
package org.gcube.accounting.datamodel.basetypes;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;

import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.backwardcompatibility.MoveToOperationResult;
import org.gcube.accounting.datamodel.backwardcompatibility.MoveToTaskEndTime;
import org.gcube.accounting.datamodel.backwardcompatibility.MoveToTaskStartTime;
import org.gcube.accounting.datamodel.deprecationmanagement.DeprecatedWarning;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmpty;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidInteger;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public abstract class AbstractTaskUsageRecord extends BasicUsageRecord {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -2208425042550641240L;

	@RequiredField @NotEmpty
	public static final String JOB_ID = "jobId";
	@RequiredField @NotEmpty
	public static final String REF_HOST = "refHost";
	@RequiredField @NotEmpty
	public static final String REF_VM = "refVM";
	
	@Deprecated @NotEmpty @DeprecatedWarning
	protected static final String DOMAIN = "domain";
	
	@Deprecated @DeprecatedWarning @MoveToTaskStartTime
	protected static final String USAGE_START_TIME = "usageStartTime";
	@Deprecated @DeprecatedWarning @MoveToTaskEndTime
	protected static final String USAGE_END_TIME = "usageEndTime";
	
	@Deprecated @MoveToOperationResult @DeprecatedWarning
	protected static final String USAGE_PHASE = "usagePhase";
	
	@RequiredField @ValidLong
	public static final String TASK_START_TIME = "taskStartTime";
	@RequiredField @ValidLong
	public static final String TASK_END_TIME = "taskEndTime";
	
	@Deprecated @ValidInteger @DeprecatedWarning
	protected static final String INPUT_FILES_NUMBER = "inputFilesNumber";
	@Deprecated @ValidLong @DeprecatedWarning
	protected static final String INPUT_FILES_SIZE = "inputFilesSize";
	@Deprecated @ValidInteger @DeprecatedWarning
	protected static final String OUTPUT_FILES_NUMBER = "outputFilesNumber";
	@Deprecated @ValidLong @DeprecatedWarning
	protected static final String OUTPUT_FILES_SIZE = "outputFilesSize";
	@Deprecated @ValidLong @DeprecatedWarning
	protected static final String OVERALL_NETWORK_IN = "overallNetworkIn";
	@Deprecated @ValidLong @DeprecatedWarning
	protected static final String OVERALL_NETWORK_OUT = "overallNetworkOut";
	@Deprecated @ValidInteger @DeprecatedWarning
	protected static final String CORES = "cores";
	@Deprecated @ValidInteger @DeprecatedWarning
	protected static final String PROCESSORS = "processors";
	
	public AbstractTaskUsageRecord(){
		super();
	}
	
	public AbstractTaskUsageRecord(Map<String, Comparable<? extends Serializable>> properties) throws InvalidValueException {
		super(properties);
	}

	private static final String ABSTRACT_TO_REPLACE = "Abstract";
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String giveMeRecordType() {
		return AbstractTaskUsageRecord.class.getSimpleName().replace(ABSTRACT_TO_REPLACE, "");
	}
	
	/**
	 * @return the Job Id
	 */
	public String getJobId() {
		return (String) this.resourceProperties.get(JOB_ID);
	}

	/**
	 * @param jobId Job Id
	 * @throws InvalidValueException if fails
	 */
	public void setJobId(String jobId) throws InvalidValueException {
		setResourceProperty(JOB_ID, jobId);
	}
	
	public String getRefHost() {
		return (String) this.resourceProperties.get(REF_HOST);
	}

	public void setRefHost(String refHost) throws InvalidValueException {
		setResourceProperty(REF_HOST, refHost);
	}

	public String getRefVM() {
		return (String) this.resourceProperties.get(REF_VM);
	}

	public void setRefVM(String refVM) throws InvalidValueException {
		setResourceProperty(REF_VM, refVM);
	}

	@Deprecated
	public Calendar getUsageStartTime() {
		long millis = (Long) this.resourceProperties.get(USAGE_START_TIME);
		return timestampStringToCalendar(millis);
	}
	@Deprecated
	public void setUsageStartTime(Calendar usageStartTime) throws InvalidValueException {
		setResourceProperty(USAGE_START_TIME, usageStartTime.getTimeInMillis());
		
	}
	@Deprecated
	public Calendar getUsageEndTime() {
		long millis = (Long) this.resourceProperties.get(USAGE_END_TIME);
		return timestampStringToCalendar(millis);
	}
	@Deprecated
	public void setUsageEndTime(Calendar usageEndTime) throws InvalidValueException {
		setResourceProperty(USAGE_END_TIME, usageEndTime.getTimeInMillis());
		
	}
	
	public Calendar getTaskStartTime() {
		long millis = (Long) this.resourceProperties.get(TASK_START_TIME);
		return timestampStringToCalendar(millis);
	}

	public void setTaskStartTime(Calendar startTime) throws InvalidValueException {
		setResourceProperty(TASK_START_TIME, startTime.getTimeInMillis());
		
	}

	public Calendar getTaskEndTime() {
		long millis = (Long) this.resourceProperties.get(TASK_END_TIME);
		return timestampStringToCalendar(millis);
	}

	public void setTaskEndTime(Calendar endTime) throws InvalidValueException {
		setResourceProperty(TASK_END_TIME, endTime.getTimeInMillis());
		
	}
	
	/*
	public USAGE_PHASE getUsagePhase() {
		return (USAGE_PHASE) this.resourceProperties.get(USAGE_PHASE);
	}

	public void setUsagePhase(USAGE_PHASE usagePhase) throws InvalidValueException {
		setResourceProperty(USAGE_PHASE, usagePhase);
	}
	*/
	
	@Deprecated 
	public int getInputFilesNumber() {
		return (Integer) this.resourceProperties.get(INPUT_FILES_NUMBER);
	}
	@Deprecated 
	public void setInputFilesNumber(int inputFilesNumber) throws InvalidValueException {
		setResourceProperty(INPUT_FILES_NUMBER, inputFilesNumber);
	}
	@Deprecated 
	public long getInputFilesSize() {
		return (Long) this.resourceProperties.get(INPUT_FILES_SIZE);
	}
	@Deprecated 
	public void setInputFilesSize(long inputFilesSize) throws InvalidValueException {
		setResourceProperty(INPUT_FILES_SIZE, inputFilesSize);
	}
	@Deprecated 
	public int getOutputFilesNumber() {
		return (Integer) this.resourceProperties.get(OUTPUT_FILES_NUMBER);
	}
	@Deprecated 
	public void setOutputFilesNumber(int outputFilesNumber) throws InvalidValueException {
		setResourceProperty(OUTPUT_FILES_NUMBER, outputFilesNumber);
	}
	@Deprecated 
	public long getOutputFilesSize() {
		return (Long) this.resourceProperties.get(OUTPUT_FILES_SIZE);
	}
	@Deprecated 
	public void setOutputFilesSize(long outputFilesSize) throws InvalidValueException {
		setResourceProperty(OUTPUT_FILES_SIZE, outputFilesSize);
	}
	@Deprecated 
	public long getOverallNetworkIn() {
		return (Long) this.resourceProperties.get(OVERALL_NETWORK_IN);
	}
	@Deprecated 
	public void setOverallNetworkIn(long overallNetworkIn) throws InvalidValueException {
		setResourceProperty(OVERALL_NETWORK_IN, overallNetworkIn);
	}
	@Deprecated 
	public long getOverallNetworkOut() {
		return (Long) this.resourceProperties.get(OVERALL_NETWORK_OUT);
	}
	@Deprecated 
	public void setOverallNetworkOut(long overallNetworkOut) throws InvalidValueException {
		setResourceProperty(OVERALL_NETWORK_OUT, overallNetworkOut);
	}
	@Deprecated 
	public int getCores() {
		return (Integer) this.resourceProperties.get(CORES);
	}
	@Deprecated 
	public void setCores(int cores) throws InvalidValueException {
		setResourceProperty(CORES, cores);
	}
	@Deprecated 
	public int getProcessors() {
		return (Integer) this.resourceProperties.get(PROCESSORS);
	}
	@Deprecated 
	public void setProcessors(int processors) throws InvalidValueException {
		setResourceProperty(PROCESSORS, processors);
	}
	
}
