/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.utility.postgresql;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.TreeSet;
import org.gcube.accounting.utility.postgresql.RecordToDBFields;
import org.gcube.accounting.utility.postgresql.RecordToDBMapping;
import org.gcube.documentstore.records.Record;
import org.postgresql.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLQuery {
    protected static final Logger logger = LoggerFactory.getLogger(PostgreSQLQuery.class);
    private static final String UTC_TIME_ZONE = "UTC";
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    protected StringBuffer stringBuffer;

    protected String getQuotedString(String string) throws SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("'");
        Utils.escapeLiteral((StringBuilder)builder, (String)string, (boolean)false);
        builder.append("'");
        return builder.toString();
    }

    protected void appendString(String string) {
        this.stringBuffer.append("'");
        this.stringBuffer.append(string);
        this.stringBuffer.append("'");
    }

    protected void appendValue(Serializable serializable) throws SQLException {
        this.stringBuffer.append(this.getValue(serializable));
    }

    protected String getValue(Serializable serializable) throws SQLException {
        if (serializable instanceof Number) {
            return serializable.toString();
        }
        if (serializable instanceof Calendar) {
            Calendar calendar = (Calendar)serializable;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_PATTERN);
            simpleDateFormat.setTimeZone(DEFAULT_TIME_ZONE);
            String date = simpleDateFormat.format(calendar.getTime());
            return this.getQuotedString(date);
        }
        if (serializable instanceof Enum) {
            Enum e = (Enum)((Object)serializable);
            return this.getQuotedString(e.name());
        }
        return this.getQuotedString(serializable.toString());
    }

    public String getSQLInsertCommand(Record record) throws Exception {
        this.stringBuffer = new StringBuffer();
        RecordToDBFields recordToDBFields = RecordToDBMapping.getRecordToDBFields(record.getClass());
        this.stringBuffer.append("INSERT INTO ");
        this.stringBuffer.append(recordToDBFields.getTableName());
        boolean first = true;
        TreeSet keys = new TreeSet(record.getRequiredFields());
        StringBuffer values = new StringBuffer();
        block8: for (String key : keys) {
            if (first) {
                this.stringBuffer.append(" (");
                values.append(" (");
                first = false;
            } else {
                this.stringBuffer.append(",");
                values.append(",");
            }
            String dbField = recordToDBFields.getTableField(key);
            this.stringBuffer.append(dbField);
            switch (key) {
                case "creationTime": 
                case "startTime": 
                case "endTime": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis((Long)record.getResourceProperty(key));
                    values.append(this.getValue(calendar));
                    continue block8;
                }
            }
            values.append(this.getValue(record.getResourceProperty(key)));
        }
        this.stringBuffer.append(") VALUES");
        this.stringBuffer.append(values);
        this.stringBuffer.append(")");
        this.stringBuffer.append(" ON CONFLICT (");
        String dbField = recordToDBFields.getTableField("id");
        this.stringBuffer.append(dbField);
        this.stringBuffer.append(") DO NOTHING;");
        String ret = this.stringBuffer.toString();
        logger.trace("Created query {}", (Object)ret);
        return ret;
    }
}

