/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.util.ClassHierarchyMap;
import org.ektorp.util.Exceptions;

public class JSONComparator {
    private static final String UTF_8 = "UTF-8";
    private static Map<Class<?>, ValueComparator> valueComparators = new ClassHierarchyMap<ValueComparator>();

    private JSONComparator() {
    }

    public static boolean areEqual(String jsonA, String jsonB) {
        ObjectMapper om = new ObjectMapper();
        try {
            Map mapA = om.readValue(IOUtils.toInputStream(jsonA, UTF_8), Map.class);
            Map mapB = om.readValue(IOUtils.toInputStream(jsonB, UTF_8), Map.class);
            return JSONComparator.areEquals(mapA, mapB);
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }

    private static boolean areEquals(Map<String, ?> mapA, Map<String, ?> mapB) {
        return valueComparators.get(Map.class).equals(mapA, mapB);
    }

    private static boolean compareValue(Object aValue, Object bValue) {
        if (bValue == null) {
            return false;
        }
        ValueComparator vp = JSONComparator.getComparator(aValue);
        return vp.equals(aValue, bValue);
    }

    private static ValueComparator getComparator(Object aValue) {
        ValueComparator vp = valueComparators.get(aValue.getClass());
        if (vp == null) {
            throw new IllegalStateException(String.format("No value comparator found for class: %s", aValue.getClass()));
        }
        return vp;
    }

    static {
        valueComparators.put(Map.class, new MapComparator());
        valueComparators.put(List.class, new ListComparator());
        valueComparators.put(Object.class, new ObjectComparator());
    }

    private static class ListComparator
    implements ValueComparator {
        private ListComparator() {
        }

        @Override
        public boolean equals(Object a, Object b) {
            if (!(a instanceof List)) {
                throw new IllegalArgumentException("Object a is not a List");
            }
            if (b instanceof List) {
                List aList = (List)a;
                List bList = (List)b;
                if (aList.size() != bList.size()) {
                    return false;
                }
                for (int i = 0; i < aList.size(); ++i) {
                    if (JSONComparator.compareValue(aList.get(i), bList.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class MapComparator
    implements ValueComparator {
        private MapComparator() {
        }

        @Override
        public boolean equals(Object a, Object b) {
            if (!(a instanceof Map)) {
                throw new IllegalArgumentException("Object a is not a Map");
            }
            if (b instanceof Map) {
                Map aValueMap = (Map)a;
                Map bValueMap = (Map)b;
                if (aValueMap.size() != bValueMap.size()) {
                    return false;
                }
                for (Map.Entry entry : aValueMap.entrySet()) {
                    Object bValue = bValueMap.remove(entry.getKey());
                    if (JSONComparator.compareValue(entry.getValue(), bValue)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class ObjectComparator
    implements ValueComparator {
        private ObjectComparator() {
        }

        @Override
        public boolean equals(Object a, Object b) {
            return a.equals(b);
        }
    }

    private static interface ValueComparator {
        public boolean equals(Object var1, Object var2);
    }
}

