/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.couchdb.query;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.ektorp.DbAccessException;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.accounting.couchdb.query.CouchDBQueryPluginDeclaration;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDBQueryPlugin
extends Plugin<CouchDBQueryPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(CouchDBQueryPlugin.class);
    public static final String DELAY_MILLIS = "DELAY";
    public static final long DEFAULT_DELAY_MILLIS = 120000L;
    public static final int MONTH_INTERVAL = 3;
    public static final int QUERY_MONTH_INTERVAL = 2;
    public static final String MAX_RETRY_NUMBER = "MAX_RETRY";
    public static final int DEFAULT_MAX_RETRY = 2;
    public static final long RETRY_DELAY_MILLIS = 60000L;

    public CouchDBQueryPlugin(CouchDBQueryPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        logger.debug("Launching {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        long delay = 120000L;
        int maxRetry = 2;
        if (inputs != null) {
            if (inputs.containsKey(DELAY_MILLIS)) {
                try {
                    delay = new Long(inputs.get(DELAY_MILLIS).toString());
                }
                catch (Exception e) {
                    logger.warn("The provided value {} for {} is not a long. Default value {} will be used", new Object[]{inputs.get(DELAY_MILLIS), DELAY_MILLIS, 120000L, e});
                }
            } else {
                logger.debug("No provided value for {}. Default value {} will be used", (Object)DELAY_MILLIS, (Object)120000L);
            }
            if (inputs.containsKey(MAX_RETRY_NUMBER)) {
                try {
                    maxRetry = new Integer(inputs.get(MAX_RETRY_NUMBER).toString());
                }
                catch (Exception e) {
                    logger.warn("The provided value {} for {} is not an int. Default value {} will be used", new Object[]{inputs.get(MAX_RETRY_NUMBER), MAX_RETRY_NUMBER, 2, e});
                }
            } else {
                logger.debug("No provided value for {}. Default value {} will be used", (Object)MAX_RETRY_NUMBER, (Object)2);
            }
        }
        AccountingPersistenceQuery apq = AccountingPersistenceQueryFactory.getInstance();
        Map map = RecordUtility.getAggregatedRecordClassesFound();
        Calendar startTime = Calendar.getInstance();
        startTime.roll(2, -2);
        Calendar endTime = Calendar.getInstance();
        for (TemporalConstraint.AggregationMode aggregationMode : TemporalConstraint.AggregationMode.values()) {
            TemporalConstraint temporalConstraint = new TemporalConstraint(startTime.getTimeInMillis(), endTime.getTimeInMillis(), aggregationMode);
            for (Class clz : map.values()) {
                try {
                    SortedSet queryKey = AccountingPersistenceQuery.getQuerableKeys((Class)clz);
                    boolean iterate = true;
                    int i = 1;
                    while (iterate) {
                        try {
                            iterate = false;
                            ArrayList<Filter> filters = new ArrayList<Filter>();
                            String key = i % 2 == 0 ? (String)queryKey.first() : (String)queryKey.last();
                            SortedMap top = apq.getTopValues(clz, temporalConstraint, null, key);
                            try {
                                Filter filter = new Filter(key, ((NumberedFilter)top.keySet().iterator().next()).getValue());
                                filters.add(filter);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            apq.getTimeSeries(clz, temporalConstraint, filters, false);
                            iterate = false;
                        }
                        catch (DbAccessException ex) {
                            if (ex.getCause() instanceof SocketTimeoutException) {
                                if (i <= maxRetry) {
                                    long retryInterval = 60000L * (long)i;
                                    logger.error("{} retry in {} millis", (Object)ex.getCause().getClass().getSimpleName(), (Object)retryInterval);
                                    iterate = true;
                                    ++i;
                                    Thread.sleep(retryInterval);
                                    continue;
                                }
                                logger.error("{} no more retry to attemp.", (Object)ex.getCause().getClass().getSimpleName());
                                continue;
                            }
                            throw ex;
                        }
                        catch (Exception e) {
                            throw e;
                        }
                    }
                    logger.debug("Waiting {} millis before quering the next UsageRecord", (Object)delay);
                    Thread.sleep(delay);
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
        }
        logger.debug("{} has finished", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    protected void onStop() throws Exception {
        logger.debug("{} onStop() function", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }
}

