/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ThreadLocalBulkBufferHolder {
    private static final ThreadLocal<List<Object>> currentBulkBuffer = new ThreadLocal();

    public void add(Object o) {
        List<Object> buffer = currentBulkBuffer.get();
        if (buffer == null) {
            buffer = new ArrayList<Object>();
            currentBulkBuffer.set(buffer);
        }
        buffer.add(o);
    }

    public void clear() {
        currentBulkBuffer.remove();
    }

    public List<Object> getCurrentBuffer() {
        List<Object> b = currentBulkBuffer.get();
        return b != null ? b : Collections.emptyList();
    }
}

