package org.gcube.application.cms.notifications.manage;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.gcube.application.cms.notifications.config.NotificationWhen;
import org.gcube.application.cms.notifications.config.Notify;
import org.gcube.application.cms.notifications.social.SocialClients;
import org.gcube.application.cms.notifications.substitutor.NMessagesPlaceholdersSubstitutorUtil;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.portal.databook.shared.Post;
import org.gcube.social_networking.social_networking_client_library.NotificationClient;
import org.gcube.social_networking.socialnetworking.model.beans.PostInputBean;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEvent;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEventType;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class NotifyUsers {

	private List<User> recipientUsers;
	private NMessagesPlaceholdersSubstitutorUtil nMPlaceholdersSUtil;
	private List<NotificationWhen> listNotificationWhen;
	private SocialClients socialClients;
	private CatalogueEventType catalogueEventType;

	public NotifyUsers(SocialClients socialClients, List<NotificationWhen> listWhen,
			NMessagesPlaceholdersSubstitutorUtil nMPlaceholdersSUtil, List<User> recipientUsers, CatalogueEventType catalogueEventType) {
		this.socialClients = socialClients;
		this.listNotificationWhen = listWhen;
		this.recipientUsers = recipientUsers;
		this.nMPlaceholdersSUtil = nMPlaceholdersSUtil;
		this.catalogueEventType = catalogueEventType;
	}

	
	public void sendNotification() throws Exception {
		log.info("send notification...");
		List<Notify> listNotifies = toNotify();

		for (Notify notify : listNotifies) {
			switch (notify.getType()) {
			case USER_POST:
				log.info("Notification type {}, send: {}", notify.getType(), notify.getSend());
				if (notify.getSend()) {
					log.debug("Building message...");
					String subject = "Message";
					String body = null;
					
					subject = nMPlaceholdersSUtil.replacePlaceholder(notify.getPlaceholder_title());
					body = nMPlaceholdersSUtil.replacePlaceholder(notify.getPlaceholder_msg());
					
					log.debug("subject: {}", subject);
					log.debug("body: {}", body);
					log.info("Sending message to users: {}", recipientUsers);
					
					postMessage(subject, body, catalogueEventType);

				}
				break;
			case VRE_POST:
				if (notify.getSend()) {
					log.info("Notification type {}, send: {}", notify.getType(), notify.getSend());
					PostInputBean toWrite = null;
					Post thePost = socialClients.writeUserPost(toWrite);
					log.info("{} post created: {} ", notify.getType(), thePost);
				}
				break;
			case EMAIL:
				break;

			default:
				break;
			}
		}

	}
	
	private List<Notify> toNotify() {
		List<Notify> listNotifies = new ArrayList<Notify>();
		for (NotificationWhen notificationWhen : listNotificationWhen) {
			listNotifies.addAll(notificationWhen.getNotify().stream().filter(n -> n.getSend() == true)
					.collect(Collectors.toList()));
		}
		return listNotifies;
	}
	
	protected void postMessage(String subject, String bodyMessage, CatalogueEventType catalogueEventType) throws Exception {
		CatalogueEvent catalogueEvent = getCatalogueEvent(subject, bodyMessage);
		SecretManager secretManager = SecretManagerProvider.instance.get();
		
		//GET geoportal SECRET
		
//		Secret secret = Constants.getCatalogueSecret();
//		if(notificationSentByGCat) {
//			secretManager.startSession(secret);
//		}
//		try {
//			sendNotification(catalogueEvent);
//		}finally {
//			if(notificationSentByGCat) {
//				secretManager.endSession();
//			}
//		}
		
		//sendNotification(catalogueEvent);
	}
	
	protected CatalogueEvent getCatalogueEvent(String subject, String bodyMessage) throws Exception {
		CatalogueEvent catalogueEvent = new CatalogueEvent();
		catalogueEvent.setType(catalogueEventType);
		catalogueEvent.setNotifyText(bodyMessage);
		catalogueEvent.setItemId(subject);
		String itemURL = nMPlaceholdersSUtil.getPlaceholderMapValues().getGisLink();
		if(itemURL!=null) {
			catalogueEvent.setItemURL(new URL(itemURL));
		}
		
		// Adding recipient users
		String[] usersToNotify = recipientUsers.stream().map(u -> u.getUsername()).toArray(String[]::new);
		catalogueEvent.setIdsToNotify(usersToNotify);
		catalogueEvent.setIdsAsGroup(false);
		
		return catalogueEvent;
	}

	
	protected void sendNotification(CatalogueEvent catalogueEvent) throws Exception {
		Thread thread = new Thread() {
		    public void run() {
		        try {
		        	log.trace("{} is going to send the following notification {}", SecretManagerProvider.instance.get().getUser().getUsername(), catalogueEvent);
		        	NotificationClient nc = socialClients.getNotificationClient();
		    		nc.sendCatalogueEvent(catalogueEvent);
		        } catch(Exception e) {
		            log.error("Error while sending notification.", e);
		        }
		    }  
		};
		// thread.run();
		thread.start();
	}
	
	protected CatalogueEvent toCatalogueEvent(CatalogueEventType catalogueEventType, String messageString, String subject, String itemURL, List<String> users) throws Exception {
		CatalogueEvent catalogueEvent = new CatalogueEvent();
		catalogueEvent.setType(catalogueEventType);
		catalogueEvent.setNotifyText(messageString);
		catalogueEvent.setItemId(subject);
		if(itemURL!=null) {
			catalogueEvent.setItemURL(new URL(itemURL));
		}
		catalogueEvent.setIdsToNotify(users.toArray(new String[users.size()]));
		catalogueEvent.setIdsAsGroup(false);
		
		return catalogueEvent;
	}



}
