/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.engine.bboxes;

import java.util.List;
import org.bson.Document;
import org.gcube.application.cms.sdi.engine.bboxes.BBOXEvaluator;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.JSONPathWrapper;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.GCubeSDILayer;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBOXByCoordinatePaths
extends BBOXEvaluator {
    private static final Logger log = LoggerFactory.getLogger(BBOXByCoordinatePaths.class);

    public BBOXByCoordinatePaths() {
        super("COORDINATES_PATH");
    }

    @Override
    public boolean isConfigured(Document profileConfiguration) {
        return profileConfiguration.containsKey((Object)"coordinatesPath");
    }

    @Override
    public GCubeSDILayer.BBOX evaluate(Document profileConfiguration, UseCaseDescriptor useCaseDescriptor, JSONPathWrapper documentNavigator) {
        List coordsConfig = (List)profileConfiguration.get((Object)"coordinatesPath", List.class);
        GCubeSDILayer.BBOX toSet = null;
        for (Object coordsObj : coordsConfig) {
            log.debug("UseCaseDescriptor {} : Evaluating coords {} ", (Object)useCaseDescriptor.getId(), coordsObj);
            CoordinatesPathBean bean = (CoordinatesPathBean)Serialization.convert(coordsObj, CoordinatesPathBean.class);
            if (bean.getX() != null) {
                for (Object o : documentNavigator.getByPath(bean.getX(), Object.class)) {
                    try {
                        Double x = Double.parseDouble(o.toString());
                        if (toSet == null) {
                            toSet = new GCubeSDILayer.BBOX();
                        }
                        if (toSet.getMinX() == null || x < toSet.getMinX()) {
                            toSet.setMinX(x);
                        }
                        if (toSet.getMaxX() != null && !(x > toSet.getMaxX())) continue;
                        toSet.setMaxX(x);
                    }
                    catch (Throwable t) {
                        log.warn("Unable to parse X (Matched value {} from path {}", new Object[]{o, bean.getX(), t});
                    }
                }
            }
            if (bean.getY() != null) {
                for (Object o : documentNavigator.getByPath(bean.getY(), Object.class)) {
                    try {
                        Double y = Double.parseDouble(o.toString());
                        if (toSet == null) {
                            toSet = new GCubeSDILayer.BBOX();
                        }
                        if (toSet.getMinY() == null || y < toSet.getMinY()) {
                            toSet.setMinY(y);
                        }
                        if (toSet.getMaxY() != null && !(y > toSet.getMaxY())) continue;
                        toSet.setMaxY(y);
                    }
                    catch (Throwable t) {
                        log.warn("Unable to parse Y (Matched value {} from path {}", new Object[]{o, bean.getY(), t});
                    }
                }
            }
            if (bean.getZ() == null) continue;
            for (Object o : documentNavigator.getByPath(bean.getZ(), Object.class)) {
                try {
                    Double z = Double.parseDouble(o.toString());
                    if (toSet == null) {
                        toSet = new GCubeSDILayer.BBOX();
                    }
                    if (toSet.getMinZ() == null || z < toSet.getMinZ()) {
                        toSet.setMinZ(z);
                    }
                    if (toSet.getMaxZ() != null && !(z > toSet.getMaxZ())) continue;
                    toSet.setMaxZ(z);
                }
                catch (Throwable t) {
                    log.warn("Unable to parse Z (Matched value {} from path {}", new Object[]{o, bean.getZ(), t});
                }
            }
        }
        return toSet;
    }

    public static class CoordinatesPathBean {
        private String x;
        private String y;
        private String z;

        public String getX() {
            return this.x;
        }

        public String getY() {
            return this.y;
        }

        public String getZ() {
            return this.z;
        }

        public void setX(String x) {
            this.x = x;
        }

        public void setY(String y) {
            this.y = y;
        }

        public void setZ(String z) {
            this.z = z;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CoordinatesPathBean)) {
                return false;
            }
            CoordinatesPathBean other = (CoordinatesPathBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$x = this.getX();
            String other$x = other.getX();
            if (this$x == null ? other$x != null : !this$x.equals(other$x)) {
                return false;
            }
            String this$y = this.getY();
            String other$y = other.getY();
            if (this$y == null ? other$y != null : !this$y.equals(other$y)) {
                return false;
            }
            String this$z = this.getZ();
            String other$z = other.getZ();
            return !(this$z == null ? other$z != null : !this$z.equals(other$z));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CoordinatesPathBean;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $x = this.getX();
            result = result * 59 + ($x == null ? 43 : $x.hashCode());
            String $y = this.getY();
            result = result * 59 + ($y == null ? 43 : $y.hashCode());
            String $z = this.getZ();
            result = result * 59 + ($z == null ? 43 : $z.hashCode());
            return result;
        }

        public String toString() {
            return "BBOXByCoordinatePaths.CoordinatesPathBean(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
        }
    }
}

