/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.engine;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.gcube.application.cms.sdi.faults.DataParsingException;
import org.gcube.application.cms.sdi.model.MappingObject;
import org.gcube.application.geoportal.common.model.legacy.BBOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgisTable {
    private static final Logger log = LoggerFactory.getLogger(PostgisTable.class);
    private static final NumberFormat DECIMAL_FORMAT = NumberFormat.getInstance(Locale.US);
    @NonNull
    private String tablename;
    @NonNull
    private List<Field> fields;
    @NonNull
    private GeometryType geometryColumnType;
    private BBOX boundingBox = null;
    private POINT centroid = null;

    public String getGeometryColumn() {
        for (Field f : this.fields) {
            if (!f.getType().equals((Object)FieldType.GEOMETRY)) continue;
            return f.getName();
        }
        return null;
    }

    public void setTablename(String tablename) {
        this.tablename = PostgisTable.sanitizeFieldName(tablename);
    }

    public String getCreateStatement() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("CREATE TABLE IF NOT EXISTS " + this.tablename + "( ");
        for (Field field : this.fields) {
            String fieldDefinition = field.getType().getDefinition();
            if (field.getType().equals((Object)FieldType.GEOMETRY)) {
                fieldDefinition = this.getGeometryColumnType().definition;
            }
            stmt.append(field.getName() + " " + fieldDefinition + ",");
        }
        stmt.deleteCharAt(stmt.lastIndexOf(","));
        stmt.append(")");
        return stmt.toString();
    }

    public String getDeleteByFieldStatement(Field field) {
        return "DELETE FROM " + this.tablename + " WHERE " + field.getName() + " =  ? ";
    }

    public String getInsertionStatement(boolean geometryText) {
        StringBuilder fieldList = new StringBuilder();
        StringBuilder fieldInsertion = new StringBuilder();
        block4: for (Field field : this.fields) {
            switch (field.getType()) {
                case AUTOINCREMENT: {
                    continue block4;
                }
                case GEOMETRY: {
                    fieldList.append(field.getName() + ",");
                    if (geometryText) {
                        fieldInsertion.append("ST_GeomFromText(?, 4326),");
                        continue block4;
                    }
                    fieldInsertion.append("ST_GeomFromWKB(?, 4326),");
                    continue block4;
                }
            }
            fieldList.append(field.getName() + ",");
            fieldInsertion.append("?,");
        }
        fieldList.deleteCharAt(fieldList.lastIndexOf(","));
        fieldInsertion.deleteCharAt(fieldInsertion.lastIndexOf(","));
        return "Insert into " + this.tablename + " (" + fieldList + ") VALUES (" + fieldInsertion + ")";
    }

    public void fillObjectsPreparedStatement(Map<String, Object> row, PreparedStatement toFill) throws SQLException {
        int psFieldIndex = 0;
        HashMap<String, Object> rowValues = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            rowValues.put(PostgisTable.sanitizeFieldName(entry.getKey()), entry.getValue());
        }
        for (Field field : this.fields) {
            if (field.getType().equals((Object)FieldType.AUTOINCREMENT)) continue;
            Object value = rowValues.get(field.getName());
            this.setObjectInPreparedStatement(field, value, toFill, ++psFieldIndex);
        }
    }

    public void setObjectInPreparedStatement(Field field, Object value, PreparedStatement toFill, int psFieldIndex) throws SQLException {
        if (value == null) {
            try {
                toFill.setNull(psFieldIndex, field.getType().sqlType);
            }
            catch (SQLException e) {
                log.error("Unable to set null for field " + field);
                throw e;
            }
        } else {
            switch (field.getType()) {
                case FLOAT: {
                    toFill.setFloat(psFieldIndex, ((Float)value).floatValue());
                    break;
                }
                case INT: {
                    toFill.setInt(psFieldIndex, (Integer)value);
                    break;
                }
                case TEXT: {
                    toFill.setString(psFieldIndex, value.toString());
                    break;
                }
                case GEOMETRY: {
                    if (value instanceof String) {
                        toFill.setString(psFieldIndex, (String)value);
                        break;
                    }
                    toFill.setBytes(psFieldIndex, (byte[])value);
                    break;
                }
                case BOOLEAN: {
                    if (value instanceof String) {
                        toFill.setBoolean(psFieldIndex, Boolean.parseBoolean(value.toString()));
                    }
                    if (!(value instanceof Boolean)) break;
                    toFill.setBoolean(psFieldIndex, (Boolean)value);
                    break;
                }
                default: {
                    if (value instanceof String) {
                        toFill.setString(psFieldIndex, (String)value);
                        break;
                    }
                    try {
                        String toStringValue = value.toString();
                        toFill.setString(psFieldIndex, toStringValue);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void fillCSVPreparedStatament(Map<String, String> row, PreparedStatement toFill, boolean explicitGeometry) throws SQLException {
        int psFieldIndex = 0;
        HashMap<String, String> rowValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : row.entrySet()) {
            rowValues.put(PostgisTable.sanitizeFieldName(entry.getKey()), entry.getValue());
        }
        for (Field field : this.fields) {
            if (field.getType().equals((Object)FieldType.AUTOINCREMENT)) continue;
            ++psFieldIndex;
            String value = (String)rowValues.get(field.getName());
            block2 : switch (field.getType()) {
                case FLOAT: {
                    try {
                        toFill.setFloat(psFieldIndex, Float.parseFloat(value));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException(field + " cannot be null.  CSV Row is " + rowValues, e);
                    }
                }
                case INT: {
                    try {
                        toFill.setInt(psFieldIndex, Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        log.warn("Skipping value for " + field + " row was " + rowValues, (Throwable)e);
                        toFill.setNull(psFieldIndex, 4);
                    }
                    break;
                }
                case TEXT: {
                    toFill.setString(psFieldIndex, value.toString());
                    break;
                }
                case GEOMETRY: {
                    if (explicitGeometry) {
                        toFill.setString(psFieldIndex, value);
                        break;
                    }
                    switch (this.geometryColumnType) {
                        case POINT: {
                            String xRepresentation = DECIMAL_FORMAT.format(Double.parseDouble((String)rowValues.get("xcoord")));
                            String yRepresentation = DECIMAL_FORMAT.format(Double.parseDouble((String)rowValues.get("ycoord")));
                            toFill.setString(psFieldIndex, "POINT(" + xRepresentation + " " + yRepresentation + ")");
                            break block2;
                        }
                    }
                    toFill.setString(psFieldIndex, (String)rowValues.get("wkt"));
                }
            }
        }
    }

    public static String sanitizeFieldName(String fieldName) {
        return fieldName.toLowerCase().replaceAll("[^a-z0-9_\\\\]", "_");
    }

    public PostgisTable(@NonNull String tablename, @NonNull List<Field> fields, @NonNull GeometryType geometryColumnType) {
        if (tablename == null) {
            throw new NullPointerException("tablename is marked @NonNull but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked @NonNull but is null");
        }
        if (geometryColumnType == null) {
            throw new NullPointerException("geometryColumnType is marked @NonNull but is null");
        }
        this.tablename = tablename;
        this.fields = fields;
        this.geometryColumnType = geometryColumnType;
    }

    @NonNull
    public String getTablename() {
        return this.tablename;
    }

    @NonNull
    public List<Field> getFields() {
        return this.fields;
    }

    @NonNull
    public GeometryType getGeometryColumnType() {
        return this.geometryColumnType;
    }

    public BBOX getBoundingBox() {
        return this.boundingBox;
    }

    public POINT getCentroid() {
        return this.centroid;
    }

    public String toString() {
        return "PostgisTable(tablename=" + this.getTablename() + ", fields=" + this.getFields() + ", geometryColumnType=" + (Object)((Object)this.getGeometryColumnType()) + ", boundingBox=" + this.getBoundingBox() + ", centroid=" + this.getCentroid() + ")";
    }

    public void setBoundingBox(BBOX boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void setCentroid(POINT centroid) {
        this.centroid = centroid;
    }

    static {
        ((DecimalFormat)DECIMAL_FORMAT).setGroupingUsed(false);
    }

    public static class POINT {
        private static Pattern pattern = Pattern.compile("(?!=\\d\\.\\d\\.)([\\d.]+)");
        @NonNull
        private Double x;
        @NonNull
        private Double y;

        public static POINT parsePOINT(String point) throws DataParsingException {
            try {
                log.debug("Parsing POINT " + point);
                Matcher m = pattern.matcher(point);
                if (!m.find()) {
                    throw new DataParsingException("Unable to get x ");
                }
                Double x = Double.parseDouble(m.group(1));
                if (!m.find()) {
                    throw new DataParsingException("Unable to get y ");
                }
                Double y = Double.parseDouble(m.group(1));
                return new POINT(x, y);
            }
            catch (Throwable t) {
                throw new DataParsingException("Invalid POINT " + point, t);
            }
        }

        public POINT(@NonNull Double x, @NonNull Double y) {
            if (x == null) {
                throw new NullPointerException("x is marked @NonNull but is null");
            }
            if (y == null) {
                throw new NullPointerException("y is marked @NonNull but is null");
            }
            this.x = x;
            this.y = y;
        }

        @NonNull
        public Double getX() {
            return this.x;
        }

        @NonNull
        public Double getY() {
            return this.y;
        }

        public String toString() {
            return "PostgisTable.POINT(x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }

    public static enum FieldType {
        INT("int", 4),
        BOOLEAN("boolean", 16),
        TEXT("text", -1),
        FLOAT("float", 6),
        GEOMETRY("", 0),
        AUTOINCREMENT("BIGSERIAL PRIMARY KEY", -5);

        private String definition;
        private int sqlType;

        public String getDefinition() {
            return this.definition;
        }

        public int getSqlType() {
            return this.sqlType;
        }

        private FieldType(String definition, int sqlType) {
            this.definition = definition;
            this.sqlType = sqlType;
        }
    }

    public static class Field {
        @NonNull
        private String name;
        @NonNull
        private FieldType type;
        private Boolean isIndexed;
        private Object constantValue;

        public static final Field fromMapping(MappingObject m) {
            return new Field(m.getName(), FieldType.valueOf(m.getType()));
        }

        public static final List<Field> fromMappings(Collection<MappingObject> coll) {
            ArrayList<Field> toReturn = new ArrayList<Field>();
            if (coll != null) {
                coll.forEach(m -> toReturn.add(Field.fromMapping(m)));
            }
            return toReturn;
        }

        public Field(@NonNull String name, @NonNull FieldType type) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.name = name;
            this.type = type;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public FieldType getType() {
            return this.type;
        }

        public Boolean getIsIndexed() {
            return this.isIndexed;
        }

        public Object getConstantValue() {
            return this.constantValue;
        }

        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
        }

        public void setType(@NonNull FieldType type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.type = type;
        }

        public void setIsIndexed(Boolean isIndexed) {
            this.isIndexed = isIndexed;
        }

        public void setConstantValue(Object constantValue) {
            this.constantValue = constantValue;
        }

        public String toString() {
            return "PostgisTable.Field(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", isIndexed=" + this.getIsIndexed() + ", constantValue=" + this.getConstantValue() + ")";
        }
    }

    public static enum GeometryType {
        MULTIPOINT("4326", "geometry (MULTIPOINT,4326)", "", ""),
        POINT("4326", "geometry (POINT,4326)", "", ""),
        LINE("4326", "geometry (MULTILINESTRING,4326)", "", ""),
        POLYGON("4326", "geometry (MULTIPOLYGON,4326)", "", "");

        private final String SRID;
        private final String definition;
        private final String InsertWKT;
        private final String insertWKB;

        public String getSRID() {
            return this.SRID;
        }

        public String getDefinition() {
            return this.definition;
        }

        public String getInsertWKT() {
            return this.InsertWKT;
        }

        public String getInsertWKB() {
            return this.insertWKB;
        }

        private GeometryType(String SRID, String definition, String InsertWKT, String insertWKB) {
            this.SRID = SRID;
            this.definition = definition;
            this.InsertWKT = InsertWKT;
            this.insertWKB = insertWKB;
        }
    }
}

