/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.enabling.Impl.crawler;

import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.enabling.Impl.crawler.ISCrawler;
import org.gcube.common.core.scope.GCUBEScope;

public class PortalCrawler
extends ISCrawler {
    public PortalCrawler(int minutes, int gcMinutes, boolean enableGCForceing) throws Exception {
        this.forceUpdate();
        this.schedule(minutes, gcMinutes, enableGCForceing);
    }

    @Override
    protected ArrayList<GCUBEScope> findAvailableScopes(GCUBEScope Infrastructure) throws Exception {
        ArrayList<GCUBEScope> toReturn = new ArrayList<GCUBEScope>();
        logger.trace((Object)"CHECKING SCOPES, PORTAL MODE IS ON");
        toReturn.add(Infrastructure);
        List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        Organization rootOrganization = null;
        for (Organization organization : organizations) {
            if (!organization.getName().equals(Infrastructure.getName())) continue;
            rootOrganization = organization;
            break;
        }
        if (rootOrganization == null) {
            throw new Exception("Unable to find infrastructure scope " + Infrastructure.getName() + " among organizations");
        }
        for (Organization vOrg : rootOrganization.getSuborganizations()) {
            String VOScopeString = "/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName();
            try {
                toReturn.add(GCUBEScope.getScope((String)VOScopeString));
                for (Organization vre : vOrg.getSuborganizations()) {
                    String VREScopeString = VOScopeString + "/" + vre.getName();
                    try {
                        toReturn.add(GCUBEScope.getScope((String)VREScopeString));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to Find a scope for the organization " + VREScopeString));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to Find a scope for the organization " + VOScopeString));
            }
        }
        return toReturn;
    }

    @Override
    protected boolean isCheckInternalDB() {
        return false;
    }

    @Override
    protected boolean isCheckGisDatabase() {
        return false;
    }

    @Override
    protected boolean isCheckPublisherDatabase() {
        return false;
    }

    @Override
    protected boolean isCheckRunningInstance() {
        return true;
    }
}

