package org.gcube.application.aquamaps.enabling.Impl.crawler;

import java.util.ArrayList;
import java.util.HashSet;

import org.gcube.application.aquamaps.enabling.util.ParserXPath;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.Type;

public class ServiceCrawler extends ISCrawler {

	
	public ServiceCrawler(int minutes,int gcMinutes,boolean enableGCForceing) throws Exception {
		forceUpdate();
		schedule(minutes, gcMinutes,enableGCForceing);
	}
	
	/**
	 * Finds accessible scopes from current ghn context
	 */
	@Override
	protected ArrayList<GCUBEScope> findAvailableScopes(
			GCUBEScope Infrastructure) throws Exception {
		HashSet<GCUBEScope> toReturn=new HashSet<GCUBEScope>();
		for(GCUBEScope scope : GHNContext.getContext().getStartScopes()){
			toReturn.add(scope);
			toReturn.addAll(getChildren(scope));
		}
		for(GCUBEScope scope :GHNContext.getContext().getStartScopes()){
			toReturn.add(scope);
			toReturn.addAll(getChildren(scope));
		}
		toReturn.add(Infrastructure);
		return new ArrayList<GCUBEScope>(toReturn);
	}

	/**
	 * Queries IS for generic resources describing children of the given scope
	 * 
	 * @param scope
	 * @return
	 * @throws Exception
	 */
	protected ArrayList<GCUBEScope> getChildren(GCUBEScope scope)throws Exception{
		ArrayList<GCUBEScope> toReturn=new ArrayList<GCUBEScope>();
		if(!scope.getType().equals(Type.VRE)){
			logger.debug("Retrieving children of scope "+scope+", ("+scope.getType()+")");
			GCUBEGenericResourceQuery scopeQuery=isClient.getQuery(GCUBEGenericResourceQuery.class);
			String secondaryType=scope.getType().equals(Type.VO)?"VRE":"VO";		
			scopeQuery.addAtomicConditions(new AtomicCondition("//Profile/SecondaryType", secondaryType));
			for(GCUBEGenericResource res:isClient.execute(scopeQuery, scope)){
				try{
					String foundScope=ParserXPath.getTextFromXPathExpression("<rootNode>"+res.getBody()+"</rootNode>", "//Scope").get(0);
					toReturn.add(GCUBEScope.getScope(foundScope));
				}catch(Exception e){
					logger.warn("Unable to detect scope from generic resource [ID : "+res.getID()+"] under scope "+scope,e);
				}
			}
		}
		return toReturn;
	}

	@Override
	protected boolean isCheckInternalDB() {
		return true;
	}

	@Override
	protected boolean isCheckGisDatabase() {
		return true;
	}

	@Override
	protected boolean isCheckPublisherDatabase() {
		return true;
	}

	@Override
	protected boolean isCheckRunningInstance() {
		return false;
	}
}
