
package org.gcube.common.gxrest.response.outbound;

/**
 * A local exception wrapping an {@link ErrorCode}.
 * 
 * @author Manuele Simi (ISTI CNR)
 * @author Luca Frosini (ISTI-CNR)
 *
 */
public class LocalCodeException extends Exception implements ErrorCode {
	
	private static final long serialVersionUID = 1872093579811881630L;
	/** The id of the error. */
	private final int id;
	/** The message of the error. */
	private final String message;

	/**
	 * Creates a new local code exception.
	 *
	 * @param code the error code
	 */
	public LocalCodeException(ErrorCode code) {
		super();
		this.id = code.getId();
		this.message = code.getMessage();
	}

	public int getId() {
		return id;
	}

	public String getMessage() {
		return message;
	}
}
