package org.gcube.common.quota.service;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.common.quota.library.QuotaList;
import org.gcube.common.quota.library.quotalist.Quota;
import org.gcube.common.quota.persistence.QuotaDBPersistence;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Manage quota into persistence
 * @author Alessandro Pieve (alessandro.pieve@isti.cnr.it)
 *
 */
@Path("quotaManager")
public class QuotaManager {
	
	private static Logger log = LoggerFactory.getLogger(QuotaManager.class);
	QuotaDBPersistence quotaPersistence=QuotaDBPersistence.getInstance();	
		
	@POST
	@Consumes(MediaType.TEXT_XML)
	@Path("/insert/")
	public Response insertQuote(QuotaList quote) {
		try{
			log.debug("insert quote: {}", quote.getQuotaList().toString());
			quotaPersistence.addQuote(quote.getQuotaList());
		}catch(Exception e){
			log.error("error insert quote",e);
			throw new WebApplicationException(Response.status(Response.Status.BAD_REQUEST)
		             .entity("Error insert quote: "+e.getMessage()).type(MediaType.TEXT_PLAIN).build());
		}
		return Response.ok().build();
	}	
	
	@GET
	@Path("/detail/{quota_id}")	
	@Produces(MediaType.TEXT_XML)
	public Quota getDetailQuota(@NotNull @PathParam("quota_id") long quotaId) {
		try{
			log.info("retrieving detail quote {}",quotaId);
			Quota quota =quotaPersistence.getQuota(quotaId);
			log.info("quota {}",quota);
			return quota;
		}catch(Exception e){
			throw new WebApplicationException(Response.status(Response.Status.BAD_REQUEST)
					.entity("Error : "+e.getMessage()).type(MediaType.TEXT_PLAIN).build()); 
		}
	}

	@DELETE		
	@Path("/remove/{quota_id}")
	public Response removeQuota(@Null @PathParam("quota_id") long quotaId) {
		try{
			log.info("removing quota with id {}", quotaId);
			quotaPersistence.removeQuota(quotaId);			
		}catch(Exception e){
			log.error("error removing quota", e);
			throw new WebApplicationException(Response.status(Response.Status.BAD_REQUEST)
		             .entity("Error removing quota: "+e.getMessage()).type(MediaType.TEXT_PLAIN).build());
		}
		return Response.ok().build();
	}
	
	
	
	@GET	
	@Produces(MediaType.APPLICATION_XML)
	@Path("/")
	
	/** TODO togliere il contesto perche lo riprendo dal token  chiedere per vedere come integrarlo a LUCIO */
	public QuotaList getQuotePerContext() {
		String context = ScopeProvider.instance.get();
		try{
			log.info("retrieving quote in context {}", context);
			return new QuotaList(quotaPersistence.getQuote(context));
		}catch(Exception e){
			log.error("error retrieving quote per context {}", context, e);
			throw new WebApplicationException(Response.status(Response.Status.BAD_REQUEST)
		             .entity("Error retrieving quote: "+e.getMessage()).type(MediaType.TEXT_PLAIN).build());
		}
	}
	
}


