package org.gcube.common.quota.check;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.status.QuotaStorageStatus;
import org.gcube.common.quota.util.ConstantsDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaUsage {
	private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);	    
	 public QuotaUsage() {};
	    
	 public void insertStorageQuota(String identifier, Double quotaAssigned, Double quotaUsage, TemporalConstraint temporalConstraint) throws SQLException {
	        Connection connection = getDBConnection();
	        Statement stmt = null;
	        try {
	        	connection.setAutoCommit(false);
	            stmt = connection.createStatement();
	            String periodQuota=ConstantsDb.DATABASE_PERIOD_TOTAL;
	            if (temporalConstraint!=null){
	            	periodQuota=temporalConstraint.getAggregationMode().toString();
	            }
	            if (!verifyTable(connection,ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE+
	            		ConstantsDb.SEPARATOR+periodQuota)){
	            	String queryCreate="CREATE TABLE "+ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE+ConstantsDb.SEPARATOR+periodQuota+""
    	            		+ "(IDENTIFIER varchar(255) primary key,QUOTAASSIGNED double, QUOTAUSAGE double)";
	            	log.debug("Create table:{}",queryCreate);
	            	stmt.execute(queryCreate);
	            		
	            }
	            String queryInsert="REPLACE into "+ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE+ConstantsDb.SEPARATOR+periodQuota+""
	            		+ " (IDENTIFIER, QUOTAASSIGNED, QUOTAUSAGE)  VALUES('"+identifier+"',"
	            		+quotaAssigned+","+quotaUsage+")";
	            log.debug("Insert data into table:{}",queryInsert);
	            stmt.execute(queryInsert);
	            stmt.close();
	            connection.commit();
	        } catch (SQLException e) {
	            System.out.println("Exception Message " + e.getLocalizedMessage());
	        } catch (Exception e) {
	            e.printStackTrace();
	        } finally {
	            connection.close();
	        }
	 } 
	 
	 
	 public  QuotaStorageStatus selectStorageQuota(String identifier, TimeInterval interval)throws SQLException {
		 Connection connection = getDBConnection();
		 QuotaStorageStatus quotaStorageStatus = null;
	        Statement stmt = null;
	        try {
	            connection.setAutoCommit(false);
	            stmt = connection.createStatement();
	            String periodQuota=ConstantsDb.DATABASE_PERIOD_TOTAL;
	            Double quotaAssigned = 0.0;
	            Double quotaUsage=0.0;
	            //Quota Storage Total
	            if (interval.equals(TimeInterval.FOREVER)){
	        	   String query="SELECT * FROM "+ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE+ConstantsDb.SEPARATOR+periodQuota+""
		            		+ " WHERE IDENTIFIER='"+identifier+"'";
	        	   ResultSet rs = stmt.executeQuery(query);
	        	   
	        	   while (rs.next()) {
	                   quotaAssigned=rs.getDouble("QUOTAASSIGNED");
	                   quotaUsage=rs.getDouble("QUOTAUSAGE");
	               }
	            }
	      
	            stmt.close();
	            connection.commit();
	            quotaStorageStatus =new QuotaStorageStatus(identifier,interval,quotaAssigned,quotaUsage);
	        } catch (SQLException e) {
	            System.out.println("Exception Message " + e.getLocalizedMessage());
	        } catch (Exception e) {
	            e.printStackTrace();
	        } finally {
	            connection.close();
	        }
			return quotaStorageStatus;
		 
		 
	 }
	 
	 
	 
	  
	  
	  private Connection getDBConnection() {
	        Connection dbConnection = null;
	        try {
	            Class.forName(ConstantsDb.DB_DRIVER);
	        } catch (ClassNotFoundException e) {
	            System.out.println(e.getMessage());
	        }
	        try {
	            dbConnection = DriverManager.getConnection(ConstantsDb.DB_CONNECTION, ConstantsDb.DB_USER,
	            		ConstantsDb.DB_PASSWORD);
	            return dbConnection;
	        } catch (SQLException e) {
	            System.out.println(e.getMessage());
	        }
	        return dbConnection;
	  }
	  
	  private Boolean verifyTable(Connection connection, String tableName) throws SQLException{
		  log.trace("verifyTable :{}",tableName);
		  boolean tExists = false;
            try (ResultSet rs = connection.getMetaData().getTables(null,null,tableName, null)) {
                try {
					while (rs.next()) { 
					    String tName = rs.getString("TABLE_NAME");
					    if (tName != null && tName.equals(tableName)) {
					        tExists = true;
					        break;
					    }
					}
				} catch (SQLException e) {
					e.printStackTrace();
				}
            }
            return tExists;
	  }
	
}
