/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.quota.persistence.entities;

import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.gcube.common.quota.library.quotalist.CallerType;
import org.gcube.common.quota.library.quotalist.TimeInterval;

@Entity
@Inheritance
@DiscriminatorColumn(name="QuotaType")
@Table(name="Quota")
@NamedQueries(value={@NamedQuery(name="Quota.all", query="SELECT quota FROM QuotaEntity quota WHERE   quota.context=:context"), @NamedQuery(name="Quota.getByIdentifier", query="SELECT quota FROM QuotaEntity quota WHERE   quota.identifier=:identifier"), @NamedQuery(name="Quota.getSpecified", query="SELECT quota FROM QuotaEntity quota WHERE  quota.identifier=:identifier and quota.context=:context and quota.quotaType=:quotaType and quota.timeInterval=:timeInterval")})
public abstract class QuotaEntity {
    @Column
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected long id;
    @Column(nullable=true)
    protected String context;
    @Column(name="QuotaType")
    private String quotaType;
    @Column(nullable=true)
    protected String identifier;
    @Column(nullable=true)
    protected CallerType callerType;
    @Column(nullable=true)
    protected TimeInterval timeInterval;
    @Column(nullable=true)
    protected Double quotaValue;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=true)
    protected Calendar creationTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=true)
    protected Calendar lastUpdateTime;

    protected QuotaEntity() {
    }

    public QuotaEntity(String context, String quotaType, String identifier, CallerType callerType, TimeInterval timeInterval, Double quotaValue) {
        Calendar now;
        this.quotaType = quotaType;
        this.context = context;
        this.callerType = callerType;
        this.identifier = identifier;
        this.timeInterval = timeInterval;
        this.quotaValue = quotaValue;
        this.creationTime = now = Calendar.getInstance();
        this.lastUpdateTime = now;
    }

    public long getId() {
        return this.id;
    }

    public String getContext() {
        return this.context;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public CallerType getCallerType() {
        return this.callerType;
    }

    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public Double getQuotaValue() {
        return this.quotaValue;
    }

    public Calendar getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Calendar lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Calendar getCreationTime() {
        return this.creationTime;
    }

    public String getQuotaType() {
        return this.quotaType;
    }
}

