package org.gcube.common.quota.check;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.gcube.accounting.analytics.Filter;
import org.gcube.common.quota.library.quotalist.TimeInterval;
import org.gcube.common.quota.library.status.QuotaStorageStatus;
import org.gcube.common.quota.util.ConstantsDb;
import org.gcube.common.quota.util.QuotaUsageServiceValue;
import org.gcube.common.quota.util.QuotaUsageStorageValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaUsage {
	
	 private static Logger log = LoggerFactory.getLogger(QuotaCheck.class);	    
	 public QuotaUsage() {};
	 
	 
	 public void insertServiceQuota(QuotaUsageServiceValue usageSerVal) throws SQLException {
	        
		 //manca access type	 
		 String context_label=usageSerVal.getContext().replace('/', '_').toUpperCase();
		 	Connection connection = getDBConnection();
	        Statement stmt = null;
	        try {
	        	connection.setAutoCommit(false);
	        	stmt = connection.createStatement();
	            String periodQuota=usageSerVal.getTemporalConstraint().getAggregationMode().toString();
	            if (!verifyTable(connection,ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE_SERVICE+ConstantsDb.SEPARATOR+
	            		context_label+ConstantsDb.SEPARATOR+periodQuota)){
	            	 String queryCreate="CREATE TABLE "+ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE_SERVICE+ConstantsDb.SEPARATOR+
	 	            		context_label+ConstantsDb.SEPARATOR+periodQuota+""
	  	            		+ "(CALLERTYPE varchar(255),IDENTIFIER varchar(255) ,SERVICE varchar(255),"
	  	            		+ "ACCESSTYPE varchar(50),QUOTAASSIGNED double, QUOTAUSAGE double,POLICY integer,"
	  	            		+ "primary key(CALLERTYPE,IDENTIFIER,SERVICE))";
	 	            stmt.execute(queryCreate);
	            }
	            
	            String serviceIdentifier = "";
	            for (Filter tmp:usageSerVal.getFilters()){
	            	serviceIdentifier=serviceIdentifier+tmp.getValue()+":";
	            }
	            //TODO Definire quale service id bisogna passare
	            serviceIdentifier=serviceIdentifier+"0";
	          
	            String queryInsert="REPLACE into "+ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE_SERVICE+ConstantsDb.SEPARATOR+
	            		context_label+ConstantsDb.SEPARATOR+periodQuota+""
	            		+ " (CALLERTYPE,IDENTIFIER, SERVICE,ACCESSTYPE,QUOTAASSIGNED, QUOTAUSAGE)  VALUES('"+usageSerVal.getCallerType()+"',"
	            		+ "'"+usageSerVal.getIdentifier()+"','"+serviceIdentifier+"',"
	            		+"'"+usageSerVal.getAccessType()+"'," 		+usageSerVal.getdQuota()+","+usageSerVal.getD()+")";
	            log.debug("Insert data into table:{}",queryInsert);
	            stmt.execute(queryInsert);
	            
	            stmt.close();
	            connection.commit();
	       
	        } catch (SQLException e) {
	            log.error("Exception Message " + e.getLocalizedMessage());
	        	
	        } catch (Exception e) {
	            e.printStackTrace();
	        } finally {
	           connection.close();
	        }
	        
	 } 
	 
	 public void insertStorageQuota(QuotaUsageStorageValue usageStorVal) throws SQLException {		 
		
	        Connection connection = getDBConnection();
	        Statement stmt = null;
	        try {
	        	connection.setAutoCommit(false);
	            stmt = connection.createStatement();
	            String periodQuota=ConstantsDb.DATABASE_PERIOD_TOTAL;
	            if (usageStorVal.getTemporalConstraint()!=null){
	            	periodQuota=usageStorVal.getTemporalConstraint().getAggregationMode().toString();
	            }
	            if (!verifyTable(connection,ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE_STORAGE+
	            		ConstantsDb.SEPARATOR+periodQuota)){
	            	String queryCreate="CREATE TABLE "+ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE_STORAGE+ConstantsDb.SEPARATOR+periodQuota+""
    	            		+ "(IDENTIFIER varchar(255) primary key,QUOTAASSIGNED double, QUOTAUSAGE double)";
	            	log.debug("Create table:{}",queryCreate);
	            	stmt.execute(queryCreate);
	            		
	            }
	            String queryInsert="REPLACE into "+ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE_STORAGE+ConstantsDb.SEPARATOR+periodQuota+""
	            		+ " (IDENTIFIER, QUOTAASSIGNED, QUOTAUSAGE)  VALUES('"+usageStorVal.getIdentifier()+"',"
	            		+usageStorVal.getdQuota()+","+usageStorVal.getD()+")";
	            log.debug("Insert data into table:{}",queryInsert);
	            stmt.execute(queryInsert);
	            stmt.close();
	            connection.commit();
	        } catch (SQLException e) {
	            log.error("Exception Message " + e.getLocalizedMessage());

	        } catch (Exception e) {
	            e.printStackTrace();
	        } finally {
	            connection.close();
	        }
	 } 
	 
	 
	 public  QuotaStorageStatus selectStorageQuota(String identifier, TimeInterval interval)throws SQLException {
		 Connection connection = getDBConnection();
		 QuotaStorageStatus quotaStorageStatus = null;
	        Statement stmt = null;
	        try {
	            connection.setAutoCommit(false);
	            stmt = connection.createStatement();
	            String periodQuota=ConstantsDb.DATABASE_PERIOD_TOTAL;
	            Double quotaAssigned = 0.0;
	            Double quotaUsage=0.0;
	            //Quota Storage Total
	            if (interval.equals(TimeInterval.FOREVER)){
	        	   String query="SELECT * FROM "+ConstantsDb.DATABASE_PREFIX+ConstantsDb.SEPARATOR+ConstantsDb.DATABASE_TYPE_STORAGE+ConstantsDb.SEPARATOR+periodQuota+""
		            		+ " WHERE IDENTIFIER='"+identifier+"'";
	        	   ResultSet rs = stmt.executeQuery(query);
	        	   
	        	   while (rs.next()) {
	                   quotaAssigned=rs.getDouble("QUOTAASSIGNED");
	                   quotaUsage=rs.getDouble("QUOTAUSAGE");
	               }
	            }
	      
	            stmt.close();
	            connection.commit();
	            quotaStorageStatus =new QuotaStorageStatus(identifier,interval,quotaAssigned,quotaUsage);
	        } catch (SQLException e) {
	            log.error("Exception Message " + e.getLocalizedMessage());

	        } catch (Exception e) {
	            e.printStackTrace();
	        } finally {
	            connection.close();
	        }
			return quotaStorageStatus;
		 
		 
	 }
	 
	 
	 
	  
	  
	  private Connection getDBConnection() {
	        Connection dbConnection = null;
	        try {
	            Class.forName(ConstantsDb.DB_DRIVER);
	        } catch (ClassNotFoundException e) {
	            System.out.println(e.getMessage());
	        }
	        try {
	            dbConnection = DriverManager.getConnection(ConstantsDb.DB_CONNECTION, ConstantsDb.DB_USER,
	            		ConstantsDb.DB_PASSWORD);
	            return dbConnection;
	        } catch (SQLException e) {
	            log.error("Exception Message " + e.getMessage());
	        }
	        return dbConnection;
	  }
	  
	  private Boolean verifyTable(Connection connection, String tableName) throws SQLException{
		  log.trace("verifyTable :{}",tableName);
		  boolean tExists = false;
            try (ResultSet rs = connection.getMetaData().getTables(null,null,tableName, null)) {
                try {
					while (rs.next()) { 
					    String tName = rs.getString("TABLE_NAME");
					    if (tName != null && tName.equals(tableName)) {
					        tExists = true;
					        break;
					    }
					}
				} catch (SQLException e) {
					e.printStackTrace();
				}
            }
            return tExists;
	  }
	
}
