/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.model.trees;

import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;

public final class Leaf
extends Node {
    private String value;

    public Leaf(Leaf l) {
        this(l.id(), l.state(), l.value(), l.attributes());
    }

    public Leaf(String id) {
        this(id, null, null, null);
    }

    public Leaf(String id, String v) {
        this(id, null, v, null);
    }

    public Leaf(String v, Map<QName, String> attributes) {
        this(null, null, v, attributes);
    }

    public Leaf(String id, Node.State state, String v, Map<QName, String> attributes) {
        super(id, state, attributes);
        this.value(v);
    }

    public synchronized String value() {
        return this.value;
    }

    public synchronized void value(String v) throws IllegalArgumentException {
        this.value = v;
    }

    @Override
    protected synchronized void delete() {
        super.delete();
        this.value = null;
    }

    @Override
    protected synchronized Leaf delta(Node f) throws IllegalArgumentException {
        Leaf delta = (Leaf)super.delta(f);
        Leaf future = (Leaf)f;
        if (this.value == null && future.value() != null || !this.value.equals(future.value())) {
            delta.value(future.value());
            delta.state(Node.State.MODIFIED);
        }
        return delta;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[").append(this.state() == null ? "" : this.state().name() + " ").append(this.id() == null ? "" : "id:" + (this.id().length() > 3 ? this.id().substring(0, Math.min(this.id().length(), 3)) + ".." : this.id()) + " ");
        for (Map.Entry<QName, String> attr : this.attributes().entrySet()) {
            b.append("@" + attr.getKey() + "=" + attr.getValue() + " ");
        }
        b.append(this.value != null && this.value.length() > 100 ? this.value.substring(0, 99) + "...(and other " + this.value.length() + " chars)" : this.value).append("]");
        return b.toString();
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof Leaf)) {
            return false;
        }
        return super.equals(obj) && this.value() == null ? ((Leaf)obj).value() == null : this.value().equals(((Leaf)obj).value());
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode() + 31 * (super.hashCode() + 527);
    }
}

