/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.stubs.model.predicates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.AtLeast;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.EdgePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.LeafPredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Many;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.One;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Only;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Opt;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Nodes;

@XmlRootElement(name="t")
@XmlType(propOrder={"idPredicate", "predicates"})
public class TreePredicate
implements Predicate {
    private static final long serialVersionUID = 1L;
    private LeafPredicate<?, ?> idp = null;
    @XmlElementRefs(value={@XmlElementRef(type=One.class), @XmlElementRef(type=Many.class), @XmlElementRef(type=Only.class), @XmlElementRef(type=AtLeast.class), @XmlElementRef(type=Opt.class)})
    List<EdgePredicate> predicates = new ArrayList<EdgePredicate>();

    TreePredicate() {
    }

    public TreePredicate(List<EdgePredicate> predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean matches(Node n) {
        try {
            InnerNode node = (InnerNode)n;
            if (this.idp != null && !this.idp.matches(Nodes.l(node.id()))) {
                return false;
            }
            List<Edge> unmatched = node.edges();
            for (EdgePredicate ep : this.predicates) {
                List<Edge> candidates;
                if (!ep.matches(candidates = ep.matchLabels(unmatched))) {
                    return false;
                }
                unmatched.removeAll(candidates);
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @Override
    public void prune(Node n) throws Exception {
        try {
            InnerNode node = (InnerNode)n;
            if (this.idp != null) {
                this.idp.prune(Nodes.l(node.id()));
            }
            if (this.predicates.size() == 0) {
                return;
            }
            List<Edge> unmatched = node.edges();
            for (EdgePredicate ep : this.predicates) {
                List<Edge> candidates = ep.matchLabels(unmatched);
                List<Edge> matched = ep.prune(candidates);
                if (ep.isCondition()) {
                    node.remove(matched);
                }
                unmatched.removeAll(matched);
            }
            node.remove(unmatched);
        }
        catch (ClassCastException e) {
            throw new Exception(this + " found an unexpected leaf " + n);
        }
    }

    @XmlTransient
    public List<EdgePredicate> getPredicates() {
        return this.predicates;
    }

    public EdgePredicate getPredicate(QName label) {
        for (EdgePredicate ep : this.predicates) {
            if (!ep.label().equals(label)) continue;
            return ep;
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[ ");
        if (this.idp != null) {
            b.append("(id:" + this.idp + ") ");
        }
        for (EdgePredicate ep : this.predicates) {
            b.append("(" + ep + ") ");
        }
        b.append("]");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TreePredicate)) {
            return false;
        }
        HashSet<EdgePredicate> s1 = new HashSet<EdgePredicate>(this.predicates);
        HashSet<EdgePredicate> s2 = new HashSet<EdgePredicate>(((TreePredicate)obj).predicates);
        return s1.equals(s2);
    }

    public int hashCode() {
        return this.predicates == null ? 0 : ((Object)this.predicates).hashCode() + 527;
    }

    public void setIdPredicate(LeafPredicate<?, ?> idp) {
        this.idp = idp;
    }

    @XmlElement(name="id")
    public LeafPredicate<?, ?> getIdPredicate() {
        return this.idp;
    }
}

