/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates;

import java.util.Calendar;
import java.util.LinkedList;
import org.apache.axis.encoding.Base64;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Nodes;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ReferenceTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.util.SMSPrintUtil;

public class DocumentConversionUtil {
    public static final String CONTENTMANAGER_METADATA_NAME = "contentmanagement:metadata_name";
    public static final String CONTENTMANAGER_METADATA_LANGUAGE = "contentmanagement:metadata_language";
    public static final String CONTENTMANAGER_METADATA_SCHEMA = "contentmanagement:metadata_schema";
    public static final String CONTENTMANAGER_TYPE = "contentmanagement:type";
    public static final String CONTENTMANAGER_ANNOTATION_PREVIOUS = "contentmanagement:annotation_previous";
    public static final String CONTENTMANAGER_BYTESTREAM_URI = "bytestream_uri";
    public static final String SECONDARY_ROLE_METADATA = "is-described-by";
    protected static GCUBELog logger = new GCUBELog(DocumentConversionUtil.class);

    public static GDoc convertToGDoc(String collectionId, InfoObjectTree tree) throws Exception {
        if (!DocumentConversionUtil.checkIsMainDocument(tree)) {
            logger.error((Object)("The requested IO is not a DOCUMENT, type: " + tree.getType()));
            throw new Exception("The request IO is not a document.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"InfoObjectTree: ");
            SMSPrintUtil.printAsTree((InfoObjectTree)tree, (GCUBELog)logger);
        }
        GDoc document = new GDoc(collectionId, tree.getObjectID(), new Edge[0]);
        DocumentConversionUtil.fillInnerNode(tree, (InnerNode)document);
        return document;
    }

    public static boolean checkIsMainDocument(InfoObjectTree io) {
        return "contentmanagement:document".equals(io.getType());
    }

    protected static void fillInnerNode(InfoObjectTree info, InnerNode node) {
        LinkedList<Edge> properties = new LinkedList<Edge>();
        logger.trace((Object)"Properties:");
        PropertyDescription[] objectProperties = info.getProperties();
        if (objectProperties != null) {
            for (PropertyDescription pd : objectProperties) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("name: " + pd.getName() + " value: " + pd.getValue() + " type: " + pd.getType()));
                }
                String name = pd.getName();
                String value = pd.getValue();
                if (name == null || value == null) continue;
                if (name.equals("contentmanagement:ObjectName")) {
                    properties.add(DocumentConversionUtil.convertProperty("name", pd));
                    continue;
                }
                if (name.equals("contentmanagement:ObjectCreatedMillis")) {
                    properties.add(DocumentConversionUtil.convertProperty("creationTime", pd));
                    continue;
                }
                if (name.equals("contentmanagement:ObjectLastModificationMillis")) {
                    properties.add(DocumentConversionUtil.convertProperty("lastUpdateTime", pd));
                    continue;
                }
                if (name.equals("contentmanagement:LengthOfRawContent")) {
                    properties.add(DocumentConversionUtil.convertProperty("length", pd));
                    continue;
                }
                if (name.equals("contentmanagement:MimeType")) {
                    properties.add(DocumentConversionUtil.convertProperty("mimeType", pd));
                    continue;
                }
                if (name.equals("contentmanagement:ContentUrl")) {
                    properties.add(DocumentConversionUtil.convertProperty("url", pd));
                    continue;
                }
                if (name.equals(CONTENTMANAGER_METADATA_SCHEMA)) {
                    properties.add(DocumentConversionUtil.convertProperty("schemaURI", pd));
                    continue;
                }
                if (name.equals(CONTENTMANAGER_METADATA_LANGUAGE)) {
                    properties.add(DocumentConversionUtil.convertProperty("language", pd));
                    continue;
                }
                if (name.equals(CONTENTMANAGER_METADATA_NAME)) {
                    properties.add(DocumentConversionUtil.convertProperty("schemaName", pd));
                    continue;
                }
                if (name.equals(CONTENTMANAGER_TYPE)) {
                    properties.add(DocumentConversionUtil.convertProperty("type", pd));
                    continue;
                }
                if (name.equals(CONTENTMANAGER_ANNOTATION_PREVIOUS)) {
                    properties.add(DocumentConversionUtil.convertProperty("previous", pd));
                    continue;
                }
                if (name.equals(CONTENTMANAGER_BYTESTREAM_URI)) {
                    properties.add(DocumentConversionUtil.convertProperty("url", pd));
                    continue;
                }
                properties.add(DocumentConversionUtil.convertToPropertyNode(pd));
            }
        }
        logger.trace((Object)"RawContent:");
        if (info.getRawContent() != null) {
            logger.trace((Object)"rawcontent present, adding content");
            String content = Base64.encode((byte[])info.getRawContent());
            properties.add(Nodes.e((String)"bytestream", (Node)Nodes.l((String)"bytestream", (Object)content)));
        } else {
            logger.trace((Object)"rawcontent null");
        }
        node.add(properties);
        LinkedList<Edge> edges = new LinkedList<Edge>();
        if (info.getReferences() != null) {
            for (ReferenceTree reference : info.getReferences()) {
                InfoObjectTree target = reference.getTargetObject();
                if ("contentmanagement:is-represented-by".equals(reference.getRole()) && reference.getSecondaryRole() == null) {
                    InnerNode alternative = new InnerNode(target.getObjectID());
                    DocumentConversionUtil.fillInnerNode(target, alternative);
                    edges.add(Nodes.e((String)"hasAlternative", (Node)alternative));
                }
                if ("contentmanagement:has-part".equals(reference.getRole()) && reference.getSecondaryRole() == null) {
                    InnerNode part = new InnerNode(target.getObjectID());
                    DocumentConversionUtil.fillInnerNode(target, part);
                    part.add(new Edge[]{Nodes.e((String)"order", (Node)Nodes.l((String)"order", (Object)String.valueOf(reference.getPosition())))});
                    edges.add(Nodes.e((String)"isPartOf", (Node)part));
                }
                if ("contentmanagement:is-described-by".equals(reference.getRole()) && SECONDARY_ROLE_METADATA.equals(reference.getSecondaryRole())) {
                    InnerNode metadata = new InnerNode(target.getObjectID());
                    DocumentConversionUtil.fillInnerNode(target, metadata);
                    edges.add(Nodes.e((String)"isDescribedBy", (Node)metadata));
                }
                if (!"contentmanagement:is-described-by".equals(reference.getRole()) || !"contentmanagement:is-annotated-by".equals(reference.getSecondaryRole())) continue;
                InnerNode annotation = new InnerNode(target.getObjectID());
                DocumentConversionUtil.fillInnerNode(target, annotation);
                edges.add(Nodes.e((String)"isAnnotatedBy", (Node)annotation));
            }
        }
        node.add(edges);
    }

    protected static Edge convertProperty(String label, PropertyDescription property) {
        String type = property.getType();
        String value = property.getValue();
        if ("contentmanagement:TimeInMilliseconds".equals(type)) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(Long.parseLong(value));
            return Nodes.e((String)label, (Node)Nodes.l((String)label, (Object)c));
        }
        return Nodes.e((String)label, (Node)Nodes.l((String)label, (Object)value));
    }

    protected static Edge convertToPropertyNode(PropertyDescription property) {
        String name = property.getName();
        String type = property.getType();
        String value = property.getValue();
        return Nodes.e((String)"property", (Node)Nodes.n((String)name, (Edge[])new Edge[]{Nodes.e((String)"id", (Node)Nodes.l((String)"id", (Object)name)), Nodes.e((String)"type", (Node)Nodes.l((String)"type", (Object)type)), Nodes.e((String)"value", (Node)Nodes.l((String)"value", (Object)value))}));
    }
}

