/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.util;

import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.EdgePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.LeafPredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Bindings;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Leaf;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAlternative;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAnnotation;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubePart;

public class ModelPrintUtil {
    protected static final SimpleDateFormat sdf = new SimpleDateFormat();
    protected static final Printer sysout = ModelPrintUtil.sysPrinter(System.out);

    protected static Printer logPrinter(final GCUBELog logger) {
        return new Printer(){

            @Override
            public void println(String ... message) {
                if (message != null) {
                    if (message.length == 0) {
                        logger.trace((Object)"");
                    } else {
                        for (String msg : message) {
                            logger.trace((Object)msg);
                        }
                    }
                }
            }
        };
    }

    protected static Printer sysPrinter(final PrintStream out) {
        return new Printer(){

            @Override
            public void println(String ... message) {
                if (message != null) {
                    if (message.length == 0) {
                        out.println();
                    } else {
                        for (String msg : message) {
                            out.println(msg);
                        }
                    }
                }
            }
        };
    }

    public static void print(GCubeDocument document, GCUBELog logger) {
        ModelPrintUtil.print(document, ModelPrintUtil.logPrinter(logger));
    }

    public static void print(GCubeDocument document) {
        ModelPrintUtil.print(document, sysout);
    }

    public static void print(GCubeDocument document, Printer out) {
        out.println(new String[0]);
        out.println("GCubeDocument:");
        out.println("\tname: " + document.name());
        ModelPrintUtil.printElement("\t", (GCubeElement)document, out);
        out.println("\tparts[" + document.parts().size() + "]:");
        for (GCubePart part : document.parts()) {
            ModelPrintUtil.printPart("\t\t", part, out);
        }
        out.println("\talternatives[" + document.alternatives().size() + "]:");
        for (GCubeAlternative alternative : document.alternatives()) {
            ModelPrintUtil.printAlternative("\t\t", alternative, out);
        }
        out.println("\tmetadata[" + document.metadata().size() + "]:");
        for (GCubeMetadata metadata : document.metadata()) {
            ModelPrintUtil.printMetadata("\t\t", metadata, out);
        }
        out.println("\tannotations[" + document.annotations().size() + "]:");
        for (GCubeAnnotation annotation : document.annotations()) {
            ModelPrintUtil.printAnnotation("\t\t", annotation, out);
        }
    }

    public static void printMetadata(List<GCubeMetadata> metadata) {
        ModelPrintUtil.printMetadata(metadata, sysout);
    }

    public static void printMetadata(List<GCubeMetadata> metadata, Printer out) {
        out.println("metadata[" + metadata.size() + "]:");
        for (GCubeMetadata m : metadata) {
            ModelPrintUtil.printMetadata("\t", m, out);
        }
    }

    public static void printParts(List<GCubePart> parts) {
        ModelPrintUtil.printParts(parts, sysout);
    }

    public static void printParts(List<GCubePart> parts, Printer out) {
        out.println("parts[" + parts.size() + "]:");
        for (GCubePart part : parts) {
            ModelPrintUtil.printPart("\t", part, out);
        }
    }

    public static void printAlternatives(List<GCubeAlternative> alternatives) {
        ModelPrintUtil.printAlternatives(alternatives, sysout);
    }

    public static void printAlternatives(List<GCubeAlternative> alternatives, Printer out) {
        out.println("alternatives[" + alternatives.size() + "]:");
        for (GCubeAlternative alternative : alternatives) {
            ModelPrintUtil.printAlternative("\t", alternative, out);
        }
    }

    public static void printAnnotations(List<GCubeAnnotation> annotations) {
        ModelPrintUtil.printAnnotations(annotations, sysout);
    }

    public static void printAnnotations(List<GCubeAnnotation> annotations, Printer out) {
        out.println("annotations[" + annotations.size() + "]:");
        for (GCubeAnnotation annotation : annotations) {
            ModelPrintUtil.printAnnotation("\t", annotation, out);
        }
    }

    public static void printPart(String indentation, GCubePart part, Printer out) {
        out.println(indentation + "GCubePart:");
        out.println(indentation + "\tname: " + part.name());
        ModelPrintUtil.printElement(indentation + "\t", (GCubeElement)part, out);
        out.println(indentation + "\torder: " + part.order());
    }

    public static void printAlternative(String indentation, GCubeAlternative alternative, Printer out) {
        out.println(indentation + "GCubeAlternative:");
        out.println(indentation + "\tname: " + alternative.name());
        ModelPrintUtil.printElement(indentation + "\t", (GCubeElement)alternative, out);
    }

    public static void printMetadata(String indentation, GCubeMetadata metadata, Printer out) {
        out.println(indentation + "GCubeMetadata:");
        ModelPrintUtil.printElement(indentation + "\t", (GCubeElement)metadata, out);
    }

    public static void printAnnotation(String indentation, GCubeAnnotation annotation, Printer out) {
        out.println(indentation + "GCubeAnnotation:");
        out.println(indentation + "\tpreviousID: " + annotation.previousID());
        ModelPrintUtil.printElement(indentation + "\t", (GCubeElement)annotation, out);
    }

    protected static void printElement(String indentation, GCubeElement element, Printer out) {
        out.println(indentation + "id: " + element.id());
        try {
            out.println(indentation + "uri: " + element.uri());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        out.println(indentation + "creationTime: " + (element.creationTime() != null ? sdf.format(element.creationTime().getTime()) : element.creationTime()));
        out.println(indentation + "lastUpdateTime: " + (element.lastUpdate() != null ? sdf.format(element.lastUpdate().getTime()) : element.lastUpdate()));
        out.println(indentation + "mimeType: " + element.mimeType());
        out.println(indentation + "length: " + element.length());
        out.println(indentation + "bytestreamURI: " + element.bytestreamURI());
        out.println(indentation + "bytestream (length): " + (element.bytestream() != null ? Integer.valueOf(element.bytestream().length) : "null"));
        out.println(indentation + "type: " + element.type());
        out.println(indentation + "name: " + element.schemaName());
        out.println(indentation + "schema: " + element.schemaURI());
        out.println(indentation + "language: " + element.language());
        out.println(indentation + "properties: " + element.properties().values());
    }

    public static String toString(GDoc document) throws Exception {
        StringWriter w = new StringWriter();
        Bindings.toXML((GDoc)document, (Writer)w, (boolean[])new boolean[0]);
        return w.toString();
    }

    public static void printAsTree(GDoc document, GCUBELog logger) {
        ModelPrintUtil.printAsTree(ModelPrintUtil.logPrinter(logger), (Node)document, "");
    }

    public static void printAsTree(GDoc document, PrintStream out) {
        ModelPrintUtil.printAsTree(ModelPrintUtil.sysPrinter(out), (Node)document, "");
    }

    public static void printAsTree(Printer printer, Node node, String indentation) {
        if (node == null) {
            printer.println("Node null");
        }
        printer.println(indentation + "Node [id: " + node.id() + " state: " + node.state() + "]");
        printer.println(indentation + ModelPrintUtil.toString(node.attributes()));
        if (node instanceof InnerNode) {
            InnerNode innerNode = (InnerNode)node;
            printer.println(indentation + " Edges [" + innerNode.edges().size() + "]:");
            for (Edge edge : innerNode.edges()) {
                printer.println(indentation + "  " + edge.label());
                ModelPrintUtil.printAsTree(printer, edge.target(), indentation + "\t");
            }
        }
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            String value = leaf.value();
            if (value != null) {
                value = value.substring(0, Math.min(value.length(), 30));
            }
            printer.println(indentation + " Value: " + value);
        }
        printer.println("");
    }

    public static String toString(Map<QName, String> attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append(" Attributes [");
        sb.append(attributes.size());
        sb.append("]:");
        for (Map.Entry<QName, String> attribute : attributes.entrySet()) {
            sb.append("(");
            sb.append(attribute.getKey());
            sb.append(",");
            sb.append(attribute.getValue());
            sb.append("), ");
        }
        return sb.toString();
    }

    public static void printAsTree(Predicate predicate, PrintStream out) {
        ModelPrintUtil.printAsTree(ModelPrintUtil.sysPrinter(out), "", predicate);
    }

    protected static void printAsTree(Printer printer, String indentation, Predicate predicate) {
        if (predicate instanceof TreePredicate) {
            printer.println(indentation + "TP");
            TreePredicate treePredicate = (TreePredicate)predicate;
            List edges = treePredicate.getPredicates();
            indentation = indentation + "  ";
            for (EdgePredicate edgePredicate : edges) {
                ModelPrintUtil.printAsTree(printer, indentation, edgePredicate);
            }
        }
        if (predicate instanceof LeafPredicate) {
            printer.println(indentation + "LP " + String.valueOf(predicate));
        }
    }

    protected static void printAsTree(Printer printer, String indentation, EdgePredicate edgePredicate) {
        Predicate targetPredicate = edgePredicate.predicate();
        if (targetPredicate instanceof TreePredicate || targetPredicate instanceof LeafPredicate) {
            printer.println(indentation + "EP " + (edgePredicate.isCondition() ? "[COND]" : "") + edgePredicate.getClass().getSimpleName().toLowerCase() + " [" + edgePredicate.label() + "]");
            ModelPrintUtil.printAsTree(printer, indentation + "  ", targetPredicate);
        } else {
            printer.println(indentation + "EP " + String.valueOf(edgePredicate));
        }
    }

    protected static interface Printer {
        public void println(String ... var1);
    }
}

