/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.data;

import com.mongodb.DBObject;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubbyHole {
    private Vector<DBObject> requestQueue = new Vector();
    static final Logger logger = LoggerFactory.getLogger(CubbyHole.class);
    private boolean available;

    public synchronized DBObject get() {
        while (this.requestQueue.size() == 0) {
            try {
                logger.debug("waiting in get");
                this.wait();
            }
            catch (InterruptedException e) {
                logger.error("getRequest()", e);
            }
        }
        DBObject value = this.requestQueue.remove(0);
        logger.debug("get element from queue: " + value);
        this.available = false;
        this.notifyAll();
        return value;
    }

    public synchronized void put(DBObject value) {
        while (this.available) {
            try {
                logger.debug("waiting in put");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.debug("put element to queue: " + value);
        this.requestQueue.addElement(value);
        this.available = true;
        this.notifyAll();
    }
}

