/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.aggregation;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractPortletUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.PortletUsageRecord;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.aggregation.AggregationUtility;

@JsonTypeName(value="PortletUsageRecord")
public class AggregatedPortletUsageRecord
extends AbstractPortletUsageRecord
implements AggregatedUsageRecord<AggregatedPortletUsageRecord, PortletUsageRecord> {
    private static final long serialVersionUID = 7445526162102677455L;

    public AggregatedPortletUsageRecord() {
    }

    public AggregatedPortletUsageRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public AggregatedPortletUsageRecord(PortletUsageRecord portletUsageRecord) throws InvalidValueException {
        super(portletUsageRecord.getResourceProperties());
        this.setOperationCount(1);
        Calendar creationTime = portletUsageRecord.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
    }

    @Override
    public int getOperationCount() {
        return super.getOperationCount();
    }

    @Override
    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    @Override
    public Calendar getStartTime() {
        return super.getStartTimeAsCalendar();
    }

    @Override
    public void setStartTime(Calendar startTime) throws InvalidValueException {
        super.setStartTime(startTime);
    }

    @Override
    public Calendar getEndTime() {
        return super.getEndTimeAsCalendar();
    }

    @Override
    public void setEndTime(Calendar endTime) throws InvalidValueException {
        super.setEndTime(endTime);
    }

    @Override
    public void setAggregated(Boolean aggregate) throws InvalidValueException {
        super.setAggregated(aggregate);
    }

    @Override
    public Boolean isAggregated() {
        return super.isAggregated();
    }

    @Override
    public AggregatedPortletUsageRecord aggregate(AggregatedPortletUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            AggregationUtility<AggregatedPortletUsageRecord> aggregationUtility = new AggregationUtility<AggregatedPortletUsageRecord>(this);
            aggregationUtility.aggregate(record);
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions(ex);
        }
        return this;
    }

    @Override
    public AggregatedPortletUsageRecord aggregate(PortletUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.aggregate(new AggregatedPortletUsageRecord(record));
        }
        catch (InvalidValueException e) {
            throw new NotAggregatableRecordsExceptions(e.getCause());
        }
    }

    @Override
    public boolean isAggregable(AggregatedPortletUsageRecord record) throws NotAggregatableRecordsExceptions {
        AggregationUtility<AggregatedPortletUsageRecord> aggregationUtility = new AggregationUtility<AggregatedPortletUsageRecord>(this);
        return aggregationUtility.isAggregable(record);
    }

    @Override
    public boolean isAggregable(PortletUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.isAggregable(new AggregatedPortletUsageRecord(record));
        }
        catch (InvalidValueException e) {
            throw new NotAggregatableRecordsExceptions(e.getCause());
        }
    }

    @Override
    public Class<PortletUsageRecord> getAggregable() {
        return PortletUsageRecord.class;
    }
}

