/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.protocol.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.scope.impl.ServiceMapScannerMediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final String GCUBE_RESOLVER_HOST = "data.gcube.org";
    private static final String D4SCIENCE_RESOLVER_HOST = "data.d4science.org";
    private static final String GCUBE_INFRA = "gcube";
    private static final String D4SCIENCE_INFRA = "d4science.research-infrastructures.eu";
    public static final String INFRASTRUCTURE_ENV_VARIABLE_NAME = "infrastructure";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static boolean validationScope2(String scope) {
        ScopeBean scopeBean = new ScopeBean(scope);
        if (scopeBean.is(ScopeBean.Type.VRE)) {
            scope = scopeBean.enclosingScope().toString();
        }
        return ServiceMapScannerMediator.isValid(scope);
    }

    public static ArrayList<String> getVOScopes(String scope) {
        ArrayList<String> vos = new ArrayList<String>();
        ScopeBean scopeBean = new ScopeBean(scope);
        while (!scopeBean.is(ScopeBean.Type.INFRASTRUCTURE)) {
            logger.debug("the scope " + scope + " is not an INFRA scope ");
            scopeBean = new ScopeBean(scopeBean.enclosingScope().toString());
        }
        scope = scopeBean.toString();
        if (scopeBean.is(ScopeBean.Type.INFRASTRUCTURE)) {
            Set<String> scopeSet = ServiceMapScannerMediator.getScopeKeySet();
            for (String scopeItem : scopeSet) {
                logger.debug("scope scanned: " + scopeItem);
                if (!scopeItem.contains(scope) || !new ScopeBean(scopeItem).is(ScopeBean.Type.VO)) continue;
                logger.debug("found vo scope: " + scopeItem);
                vos.add(scopeItem);
            }
        }
        return vos;
    }

    public static String extractInfrastructureNewVersion(String urlParam) {
        logger.debug("urlParam: " + urlParam);
        String infra = Utils.checkVarEnv(INFRASTRUCTURE_ENV_VARIABLE_NAME);
        if (infra != null) {
            return infra;
        }
        return Utils.getInfraFromResolverHost(urlParam);
    }

    public static String getInfraFromResolverHost(String resolverHost) {
        if (resolverHost.equals(GCUBE_RESOLVER_HOST)) {
            return GCUBE_INFRA;
        }
        if (resolverHost.equals(D4SCIENCE_RESOLVER_HOST)) {
            return D4SCIENCE_INFRA;
        }
        return resolverHost;
    }

    public static String checkVarEnv(String name) {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String infra = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase(name)) continue;
            infra = env.get(key);
            break;
        }
        return infra;
    }
}

