/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.filters.AFilter;
import org.gcube.contentmanagement.timeseries.geotools.finder.GeoAreaFinder;
import org.gcube.contentmanagement.timeseries.geotools.finder.ProbabilityFilter;
import org.gcube.contentmanagement.timeseries.geotools.finder.SpeciesConverter;
import org.gcube.contentmanagement.timeseries.geotools.finder.TimeSeriesAggregator;
import org.gcube.contentmanagement.timeseries.geotools.representations.GISLayer;
import org.gcube.contentmanagement.timeseries.geotools.utils.Couple;

public class SpeciesFilter
extends AFilter {
    ProbabilityFilter probabilityFilter;
    SpeciesConverter speciesConverter;
    ConnectionsManager connectionsManager;
    String currentElement;
    Map<String, String> species2FishCode;
    int noCodeCounter;
    int noCsquaresCounter;
    int CsquaresFiltersCounter;
    int overallSpeciesCounter;
    int overallCalculationsCounter;

    public SpeciesFilter(String timeSeriesName, String mainColumn, String optionalColumn, String quantitiesColumn) {
        super(false, timeSeriesName, mainColumn, optionalColumn, quantitiesColumn);
        this.filtername = "species_and_space";
    }

    @Override
    public List<GISLayer> filter(GISLayer previousGisLayer, ConnectionsManager connectionsManager, GeoAreaFinder geofind) throws Exception {
        if (this.aggregationColumn == null || this.informationColumn == null || this.quantitiesColumn == null || this.timeSeriesName == null) {
            throw new Exception("Inconsistent Input");
        }
        this.connectionsManager = connectionsManager;
        this.initFilter();
        ArrayList<GISLayer> layersList = new ArrayList<GISLayer>();
        this.geofinder = geofind == null ? new GeoAreaFinder(connectionsManager, this.ref_country) : geofind;
        TimeSeriesAggregator aggregator = new TimeSeriesAggregator(connectionsManager);
        Map<String, List<Couple>> aggregation = aggregator.aggregateTimeSeries(this.aggregationColumn, this.informationColumn, this.quantitiesColumn, this.timeSeriesName);
        HashMap<String, List<String>> placeToCsquares = new HashMap<String, List<String>>();
        long totalNumber = aggregation.size();
        int counter = 0;
        AnalysisLogger.getLogger().trace((Object)("SpeciesFilter:->TOTAL NUMBER OF SPECIES :" + totalNumber));
        for (String species : aggregation.keySet()) {
            double max = -1.7976931348623157E308;
            double min = Double.MAX_VALUE;
            this.currentElement = species;
            AnalysisLogger.getLogger().trace((Object)("SpeciesFilter:->ELEMENT UNDER ANALYSIS :" + species));
            String layername = "layr_" + (species.substring(0, Math.min(5, species.length())) + "_" + UUID.randomUUID()).replace("-", "_").replace(" ", "_").replace(",", "").replace(".", "").replace(":", "").replace(";", "").replace("<", "").replace(">", "").replace("=", "");
            GISLayer layer = new GISLayer(layername.toLowerCase());
            layer.setLayerTitle(this.filtername);
            List<Couple> placesQuantities = aggregation.get(species);
            for (Couple couple : placesQuantities) {
                List<String> csquares;
                String place = couple.getFirst();
                Double value = 0.0;
                try {
                    value = Double.parseDouble(couple.getSecond());
                }
                catch (Exception e1) {
                    // empty catch block
                }
                if (value > max) {
                    max = value;
                }
                if (value < min) {
                    min = value;
                }
                if ((csquares = (List<String>)placeToCsquares.get(place)) == null) {
                    List<String> prevsquares = null;
                    if (previousGisLayer != null) {
                        prevsquares = previousGisLayer.getCsquareCodes();
                    }
                    if ((csquares = this.findCSquareCodes(place, prevsquares)) != null) {
                        placeToCsquares.put(place, csquares);
                    }
                }
                if (csquares == null || csquares.size() <= 0) continue;
                csquares = this.postFilterSquare(csquares);
                layer.appendListofSquares(csquares, value, species);
            }
            if (max == min) {
                max += 1.0;
            }
            layer.setMax(max);
            layer.setMin(min);
            layer.setValuesColumnName(this.valuesColumnName);
            layersList.add(layer);
            this.status = (float)(++counter) / (float)totalNumber;
            ++this.overallSpeciesCounter;
        }
        this.status = 100.0f;
        AnalysisLogger.getLogger().trace((Object)("SpeciesFilter:->OVERALL PROCESSED SPECIES: " + this.overallSpeciesCounter));
        AnalysisLogger.getLogger().trace((Object)("SpeciesFilter:->NO TRANSFORMED SPECIES: " + this.noCodeCounter + " -- " + MathFunctions.roundDecimal((double)((double)this.noCodeCounter * 100.0 / (double)this.overallCalculationsCounter), (int)2) + "%"));
        AnalysisLogger.getLogger().trace((Object)("SpeciesFilter:->NO AREA FOUND IN COUNTRY FOR THAT SPECIES: " + this.noCsquaresCounter + " -- " + MathFunctions.roundDecimal((double)((double)this.noCsquaresCounter * 100.0 / (double)this.overallCalculationsCounter), (int)2) + "%"));
        return layersList;
    }

    @Override
    public void initFilter() {
        this.probabilityFilter = new ProbabilityFilter(this.connectionsManager);
        this.speciesConverter = new SpeciesConverter(this.connectionsManager, this.ref_species);
        this.species2FishCode = new HashMap<String, String>();
    }

    @Override
    public List<String> postFilterSquare(List<String> csquares) {
        ++this.overallCalculationsCounter;
        String fishcode = "";
        try {
            String cachedfishcode = this.species2FishCode.get(this.currentElement);
            if (cachedfishcode != null) {
                fishcode = cachedfishcode;
            } else {
                fishcode = this.speciesConverter.speciesName2FishCode(this.currentElement);
                AnalysisLogger.getLogger().trace((Object)("\tpostFilterSquare-> Fish " + this.currentElement + " converted to " + fishcode));
                this.species2FishCode.put(this.currentElement, fishcode);
            }
        }
        catch (Exception e) {
            this.species2FishCode.put(this.currentElement, fishcode);
            AnalysisLogger.getLogger().trace((Object)("\tpostFilterSquare-> ERROR - Impossible to convert fish name " + this.currentElement));
        }
        List<String> squares = null;
        if (fishcode.length() > 0) {
            squares = this.probabilityFilter.FilterOnProbability(csquares, fishcode);
        } else {
            ++this.noCodeCounter;
        }
        if (squares != null && squares.size() > 0) {
            AnalysisLogger.getLogger().trace((Object)("\tpostFilterSquare-> FILTER HAS BEEN CORRECTLY APPLIED TO " + fishcode));
            return squares;
        }
        ++this.noCsquaresCounter;
        AnalysisLogger.getLogger().trace((Object)"\tpostFilterSquare-> PROBABILITIES FILTER HAS NOT BEEN APPLIED!");
        return csquares;
    }
}

