/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.filters.AFilter;
import org.gcube.contentmanagement.timeseries.geotools.finder.GeoAreaFinder;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISGroupInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISLayerSaver;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISOperations;
import org.gcube.contentmanagement.timeseries.geotools.representations.GISLayer;
import org.gcube.contentmanagement.timeseries.geotools.tools.GeoGroupCache;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;

public class TimeSeriesGISConverter {
    public ConnectionsManager connectionManager;
    public TSGeoToolsConfiguration currentConfiguration;
    public static String persistenceFile = "timeSeries2GisCache.dat";
    public String persistencePath;
    static int maxTries = 5;
    boolean cached;
    EngineConfiguration tscfg = null;
    EngineConfiguration geocfg = null;
    EngineConfiguration aquacfg = null;
    private float status;
    private String groupName;

    public TimeSeriesGISConverter(TSGeoToolsConfiguration configuration) throws Exception {
        this.initDataSources(configuration);
    }

    private void initDataSources(TSGeoToolsConfiguration configuration) throws Exception {
        this.currentConfiguration = configuration;
        String configPath = configuration.getConfigPath();
        if (!configPath.endsWith("/")) {
            configPath = configPath + "/";
        }
        this.persistencePath = configuration.getPersistencePath() != null ? configuration.getPersistencePath() : configPath;
        if (!this.persistencePath.endsWith("/")) {
            this.persistencePath = this.persistencePath + "/";
        }
        this.persistencePath = this.persistencePath + persistenceFile;
        AnalysisLogger.setLogger((String)(configPath + "ALog.properties"));
        AnalysisLogger.getLogger().trace((Object)"TimeSeriesGISConverter-> initializing connections");
        this.connectionManager = new ConnectionsManager(configPath);
        this.tscfg = null;
        this.geocfg = null;
        this.aquacfg = null;
        if (configuration.getTimeSeriesDatabase() != null) {
            this.tscfg = new EngineConfiguration();
            this.tscfg.setConfigPath(configPath);
            this.tscfg.setDatabaseUserName(configuration.getTimeSeriesUserName());
            this.tscfg.setDatabasePassword(configuration.getTimeSeriesPassword());
            this.tscfg.setDatabaseURL(configuration.getTimeSeriesDatabase());
        }
        if (configuration.getAquamapsDatabase() != null) {
            this.aquacfg = new EngineConfiguration();
            this.aquacfg.setConfigPath(configPath);
            this.aquacfg.setDatabaseUserName(configuration.getAquamapsUserName());
            this.aquacfg.setDatabasePassword(configuration.getAquamapsPassword());
            this.aquacfg.setDatabaseURL(configuration.getAquamapsDatabase());
        }
        if (configuration.getGeoServerDatabase() != null) {
            this.geocfg = new EngineConfiguration();
            this.geocfg.setConfigPath(configPath);
            this.geocfg.setDatabaseUserName(configuration.getGeoServerUserName());
            this.geocfg.setDatabasePassword(configuration.getGeoServerPassword());
            this.geocfg.setDatabaseURL(configuration.getGeoServerDatabase());
        }
        this.cached = false;
    }

    public TimeSeriesGISConverter(String configPath) throws Exception {
        TSGeoToolsConfiguration cfg = new TSGeoToolsConfiguration();
        cfg.setConfigPath(configPath);
        this.initDataSources(cfg);
    }

    public void TimeSeriesToGIS(List<AFilter> filters, GISInformation gisInfo) throws Exception {
        this.TimeSeriesToGIS(filters, gisInfo, false);
    }

    public boolean createNewGroup(List<AFilter> filters, GISInformation gisInfo) {
        this.groupName = "group4" + UUID.randomUUID();
        this.cached = false;
        if (filters.size() == 1) {
            long t000 = System.currentTimeMillis();
            try {
                GeoGroupCache cache = GeoGroupCache.getInstance(this.persistencePath);
                long t001 = System.currentTimeMillis();
                AnalysisLogger.getLogger().trace((Object)("TimeSeriesToGIS->Cache Loaded in " + (t001 - t000) + "ms"));
                Tuple<String> groups = cache.getCachedElement(this.getTSIdentifier(filters), filters.get(0).getClass().getName());
                AnalysisLogger.getLogger().trace((Object)("TimeSeriesToGIS->Time Series: " + filters.get(0).getTimeSeriesName()));
                AnalysisLogger.getLogger().trace((Object)("TimeSeriesToGIS->Cache: " + filters.get(0).getClass().getName()));
                if (groups != null) {
                    if (GISGroupInformation.checkGroup(gisInfo, groups.getElements().get(0), 1)) {
                        this.cached = true;
                        this.groupName = groups.getElements().get(0);
                        AnalysisLogger.getLogger().warn((Object)"TimeSeriesToGIS->the Time Series and Filter were present in cache!");
                        AnalysisLogger.getLogger().warn((Object)("TimeSeriesToGIS->Found groupName: " + this.groupName));
                    } else {
                        AnalysisLogger.getLogger().trace((Object)"...Removing from Cache");
                        cache.removeCachedElement(filters.get(0).getTimeSeriesName(), filters.get(0).getClass().getName());
                    }
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().warn((Object)("TimeSeriesToGIS->ERROR in checking group " + e.getMessage()));
            }
        }
        return this.cached;
    }

    private void initializeConnections() throws Exception {
        this.connectionManager.initAquamapsConnection(this.aquacfg);
        AnalysisLogger.getLogger().trace((Object)"TimeSeriesGISConverter-> connected to Aquamaps");
        this.connectionManager.initTimeSeriesConnection(this.tscfg);
        AnalysisLogger.getLogger().trace((Object)"TimeSeriesGISConverter-> connected to Time Series");
        this.connectionManager.initGeoserverConnection(this.geocfg);
        AnalysisLogger.getLogger().trace((Object)"TimeSeriesGISConverter-> connected to Geo Server");
    }

    public String TimeSeriesToGIS(List<AFilter> filters, GISInformation gisInfo, boolean expandedMode) throws Exception {
        block19: {
            this.status = 0.0f;
            GISInformation localGISInfo = new GISInformation();
            localGISInfo.setGeoNetworkUrl(gisInfo.getGeoNetworkUrl());
            localGISInfo.setGeoNetworkUserName(gisInfo.getGeoNetworkUserName());
            localGISInfo.setGeoNetworkPwd(gisInfo.getGeoNetworkPwd());
            localGISInfo.setGisDataStore(gisInfo.getGisDataStore());
            localGISInfo.setGisPwd(gisInfo.getGisPwd());
            localGISInfo.setGisUrl(gisInfo.getGisUrl());
            localGISInfo.setGisUserName(gisInfo.getGisUserName());
            localGISInfo.setGisWorkspace(gisInfo.getGisWorkspace());
            GISLayerSaver gislayersav = null;
            long t0 = System.currentTimeMillis();
            if (this.groupName == null) {
                this.cached = this.createNewGroup(filters, localGISInfo);
            }
            try {
                String generatedName;
                if (this.cached) break block19;
                this.initializeConnections();
                AnalysisLogger.getLogger().warn((Object)"TimeSeriesToGIS->the Time Series and Filter were NOT present in cache!");
                ArrayList<GISLayer> currentGisLayers = new ArrayList<GISLayer>();
                GeoAreaFinder geofinder = new GeoAreaFinder(this.connectionManager, this.currentConfiguration.getReferenceCountriesTable());
                gislayersav = new GISLayerSaver(this.connectionManager);
                String tsname = "";
                if (filters.size() > 0) {
                    tsname = "compl_" + UUID.randomUUID();
                }
                GISLayer overallGISLayer = new GISLayer(tsname.replace("-", "_"));
                overallGISLayer.setValuesColumnName("maxspeciescountinacell");
                int filtercounter = 0;
                int totalFilters = filters.size();
                for (AFilter sfilter : filters) {
                    try {
                        sfilter.setRef_species(this.currentConfiguration.getReferenceSpeciesTable());
                        sfilter.setRef_country(this.currentConfiguration.getReferenceCountriesTable());
                        List<GISLayer> layers = sfilter.filter(null, this.connectionManager, geofinder);
                        AnalysisLogger.getLogger().warn((Object)("TimeSeriesToGIS->EXTRACTED " + layers.size() + " LAYERS"));
                        if (expandedMode) {
                            for (GISLayer layer : layers) {
                                if (!layer.isEmpty()) {
                                    AnalysisLogger.getLogger().trace((Object)("TimeSeriesToGIS->CREATING GIS LAYER: " + layer.getLayerName()));
                                    gislayersav.createLayerOnDB(layer, GISOperations.featuresTypes.real);
                                    currentGisLayers.add(layer);
                                    continue;
                                }
                                AnalysisLogger.getLogger().warn((Object)("TimeSeriesToGIS-> LAYER: " + layer.getLayerName() + " IS EMPTY"));
                            }
                        } else {
                            AnalysisLogger.getLogger().warn((Object)"TimeSeriesToGIS->Merging Layers...wait");
                            long tt1 = System.currentTimeMillis();
                            overallGISLayer.mergeGISLayers(layers);
                            long tt2 = System.currentTimeMillis();
                            AnalysisLogger.getLogger().warn((Object)("TimeSeriesToGIS->Merged in " + (tt2 - tt1) + " ms"));
                        }
                    }
                    catch (Exception e) {
                        AnalysisLogger.getLogger().warn((Object)("TimeSeriesToGIS->AN ERROR OCCURRED DURING THE APPLICATION OF FILTER NUMBER " + filtercounter));
                        e.printStackTrace();
                        currentGisLayers = null;
                        break;
                    }
                    float localstatus = (100.0f + (float)filtercounter * 100.0f) / (float)totalFilters;
                    this.status = localstatus == 100.0f ? 99.0f : localstatus;
                    ++filtercounter;
                    AnalysisLogger.getLogger().trace((Object)("TimeSeriesToGIS->status: " + this.status));
                }
                long t1 = System.currentTimeMillis();
                AnalysisLogger.getLogger().warn((Object)("Overall Filter Computation Finished - Elapsed Time: " + (t1 - t0) + " ms"));
                if (!expandedMode && !overallGISLayer.isEmpty()) {
                    gislayersav.createLayerOnDB(overallGISLayer, GISOperations.featuresTypes.real);
                    currentGisLayers.add(overallGISLayer);
                }
                if ((generatedName = gislayersav.createGISgroup(currentGisLayers, localGISInfo, this.groupName, true, true)) == null) {
                    throw new Exception("Error in GIS Layers Generation");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().warn((Object)("WARNING: AN ERROR OCCURRED DURING OVERALL CALCULATION " + e.getMessage()));
                throw e;
            }
            finally {
                localGISInfo.clean();
                this.connectionManager.shutdownAll();
                boolean urlcoherence = GISGroupInformation.checkGroup(gisInfo, this.groupName, maxTries);
                if (!urlcoherence) {
                    if (this.cached && filters.size() == 1) {
                        AnalysisLogger.getLogger().trace((Object)"...Removing from Cache");
                        GeoGroupCache cache = GeoGroupCache.getInstance(this.persistencePath);
                        cache.removeCachedElement(this.getTSIdentifier(filters), filters.get(0).getClass().getName());
                    }
                    throw new Exception("Error in GIS Group Generation - GIS Group was not created");
                }
                if (!this.cached && filters.size() == 1) {
                    AnalysisLogger.getLogger().trace((Object)"...Caching");
                    GeoGroupCache cache = GeoGroupCache.getInstance(this.persistencePath);
                    cache.addCacheElement(this.getTSIdentifier(filters), this.groupName, filters.get(0).getClass().getName());
                }
                this.status = 100.0f;
                long t2 = System.currentTimeMillis();
                AnalysisLogger.getLogger().warn((Object)("Computation Finished - Elapsed Time: " + (t2 - t0) + " ms"));
                AnalysisLogger.getLogger().trace((Object)("TimeSeriesToGIS->status: " + this.status));
                AnalysisLogger.getLogger().trace((Object)("TimeSeriesToGIS->group: " + this.groupName));
            }
        }
        return this.groupName;
    }

    public void setStatus(float status) {
        this.status = status;
    }

    public float getStatus() {
        return this.status;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    private String getTSIdentifier(List<AFilter> filters) {
        AFilter filter = filters.get(0);
        String id = filter.getTimeSeriesName() + ":" + filter.getAggregationColumn() + ":" + filter.getInformationColumn() + ":" + filter.getQuantitiesColumn() + ":" + filter.getRef_country() + ":" + filter.getRef_species();
        return id;
    }
}

