/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.vti;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.application.aquamaps.ecomodelling.generators.configuration.EngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISGroupInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISLayerInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISLayerSaver;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISOperations;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISStyleInformation;
import org.gcube.contentmanagement.timeseries.geotools.representations.GISLayer;
import org.gcube.contentmanagement.timeseries.geotools.tools.VTICache;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;
import org.gcube.contentmanagement.timeseries.geotools.vti.connectors.MonthlyFishingEffortCalculator;

public class VTIEffortAggregator {
    ConnectionsManager connectionsManager;
    private String groupName;
    private static int maxTries = 3;
    private float status = 0.0f;
    private boolean cached;
    public static String persistenceFile = "vtiCache.dat";
    private String persistencePath;
    private static String getMinMaxQuery = "select min(%1$s), max(%1$s) from %2$s";
    private static String getAllInfo = "select %1$s from %2$s;";
    private static String tempTableDrop = "drop table %1$s";
    private static String buildTempTable = "create table  %1$s (%2$s) WITH ( OIDS=FALSE ); ";
    private static String tempValuesInsert = "INSERT INTO %1$s (%2$s) VALUES %3$s";
    private static String rawInsert = "INSERT INTO %1$s (%2$s) VALUES %3$s";
    private static String rawSelect = "select %1$s from %2$s order by %3$s limit %4$s offset %5$s";
    private static String referenceValue = "monthlyfishinghours";
    private static String addGeometriesColumn = "alter table %1$s add the_geom geometry;";
    private static String getTableStructure = "SELECT column_name,data_type FROM information_schema.COLUMNS WHERE table_name ='%1$s'";
    private static String createPointsGeometriesColumn = "Select AddGeometryColumn('%1$s','the_geom',4326,'POINT',2)";
    public static String MONTHPREFIX = "m_";
    public static String VTIPREFIX = "v_";
    public static String MONTHLAYERTITLE = "Fishing_Monthly_Effort";
    public static String VTILAYERTITLE = "Vessel Routes";

    public VTIEffortAggregator(TSGeoToolsConfiguration configuration) throws Exception {
        try {
            String configPath = configuration.getConfigPath();
            if (!configPath.endsWith("/")) {
                configPath = configPath + "/";
            }
            this.persistencePath = configuration.getPersistencePath() != null ? configuration.getPersistencePath() : configPath;
            if (!this.persistencePath.endsWith("/")) {
                this.persistencePath = this.persistencePath + "/";
            }
            this.persistencePath = this.persistencePath + persistenceFile;
            AnalysisLogger.setLogger((String)(configPath + "ALog.properties"));
            AnalysisLogger.getLogger().trace((Object)"EffortAggregator-> initializing connections");
            this.connectionsManager = new ConnectionsManager(configPath);
            EngineConfiguration tscfg = null;
            EngineConfiguration geocfg = null;
            if (configuration.getTimeSeriesDatabase() != null) {
                tscfg = new EngineConfiguration();
                tscfg.setConfigPath(configPath);
                tscfg.setDatabaseUserName(configuration.getTimeSeriesUserName());
                tscfg.setDatabasePassword(configuration.getTimeSeriesPassword());
                tscfg.setDatabaseURL(configuration.getTimeSeriesDatabase());
            }
            if (configuration.getGeoServerDatabase() != null) {
                geocfg = new EngineConfiguration();
                geocfg.setConfigPath(configPath);
                geocfg.setDatabaseUserName(configuration.getGeoServerUserName());
                geocfg.setDatabasePassword(configuration.getGeoServerPassword());
                geocfg.setDatabaseURL(configuration.getGeoServerDatabase());
            }
            this.connectionsManager.initTimeSeriesConnection(tscfg);
            AnalysisLogger.getLogger().trace((Object)"EffortAggregator-> connected to Time Series");
            this.connectionsManager.initGeoserverConnection(geocfg);
            AnalysisLogger.getLogger().trace((Object)"EffortAggregator-> connected to Geo Server");
        }
        catch (Exception e) {
            this.connectionsManager.shutdownAll();
            throw e;
        }
    }

    public String produceMontlyEffort(String tableName, String outputTableName, String tableKey, String xDimension, String yDimension, String datesDimension, String fishingHoursDimension, String speedDimension) throws Exception {
        return this.produceMontlyEffort(tableName, tableKey, xDimension, yDimension, datesDimension, fishingHoursDimension, speedDimension, null, false, false, null);
    }

    public String produceMontlyEffort(String tableName, String tableKey, String xDimension, String yDimension, String datesDimension, String fishingHoursDimension, String speedDimension, GISInformation gisInfo, boolean produceVTI, boolean appendMode) throws Exception {
        return this.produceMontlyEffort(tableName, tableKey, xDimension, yDimension, datesDimension, fishingHoursDimension, speedDimension, gisInfo, produceVTI, appendMode, null);
    }

    public float getStatus() {
        return this.status;
    }

    public String getGroupName() {
        return this.groupName;
    }

    private String getTSIdentifier(String timeseriesName, String xDimension, String yDimension, String datesDimension, String fishingHoursDimension, String speedDimension) {
        return timeseriesName + ":" + xDimension + ":" + yDimension + ":" + datesDimension + ":" + fishingHoursDimension + ":" + speedDimension;
    }

    public void createNewGroup(GISInformation gisInfo, String timeseriesName, String xDimension, String yDimension, String datesDimension, String fishingHoursDimension, String speedDimension) {
        this.groupName = "vtigrp_" + UUID.randomUUID();
        this.cached = false;
        timeseriesName = ConnectionsManager.getTableName(timeseriesName);
        long t000 = System.currentTimeMillis();
        try {
            VTICache cache = VTICache.getInstance(this.persistencePath);
            long t001 = System.currentTimeMillis();
            AnalysisLogger.getLogger().trace((Object)("vtiGIS->Cache Loaded in " + (t001 - t000) + "ms"));
            Tuple<String> groups = cache.getCachedElement(this.getTSIdentifier(timeseriesName, xDimension, yDimension, datesDimension, fishingHoursDimension, speedDimension));
            AnalysisLogger.getLogger().trace((Object)("vtiGIS->Time Series: " + timeseriesName));
            if (groups != null) {
                if (GISGroupInformation.checkGroup(gisInfo, groups.getElements().get(0), 1)) {
                    this.cached = true;
                    this.groupName = groups.getElements().get(0);
                    AnalysisLogger.getLogger().warn((Object)"vtiGIS->the Time Series was present in cache!");
                    AnalysisLogger.getLogger().warn((Object)("vtiGIS->Found groupName: " + this.groupName));
                } else {
                    AnalysisLogger.getLogger().trace((Object)"vtiGIS->Group doesn't really exist...Removing from Cache");
                    cache.removeCachedElement(this.getTSIdentifier(timeseriesName, xDimension, yDimension, datesDimension, fishingHoursDimension, speedDimension));
                }
            } else {
                AnalysisLogger.getLogger().trace((Object)("vtiGIS->Time Series: " + timeseriesName + " was not present in cache"));
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().warn((Object)("vtiGIS->ERROR in checking group " + e.getMessage()));
        }
    }

    public String produceMontlyEffort(String tableName, String tableKey, String xDimension, String yDimension, String datesDimension, String fishingHoursDimension, String speedDimension, GISInformation gisInfo, boolean produceVTI, boolean appendMode, HashMap<String, String> field2user) throws Exception {
        long t0 = System.currentTimeMillis();
        GISInformation localGISInfo = new GISInformation();
        localGISInfo.setGeoNetworkUrl(gisInfo.getGeoNetworkUrl());
        localGISInfo.setGeoNetworkUserName(gisInfo.getGeoNetworkUserName());
        localGISInfo.setGeoNetworkPwd(gisInfo.getGeoNetworkPwd());
        localGISInfo.setGisDataStore(gisInfo.getGisDataStore());
        localGISInfo.setGisPwd(gisInfo.getGisPwd());
        localGISInfo.setGisUrl(gisInfo.getGisUrl());
        localGISInfo.setGisUserName(gisInfo.getGisUserName());
        localGISInfo.setGisWorkspace(gisInfo.getGisWorkspace());
        AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->GIS INFORMATION " + gisInfo.getGisUserName() + "," + gisInfo.getGisWorkspace() + "," + gisInfo.getGisDataStore() + "," + gisInfo.getGisUrl() + "," + gisInfo.getGisPwd()));
        tableName = ConnectionsManager.getTableName(tableName);
        GISLayerSaver gislayersav = null;
        if (this.groupName == null) {
            this.createNewGroup(gisInfo, tableName, xDimension, yDimension, datesDimension, fishingHoursDimension, speedDimension);
        }
        try {
            this.status = 0.0f;
            if (!this.cached) {
                AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Calculation Started on " + tableName));
                AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Parameters: " + tableName + "," + tableKey + "," + xDimension + "," + yDimension + "," + datesDimension + "," + fishingHoursDimension + "," + speedDimension + "," + produceVTI + "," + appendMode));
                String outputTableName = MONTHPREFIX + tableName;
                AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Getting max and min dates " + String.format(getMinMaxQuery, datesDimension, tableName)));
                Object[] minmax = (Object[])this.connectionsManager.TimeSeriesQuery(String.format(getMinMaxQuery, datesDimension, tableName)).get(0);
                Date minDate = (Date)minmax[0];
                Date maxDate = (Date)minmax[1];
                AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Min date: " + minDate + " Max date: " + maxDate));
                AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Getting all table info " + String.format(getAllInfo, yDimension + "," + xDimension + "," + datesDimension + "," + fishingHoursDimension + "," + speedDimension, tableName)));
                List<Object> allInfo = this.connectionsManager.TimeSeriesQuery(String.format(getAllInfo, yDimension + "," + xDimension + "," + datesDimension + "," + fishingHoursDimension + "," + speedDimension, tableName));
                this.status = 25.0f;
                AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Calculation monthly effort - status " + this.status));
                MonthlyFishingEffortCalculator mfcalc = new MonthlyFishingEffortCalculator();
                Map<String, Double> mfe = mfcalc.calculateMonthlyFishingEffor(allInfo, minDate, maxDate);
                AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Dropping output table - status " + this.status));
                try {
                    this.connectionsManager.GeoserverUpdate(String.format(tempTableDrop, outputTableName));
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Impossible to drop table " + tableName));
                }
                AnalysisLogger.getLogger().trace((Object)"produceMontlyEffort->Creating new table");
                this.connectionsManager.GeoserverUpdate(String.format(buildTempTable, outputTableName, "csquarecode character varying, " + referenceValue + " real"));
                AnalysisLogger.getLogger().trace((Object)"produceMontlyEffort->Saving elements");
                int mflen = mfe.size();
                StringBuffer insertionQuery = new StringBuffer();
                int i = 0;
                for (String key : mfe.keySet()) {
                    insertionQuery.append("('" + key + "','" + mfe.get(key) + "')");
                    if (i < mflen - 1) {
                        insertionQuery.append(",");
                    }
                    ++i;
                }
                this.connectionsManager.GeoserverUpdate(String.format(tempValuesInsert, outputTableName, "csquarecode, " + referenceValue, insertionQuery.toString()));
                this.status = 50.0f;
                AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->status " + this.status));
                if (gisInfo != null) {
                    AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Adding geometries to table " + outputTableName));
                    this.connectionsManager.GeoserverUpdate(String.format(addGeometriesColumn, outputTableName));
                    this.connectionsManager.GeoserverUpdate(GISOperations.createFulfilGeometriesStatement(outputTableName));
                    AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->Creating new GIS Group with name " + this.groupName));
                    gislayersav = new GISLayerSaver(this.connectionsManager);
                    GISLayer fishingEffortGISLayer = new GISLayer(outputTableName);
                    fishingEffortGISLayer.setLayerTitle(MONTHLAYERTITLE);
                    fishingEffortGISLayer.setValuesColumnName(referenceValue);
                    if (mfcalc.getMinEffort() == mfcalc.getMaxEffort()) {
                        mfcalc.setMaxEffort(mfcalc.getMaxEffort() + 1.0);
                    }
                    fishingEffortGISLayer.setMin(mfcalc.getMinEffort());
                    fishingEffortGISLayer.setMax(mfcalc.getMaxEffort());
                    fishingEffortGISLayer.forceNotEmpty();
                    fishingEffortGISLayer.setPreferredStyleName("montly_fishing_hours_" + UUID.randomUUID());
                    ArrayList<GISLayer> singletonlayers = new ArrayList<GISLayer>();
                    singletonlayers.add(fishingEffortGISLayer);
                    if (produceVTI) {
                        this.addVTILayers(tableName, tableKey, xDimension, yDimension, this.groupName, localGISInfo, appendMode, field2user);
                    }
                    this.status = 75.0f;
                    AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->status " + this.status));
                    this.groupName = gislayersav.createGISgroup(singletonlayers, localGISInfo, this.groupName, true, true);
                    if (this.groupName == null) {
                        throw new Exception("Impossible to create group on Geoserver");
                    }
                    AnalysisLogger.getLogger().trace((Object)"produceMontlyEffort->GIS Group created!");
                }
            }
            AnalysisLogger.getLogger().trace((Object)"produceMontlyEffort->Calculation Finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            localGISInfo.clean();
            this.connectionsManager.shutdownAll();
            boolean urlcoherence = GISGroupInformation.checkGroup(gisInfo, this.groupName, maxTries);
            if (!urlcoherence) {
                AnalysisLogger.getLogger().trace((Object)"...Removing from Cache");
                VTICache cache = VTICache.getInstance(this.persistencePath);
                cache.removeCachedElement(this.getTSIdentifier(tableName, xDimension, yDimension, datesDimension, fishingHoursDimension, speedDimension));
                throw new Exception("Error in GIS Group Generation - GIS Group was not really created");
            }
            if (!this.cached) {
                AnalysisLogger.getLogger().trace((Object)"...Caching");
                VTICache cache = VTICache.getInstance(this.persistencePath);
                cache.addCacheElement(this.getTSIdentifier(tableName, xDimension, yDimension, datesDimension, fishingHoursDimension, speedDimension), this.groupName);
            }
            this.status = 100.0f;
            long t2 = System.currentTimeMillis();
            AnalysisLogger.getLogger().warn((Object)("Computation Finished - Elapsed Time: " + (t2 - t0) + " ms"));
            AnalysisLogger.getLogger().trace((Object)("ProduceMonthlyEffort->status: " + this.status));
        }
        return this.groupName;
    }

    private String getFinalName(String name, HashMap<String, String> field2user) {
        String finalName = name;
        if (field2user != null && (finalName = field2user.get(name)) == null) {
            AnalysisLogger.getLogger().trace((Object)("getFinalName->WARNING- unable to transform name " + name));
            finalName = name;
        }
        return finalName;
    }

    public void addVTILayers(String tableName, String tableKey, String xDimension, String yDimension, String previousGroupName, GISInformation gisInfo, boolean appendMode, HashMap<String, String> field2user) throws Exception {
        String outputTableName = VTIPREFIX + tableName;
        AnalysisLogger.getLogger().trace((Object)("addVTILayers->dropping table if exists " + outputTableName));
        try {
            this.connectionsManager.GeoserverUpdate(String.format(tempTableDrop, outputTableName));
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().trace((Object)("addVTILayers->Impossible to drop table " + outputTableName));
        }
        AnalysisLogger.getLogger().trace((Object)("addVTILayers->getting table structure for " + outputTableName));
        List<Object> tableStructure = this.connectionsManager.TimeSeriesQuery(String.format(getTableStructure, tableName));
        StringBuffer tabledimensions = new StringBuffer();
        int tsize = tableStructure.size();
        ArrayList<String> dimensions = new ArrayList<String>();
        ArrayList<String> userfriendlydimensions = new ArrayList<String>();
        for (int j = 0; j < tsize; ++j) {
            Object[] row = (Object[])tableStructure.get(j);
            String dimName = "" + row[0];
            String type = "" + row[1];
            tabledimensions.append(this.getFinalName(dimName, field2user) + " " + type);
            userfriendlydimensions.add(this.getFinalName(dimName, field2user));
            dimensions.add(dimName);
            if (j >= tsize - 1) continue;
            tabledimensions.append(",");
        }
        String dimensionsList = this.orderDimensions(dimensions, xDimension, yDimension);
        String userdimensionsList = this.orderDimensions(userfriendlydimensions, this.getFinalName(xDimension, field2user), this.getFinalName(yDimension, field2user));
        if (!appendMode) {
            AnalysisLogger.getLogger().trace((Object)("addVTILayers->creating table structure for " + outputTableName));
            AnalysisLogger.getLogger().trace((Object)("addVTILayers->building " + String.format(buildTempTable, outputTableName, tabledimensions.toString())));
            this.connectionsManager.GeoserverUpdate(String.format(buildTempTable, outputTableName, tabledimensions.toString()));
            AnalysisLogger.getLogger().trace((Object)"addVTILayers->adding geometries column");
            try {
                String addGeometriesTable = String.format(createPointsGeometriesColumn, outputTableName);
                this.connectionsManager.GeoserverQuery(addGeometriesTable);
            }
            catch (Exception e2) {
                AnalysisLogger.getLogger().trace((Object)"column was yet created");
                e2.printStackTrace();
            }
        }
        AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->getting table elements from " + outputTableName));
        int chunkSize = 100000;
        int startIndex = 0;
        List<Object> rows = this.connectionsManager.TimeSeriesQuery(String.format(rawSelect, dimensionsList, tableName, tableKey, "" + chunkSize, "" + startIndex));
        while (rows != null) {
            int rowsNumber = rows.size();
            int i = 0;
            StringBuffer allInfo = new StringBuffer();
            for (Object row : rows) {
                Object[] elements = (Object[])row;
                allInfo.append("(");
                String x = "";
                String y = "";
                for (int j = 0; j < elements.length; ++j) {
                    allInfo.append("'" + elements[j] + "',");
                    if (j == 0) {
                        x = "" + elements[j];
                        continue;
                    }
                    if (j != 1) continue;
                    y = "" + elements[j];
                }
                allInfo.append("ST_SetSRID(ST_MakePoint(" + x + "," + y + "),4326)");
                allInfo.append(")");
                if (i < rowsNumber - 1) {
                    allInfo.append(",");
                }
                ++i;
            }
            AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->putting table elements into " + outputTableName));
            AnalysisLogger.getLogger().trace((Object)("produceMontlyEffort->insertion details " + String.format(rawInsert, outputTableName, userdimensionsList + ",the_geom", "")));
            this.connectionsManager.GeoserverUpdate(String.format(rawInsert, outputTableName, userdimensionsList + ",the_geom", allInfo.toString()));
            rows = this.connectionsManager.TimeSeriesQuery(String.format(rawSelect, dimensionsList, tableName, tableKey, "" + chunkSize, "" + (startIndex += chunkSize)));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO point_geometries_example(gid, the_geom, type) VALUES");
        AnalysisLogger.getLogger().trace((Object)"produceMontlyEffort->adding VTI layers");
        GISStyleInformation style = new GISStyleInformation();
        style.setStyleName("VTISimpleClassification");
        GISStyleInformation style2 = new GISStyleInformation();
        style2.setStyleName("VTIBathymetryClassification");
        GISLayerInformation gisLayer1 = new GISLayerInformation();
        gisLayer1.setDefaultStyle(style.getStyleName());
        gisLayer1.setLayerName(outputTableName);
        gisLayer1.setLayerTitle(VTILAYERTITLE);
        gisInfo.addLayer(gisLayer1);
        gisInfo.addStyle(gisLayer1.getLayerName(), style2);
        gisInfo.addStyle(gisLayer1.getLayerName(), style);
        AnalysisLogger.getLogger().trace((Object)"produceMontlyEffort->adding VTI layers - done!");
    }

    private String orderDimensions(List<String> dimensions, String xDimension, String yDimension) {
        dimensions.remove(xDimension);
        dimensions.remove(yDimension);
        dimensions.add(0, xDimension);
        dimensions.add(1, yDimension);
        StringBuffer dimensionsBuffer = new StringBuffer();
        int k = 0;
        int dimSize = dimensions.size();
        for (String dim : dimensions) {
            dimensionsBuffer.append(dim);
            if (k < dimSize - 1) {
                dimensionsBuffer.append(",");
            }
            ++k;
        }
        return dimensionsBuffer.toString();
    }
}

