/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.patterns;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.trees.constraints.Constraint;
import org.gcube.data.trees.patterns.LeafPattern;

@XmlRootElement(name="calendar")
public final class CalendarPattern
extends LeafPattern<Calendar, Constraint<? super Calendar>> {
    private static final long serialVersionUID = 1L;
    static final String NAME = "calendar";
    public static DateFormat ISO8601formatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ");
    public static DateFormat ISO8601shortFormatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    public static DateFormat ISO8601minFormatter = new SimpleDateFormat("yyyy-MM-dd");

    CalendarPattern() {
    }

    public CalendarPattern(Constraint<? super Calendar> c) {
        super(c);
    }

    @Override
    protected Calendar valueOf(String s) throws Exception {
        Calendar d = Calendar.getInstance();
        try {
            d.setTime(ISO8601formatter.parse(s));
        }
        catch (ParseException e1) {
            try {
                d.setTime(ISO8601shortFormatter.parse(s));
            }
            catch (ParseException e2) {
                d.setTime(ISO8601minFormatter.parse(s));
            }
        }
        return d;
    }

    @Override
    public String name() {
        return NAME;
    }
}

