/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.data.analysis.nlphub.legacy.JsonManager;
import org.gcube.data.analysis.nlphub.nlp.RunnerCommander;
import org.gcube.data.analysis.nlphub.session.SessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@WebServlet(asyncSupported=true, name="NLPServlet", urlPatterns={"/nlphub-servlet"})
public class NLPHub
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NLPHub.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doWork(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doWork(request, response);
    }

    private void doWork(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("NLPHub");
        String token = SessionUtils.getToken((HttpServletRequest)request);
        if (request.getParameter("getInfo") != null) {
            this.getAlgorithmInfo(request, response, token);
        } else {
            this.runAlgorithms(request, response, token);
        }
        logger.debug("NLPHub work done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAlgorithmInfo(HttpServletRequest request, HttpServletResponse response, String token) throws ServletException, IOException {
        try {
            String dataMiner = request.getParameter("dataminer");
            String algId = request.getParameter("algId");
            logger.debug("NLPHub getAlgorithmInfo: [DataMiner=" + dataMiner + ", algorithmID=" + algId + "]");
            HttpURLConnection connection = null;
            BufferedReader r = null;
            String algAbsrtact = "";
            PrintWriter writer = response.getWriter();
            response.setContentType("application/json;charset=UTF-8");
            try {
                String finalUrl = "https://" + dataMiner + "?request=DescribeProcess&service=WPS&Version=1.0.0" + "&lang=en-US&Identifier=" + algId;
                logger.debug("Request url: " + finalUrl);
                finalUrl = finalUrl + "&gcube-token=" + token;
                URL url = new URL(finalUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setRequestMethod("GET");
                r = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(r));
                doc.getDocumentElement().normalize();
                NodeList nListInput = doc.getElementsByTagName("ows:Abstract");
                if (nListInput.getLength() <= 0) {
                    algAbsrtact = "No description.";
                    writer.println(new JsonManager().getErrorJsonResponse(algAbsrtact));
                } else {
                    Node nodeAbstract = nListInput.item(0);
                    algAbsrtact = nodeAbstract.getTextContent();
                    writer.println(new JsonManager().getSuccessJsonResponse("" + algAbsrtact));
                }
                writer.close();
            }
            catch (Exception e) {
                logger.error("NLPHub error in GET algorithmInfo: " + e.getLocalizedMessage(), (Throwable)e);
                writer.println(new JsonManager().getErrorJsonResponse("" + e.getLocalizedMessage()));
                writer.close();
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
                catch (Exception e) {
                    logger.error("NLPHub error in GET algorithmInfo: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("NLPHub error in GET algorithmInfo: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void runAlgorithms(HttpServletRequest request, HttpServletResponse response, String token) throws ServletException, IOException {
        try {
            String dataMiner = request.getParameter("dataminer");
            Object[] algs = request.getParameter("algs").split(",");
            String plink = request.getParameter("plink");
            String annotations = request.getParameter("annotations");
            logger.debug("NLPHub getAlgorithmInfo: [DataMiner=" + dataMiner + ", plink=" + plink + ", annotations=" + annotations + ", algorithms=" + Arrays.toString(algs) + "]");
            for (int i = 0; i < algs.length; ++i) {
                algs[i] = ((String)algs[i]).trim();
            }
            String maxWaitingTime = this.getServletConfig().getInitParameter("MaxWaitingTime");
            String sleepTime = this.getServletConfig().getInitParameter("SleepTime");
            logger.debug("NLPHub: [maxWaitingTime=" + maxWaitingTime + ", sleepTime=" + sleepTime + "]");
            long maxWaitingTimeL = Long.parseLong(maxWaitingTime);
            long sleepTimeL = Long.parseLong(sleepTime);
            RunnerCommander commander = new RunnerCommander(dataMiner, (String[])algs, plink, annotations, token, response);
            commander.setSleepTime(sleepTimeL);
            commander.setMaxWaitingTime(maxWaitingTimeL);
            commander.startProcess();
        }
        catch (Exception e) {
            logger.error("NLPHub runAlgorithms: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

