/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub.is;

import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.data.analysis.nlphub.is.InformationSystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMDiscover {
    private static Logger logger = LoggerFactory.getLogger(DMDiscover.class);

    public String retrieveServiceUrl(String token) throws Exception {
        logger.debug("Retrieve DataMiner Service by token: " + token);
        String scope = this.retrieveScope(token);
        logger.debug("Retrieve DataMiner Service in scope: " + scope);
        String url = this.retrieveServiceInScope(scope);
        logger.debug("DataMiner url: " + url);
        return url;
    }

    private String retrieveServiceInScope(String scope) throws Exception {
        List serviceAddress = InformationSystemUtils.retrieveServiceAddress((String)"DataAnalysis", (String)"DataMiner", (String)scope);
        logger.debug("Service Address retrieved:" + serviceAddress);
        if (serviceAddress == null || serviceAddress.size() < 1) {
            logger.error("No DataMiner service address available!");
            throw new Exception("No DataMiner service address available!");
        }
        logger.info("DataMiner service address found: " + (String)serviceAddress.get(0));
        return (String)serviceAddress.get(0);
    }

    private String retrieveScope(String token) throws Exception {
        String userName = null;
        String scope = null;
        logger.debug("Production Mode");
        if (token == null || token.isEmpty()) {
            logger.error("Error retrieving user credentials: token=" + token);
            throw new Exception("Error retrieving user credentials");
        }
        try {
            logger.debug("Retrieving user credentials");
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            userName = entry.getClientInfo().getId();
            scope = entry.getContext();
        }
        catch (Exception e) {
            logger.error("Error retrieving user credentials: " + e.getLocalizedMessage());
            throw new Exception(e.getLocalizedMessage(), e);
        }
        logger.debug("UserName: " + userName);
        logger.debug("Scope: " + scope);
        return scope;
    }
}

