/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub.nlp;

import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.gcube.data.analysis.nlphub.legacy.JsonManager;
import org.gcube.data.analysis.nlphub.nlp.NlpAsyncNerRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RunnerCommander
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(RunnerCommander.class);
    private HttpServletResponse response = null;
    private String annotationList = "";
    private String[] identifiers = null;
    private String link = "";
    private String token = "";
    private String dataMiner;
    private ArrayList<String> outResultList = null;
    private long sleepTime = 500L;
    private long maxWaitingTime = 300000L;
    private boolean complete = false;

    public RunnerCommander(String dataMiner, String[] identifiers, String link, String annotationList, String token, HttpServletResponse response) {
        this.identifiers = identifiers;
        this.annotationList = annotationList;
        this.link = link;
        this.token = token;
        this.response = response;
        this.sleepTime = 500L;
        this.dataMiner = dataMiner;
        this.outResultList = new ArrayList();
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public synchronized void updateResultList(String res) {
        this.outResultList.add(res);
    }

    public long getMaxWaitingtime() {
        return this.maxWaitingTime;
    }

    public void setMaxWaitingTime(long maxWaitingTime) {
        this.maxWaitingTime = maxWaitingTime;
    }

    public void startProcess() {
        this.start();
        long counter = 0L;
        while (!this.complete) {
            try {
                RunnerCommander.sleep((long)this.sleepTime);
                if ((counter += this.sleepTime) <= 2L * this.maxWaitingTime) continue;
                this.complete = true;
            }
            catch (InterruptedException e) {
                logger.info("Interrupted. " + this.identifiers);
            }
        }
    }

    private void runAlgorithms() throws Exception {
        for (String id : this.identifiers) {
            NlpAsyncNerRunner n = new NlpAsyncNerRunner(this.dataMiner, id, this.token, this.link, this.annotationList, null, this);
            logger.debug("Run algorithm: " + id);
            n.start();
        }
    }

    @Override
    public void run() {
        long counter;
        try {
            this.runAlgorithms();
        }
        catch (Exception e1) {
            logger.error("Error in run algorithms: " + e1.getLocalizedMessage(), (Throwable)e1);
            return;
        }
        try {
            for (counter = 0L; counter <= this.maxWaitingTime; counter += this.sleepTime) {
                if (this.outResultList.size() == this.identifiers.length) {
                    String[] links = new String[this.outResultList.size()];
                    links = this.outResultList.toArray(links);
                    this.writeResponse(links);
                    logger.info("Elapsed time: " + counter + " msec.");
                    return;
                }
                RunnerCommander.sleep((long)this.sleepTime);
            }
            logger.error("Timeout error.");
            this.timeoutHandler();
        }
        catch (InterruptedException e) {
            logger.info("Elapsed time: " + counter + " msec.");
            logger.info("Thread interrupted.");
            this.timeoutHandler();
        }
    }

    private void timeoutHandler() {
        boolean found = false;
        for (int i = 0; i < this.identifiers.length; ++i) {
            String id = this.identifiers[i];
            id = id.substring(id.lastIndexOf(".") + 1);
            for (String s : this.outResultList) {
                if (!s.startsWith(id)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.outResultList.add(id + ":::" + "ERROR");
            }
            found = false;
        }
        String[] links = new String[this.outResultList.size()];
        links = this.outResultList.toArray(links);
        this.writeResponse(links);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(String[] content) {
        logger.info("RunnerCommander has run " + content.length + " tasks.");
        if (this.response != null) {
            this.response.setContentType("application/json;charset=UTF-8");
            PrintWriter writer = null;
            try {
                writer = this.response.getWriter();
                String msg = new JsonManager().getSuccessJsonResponse(content);
                writer.println(msg);
                if (writer.checkError()) {
                    logger.error("writeResponse method has some problem in writing result.");
                }
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
            finally {
                this.complete = true;
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }
}

