/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.nlphub.legacy;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.gcube.data.analysis.nlphub.nlp.NlpParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpRequest
extends Thread {
    private String baseUrl;
    private String finalUrl;
    private String result;
    private String method;
    private ArrayList<NlpParameter> parameters;
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpRequest.class);
    protected long elapsedTime;

    public AsyncHttpRequest() {
        this.baseUrl = null;
        this.parameters = null;
        this.method = "GET";
        this.finalUrl = null;
        this.elapsedTime = 0L;
    }

    public AsyncHttpRequest(String baseUrl, String method, ArrayList<NlpParameter> parameters) {
        this.baseUrl = baseUrl;
        this.parameters = parameters;
        this.method = method == null ? "GET" : (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("POST") ? method : "GET");
        this.setFinalUrl();
        this.elapsedTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.elapsedTime = System.currentTimeMillis();
        if (this.finalUrl == null) {
            this.finalUrl = this.baseUrl;
        }
        HttpURLConnection connection = null;
        BufferedReader r = null;
        try {
            URL url = new URL(this.finalUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod(this.method);
            r = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = "";
            this.result = "";
            while (line != null) {
                line = r.readLine();
                if (line == null) continue;
                this.result = this.result + line.trim();
            }
            this.asyncHttpRequestCallback();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            this.asyncHttpRequestCallback();
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public String getResult() {
        return this.result;
    }

    public void asyncHttpRequestCallback() {
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParameters(ArrayList<NlpParameter> parameters) {
        this.parameters = parameters;
    }

    private void setFinalUrl() {
        this.finalUrl = this.baseUrl;
        if (this.parameters != null) {
            if (this.finalUrl.indexOf("?") < 0) {
                this.finalUrl = this.finalUrl + "?";
            }
            for (NlpParameter p : this.parameters) {
                try {
                    this.finalUrl = this.finalUrl + p.getName() + "=" + URLEncoder.encode((String)p.getValue(), "UTF-8");
                    this.finalUrl = this.finalUrl + "&";
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.finalUrl = this.finalUrl.substring(0, this.finalUrl.length() - 1);
        }
    }
}

