/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.tests;

import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.executor.generators.D4ScienceDistributedProcessing;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.BionymFlexibleWorkflowTransducer;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.utils.YasmeenGlobalParameters;
import org.gcube.dataanalysis.executor.tests.TestGenerator;

public class RegressionTestBiOnymProduzione {
    public static void executeWF(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setParam("DatabaseUserName", "utente");
        config.setParam("DatabasePassword", "d4science");
        config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
        config.setParam(YasmeenGlobalParameters.parserNameParam, YasmeenGlobalParameters.BuiltinParsers.SIMPLE.name());
        config.setParam(YasmeenGlobalParameters.taxaAuthorityFileParam, YasmeenGlobalParameters.BuiltinDataSources.FISHBASE.name());
        config.setParam(YasmeenGlobalParameters.activatePreParsingProcessing, "true");
        config.setParam(YasmeenGlobalParameters.useStemmedGenusAndSpecies, "false");
        config.setParam(BionymFlexibleWorkflowTransducer.matcherParamPrefix + "_" + 1, YasmeenGlobalParameters.BuiltinMatchers.GSAy.name());
        config.setParam(BionymFlexibleWorkflowTransducer.thresholdParamPrefix + "_" + 1, "0.6");
        config.setParam(BionymFlexibleWorkflowTransducer.maxresultsParamPrefix + "_" + 1, "10");
        config.setParam(BionymFlexibleWorkflowTransducer.destinationTableParam, "taxamatchoutputlocal");
        config.setParam(BionymFlexibleWorkflowTransducer.destinationTableLableParam, "taxamatchoutputlabel");
        config.setParam(BionymFlexibleWorkflowTransducer.originTableParam, "taxamatchinput1000");
        config.setParam(BionymFlexibleWorkflowTransducer.rawnamesColumnParam, "rawstrings");
        config.setAgent("BIONYM");
        config.setPersistencePath("./");
        config.setGcubeScope("/gcube");
        config.setParam("ServiceUserName", "gianpaolo.coro");
        config.setParam("DatabaseDriver", "org.postgresql.Driver");
        RegressionTestBiOnymProduzione.generate(config);
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            RegressionTestBiOnymProduzione.executeWF(args);
        }
    }

    public static void generate(AlgorithmConfiguration config) throws Exception {
        D4ScienceDistributedProcessing generator = new D4ScienceDistributedProcessing(config);
        generator.init();
        if (generator != null) {
            long t0 = System.currentTimeMillis();
            TestGenerator tgs = new TestGenerator((ComputationalAgent)generator);
            Thread t = new Thread(tgs);
            t.start();
            while (generator.getStatus() < 100.0f) {
                String resLoad = generator.getResourceLoad();
                String ress = generator.getResources();
                String species = generator.getLoad();
                System.out.println("LOAD: " + resLoad);
                System.out.println("RESOURCES: " + ress);
                System.out.println("SPECIES: " + species);
                System.out.println("STATUS: " + generator.getStatus());
                Thread.sleep(2000L);
            }
            System.out.println("FINAL STATUS: " + generator.getStatus() + " ELAPSED " + (System.currentTimeMillis() - t0));
        } else {
            System.out.println("Generator Algorithm Not Supported");
        }
    }
}

