/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.usagerecords.JobUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.DatabaseInfo;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.InfrastructureDialoguer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.TableCoherenceChecker;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IClusterer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IEvaluator;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IGenerator;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IModeller;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.ITransducer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.ConfigurationManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.InputsManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.OutputsManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.TokenManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.ComputationData;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.DataspaceManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.StoredData;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.utils.Cancellable;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.utils.Observable;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.utils.Observer;
import org.gcube.documentstore.records.Record;
import org.hibernate.SessionFactory;
import org.n52.wps.algorithm.annotation.Execute;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.server.AbstractAnnotatedAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractEcologicalEngineMapper
extends AbstractAnnotatedAlgorithm
implements Observable,
Cancellable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEcologicalEngineMapper.class);
    private Observer observer = null;
    private boolean cancelled = false;
    public LinkedHashMap<String, Object> inputs = new LinkedHashMap();
    public LinkedHashMap<String, Object> outputs = new LinkedHashMap();
    public LinkedHashMap<String, Long> times = new LinkedHashMap();
    public String startTime;
    public String endTime;
    public static HashMap<String, DatabaseInfo> databaseParametersMemoryCache = new HashMap();
    public static HashMap<String, String> runningcomputations = new HashMap();
    ComputationalAgent agent;
    public String wpsExternalID = null;
    ComputationData currentComputation;
    public AlgorithmConfiguration config;
    public InfrastructureDialoguer infrastructureDialoguer;
    float previousStatus = -3.0f;
    String host = WPSConfig.getInstance().getWPSConfig().getServer().getHostname();

    public void setWpsExternalID(String wpsExternalID) {
        this.wpsExternalID = wpsExternalID;
    }

    public static synchronized void addComputation(String session, String user) {
        runningcomputations.put(session, user);
    }

    public static synchronized void removeComputation(String session) {
        runningcomputations.remove(session);
    }

    public static synchronized int getRuningComputations() {
        return runningcomputations.size();
    }

    public static synchronized String displayRunningComputations() {
        return runningcomputations.toString();
    }

    public void waitForResources() throws Exception {
        while (AbstractEcologicalEngineMapper.getRuningComputations() > ConfigurationManager.getMaxComputations()) {
            Thread.sleep(20000L);
            LOGGER.debug("Waiting for resources to be available: " + AbstractEcologicalEngineMapper.displayRunningComputations());
        }
    }

    public static synchronized DatabaseInfo getDatabaseInfo(String scope) {
        return databaseParametersMemoryCache.get(scope);
    }

    public static synchronized void addDatabaseInfo(String scope, DatabaseInfo info) {
        databaseParametersMemoryCache.put(scope, info);
    }

    public ComputationalAgent getComputationalAgent(String algorithmName) throws Exception {
        LOGGER.debug("Searching for Agents.. " + algorithmName);
        List agents = new ArrayList();
        if (this instanceof ITransducer) {
            agents = TransducerersFactory.getTransducerers((AlgorithmConfiguration)this.config);
        } else if (this instanceof IClusterer) {
            agents = ClusterersFactory.getClusterers((AlgorithmConfiguration)this.config);
        } else if (this instanceof IEvaluator) {
            agents = EvaluatorsFactory.getEvaluators((AlgorithmConfiguration)this.config);
        } else if (this instanceof IGenerator) {
            agents = GeneratorsFactory.getGenerators((AlgorithmConfiguration)this.config);
        } else if (this instanceof IModeller) {
            agents = ModelersFactory.getModelers((AlgorithmConfiguration)this.config);
        }
        if (agents != null && agents.size() > 0 && agents.get(0) != null) {
            LOGGER.debug("Found " + agents.size() + " Agents for " + algorithmName);
            ComputationalAgent agent = (ComputationalAgent)agents.get(0);
            agent.setConfiguration(this.config);
            return agent;
        }
        return null;
    }

    public List<StatisticalType> getInputParameters(String algorithmName) throws Exception {
        LOGGER.debug("Searching for Agents Inputs.. " + algorithmName);
        ArrayList<StatisticalType> parameters = new ArrayList();
        if (this instanceof ITransducer) {
            parameters = TransducerersFactory.getTransducerParameters((AlgorithmConfiguration)this.config, (String)algorithmName);
        } else if (this instanceof IClusterer) {
            parameters = ClusterersFactory.getClustererParameters((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IEvaluator) {
            parameters = EvaluatorsFactory.getEvaluatorParameters((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IGenerator) {
            parameters = GeneratorsFactory.getAlgorithmParameters((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IModeller) {
            parameters = ModelersFactory.getModelParameters((String)this.config.getConfigPath(), (String)algorithmName);
        }
        if (parameters != null) {
            LOGGER.debug("Found " + parameters.size() + " Parameters for " + algorithmName);
            return parameters;
        }
        return null;
    }

    public StatisticalType getOutput(String algorithmName) throws Exception {
        LOGGER.debug("Searching for Agents Inputs.. " + algorithmName);
        StatisticalType output = null;
        if (this instanceof ITransducer) {
            output = TransducerersFactory.getTransducerOutput((AlgorithmConfiguration)this.config, (String)algorithmName);
        } else if (this instanceof IClusterer) {
            output = ClusterersFactory.getClustererOutput((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IEvaluator) {
            output = EvaluatorsFactory.getEvaluatorOutput((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IGenerator) {
            output = GeneratorsFactory.getAlgorithmOutput((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IModeller) {
            output = ModelersFactory.getModelOutput((String)this.config.getConfigPath(), (String)algorithmName);
        }
        if (output != null) {
            LOGGER.debug("Found " + output + " for " + algorithmName);
            return output;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemporaryTables(List<String> generatedInputTables) throws Exception {
        if (generatedInputTables != null && generatedInputTables.size() > 0) {
            SessionFactory dbConnection = null;
            try {
                dbConnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
                for (String table : generatedInputTables) {
                    if (table != null) {
                        if (TableCoherenceChecker.isSystemTable(table)) continue;
                        LOGGER.debug("Dropping Temporary Table: " + table);
                        try {
                            DatabaseFactory.executeSQLUpdate((String)("drop table " + table), (SessionFactory)dbConnection);
                        }
                        catch (Exception e) {
                            LOGGER.debug("Could not drop Temporary Table: " + table);
                        }
                        continue;
                    }
                    LOGGER.debug("Could not drop Temporary Table: " + table + " table is null");
                }
            }
            catch (Exception e) {
                LOGGER.error("error deleting temporary table", (Throwable)e);
            }
            finally {
                DatabaseUtils.closeDBConnection((SessionFactory)dbConnection);
            }
        }
    }

    public static void deleteGeneratedFiles(List<File> generatedFiles) throws Exception {
        System.gc();
        if (generatedFiles != null) {
            for (File file : generatedFiles) {
                if (file.exists()) {
                    LOGGER.debug("Deleting File " + file.getAbsolutePath());
                    try {
                        LOGGER.debug("Deleting File Check " + file.delete());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                LOGGER.debug("Deleting File - File does not exist " + file.getAbsolutePath());
            }
        }
        System.gc();
    }

    public void manageUserToken() {
        String scope = null;
        String username = null;
        String token = null;
        TokenManager tokenm = new TokenManager();
        tokenm.getCredentials();
        scope = tokenm.getScope();
        username = tokenm.getUserName();
        token = tokenm.getToken();
        this.inputs.put(ConfigurationManager.scopeParameter, scope);
        this.inputs.put(ConfigurationManager.usernameParameter, username);
        this.inputs.put(ConfigurationManager.tokenParameter, token);
    }

    public void updateStatus(float status) {
        if (this.agent != null && status != this.previousStatus) {
            LOGGER.debug("STATUS update to: {} ", (Object)Float.valueOf(status));
            this.previousStatus = status;
            super.update((Object)new Integer((int)status));
            try {
                this.updateComputationOnWS(status, null);
            }
            catch (Exception e) {
                LOGGER.warn("error updating compution on WS");
            }
        }
    }

    public void updateComputationOnWS(float status, String exception) {
        this.updateComputationOnWS(status, exception, null, null);
    }

    public void updateComputationOnWS(float status, String exception, List<StoredData> inputData, List<File> generatedData) {
        if (this.currentComputation != null) {
            this.currentComputation.setStatus("" + status);
            if (exception != null && exception.length() > 0) {
                this.currentComputation.setException(exception);
            }
            RunDataspaceManager rundm = new RunDataspaceManager(inputData, generatedData);
            rundm.run();
        }
    }

    @Execute
    public void run() throws Exception {
        if (this.observer != null) {
            this.observer.isStarted(this);
        }
        long startTimeLong = System.currentTimeMillis();
        UsageRecord.OperationResult operationResult = null;
        String algorithm = "";
        List<String> generatedInputTables = null;
        List<String> generatedOutputTables = null;
        List<File> generatedFiles = null;
        String computationSession = this.getAlgorithmClass().getSimpleName() + "_ID_" + UUID.randomUUID().toString();
        if (this.wpsExternalID != null) {
            LOGGER.info("Using wps External ID " + this.wpsExternalID);
            computationSession = this.getAlgorithmClass().getSimpleName() + "_ID_" + this.wpsExternalID;
        } else {
            LOGGER.info("Wps External ID not set");
        }
        InputsManager inputsManager = null;
        ConfigurationManager configManager = new ConfigurationManager();
        this.manageUserToken();
        try {
            this.startTime = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(System.currentTimeMillis());
            this.time("WPS Algorithm objects Initialization: Session " + computationSession);
            configManager.configAlgorithmEnvironment(this.inputs);
            configManager.setComputationId(computationSession);
            this.config = configManager.getConfig();
            LOGGER.info("Configured algorithm with session " + computationSession);
            this.time("Configuration");
            this.waitForResources();
            LOGGER.info("Running algorithm with session " + computationSession);
            this.time("Waiting time for resources to be free");
            AbstractEcologicalEngineMapper.addComputation(computationSession, configManager.getUsername() + ":" + configManager.getScope());
            String scope = configManager.getScope();
            String username = configManager.getUsername();
            LOGGER.info("1 - Algorithm environment initialized in scope " + scope + " with user name " + username + " and session " + computationSession);
            LOGGER.info("Max allowed computations " + ConfigurationManager.getMaxComputations() + " using storage " + ConfigurationManager.useStorage());
            LOGGER.info("2 - Initializing connection to the e-Infrastructure");
            this.infrastructureDialoguer = new InfrastructureDialoguer(scope);
            this.time("Connection to the e-Infrastructure initialized");
            LOGGER.info("3 - Initializing connection to the e-Infrastructure central database for computations");
            DatabaseInfo supportDatabaseInfo = AbstractEcologicalEngineMapper.getDatabaseInfo(scope);
            if (supportDatabaseInfo == null) {
                supportDatabaseInfo = this.infrastructureDialoguer.getDatabaseInfo("StatisticalManagerDataBase");
                AbstractEcologicalEngineMapper.addDatabaseInfo(scope, supportDatabaseInfo);
            } else {
                LOGGER.info("Using cached database information: " + supportDatabaseInfo);
            }
            LOGGER.info("Retrieved Central Database: " + supportDatabaseInfo);
            inputsManager = new InputsManager(this.inputs, this.config, computationSession);
            inputsManager.configSupportDatabaseParameters(supportDatabaseInfo);
            this.time("Central database information retrieval");
            LOGGER.info("4 - Retrieving WPS algorithm name");
            algorithm = this.getAlgorithmClass().getSimpleName();
            LOGGER.debug("Selected Algorithm: " + algorithm);
            this.config.setAgent(algorithm);
            this.config.setModel(algorithm);
            this.time("Ecological Engine Algorithm selection");
            LOGGER.info("5 - Adding Service parameters to the configuration");
            inputsManager.addInputServiceParameters(this.getInputParameters(algorithm), this.infrastructureDialoguer);
            this.time("Service parameters added to the algorithm");
            LOGGER.info("6 - Translating WPS Inputs into Ecological Engine Inputs");
            LOGGER.debug("Operator class is " + this.getClass().getCanonicalName());
            this.currentComputation = new ComputationData(this.config.getTaskID(), this.config.getAgent(), "", "", this.startTime, "-", "0", this.config.getTaskID(), configManager.getUsername(), this.config.getGcubeScope(), this.getClass().getCanonicalName());
            inputsManager.mergeWpsAndEcologicalInputs(supportDatabaseInfo);
            generatedInputTables = inputsManager.getGeneratedTables();
            generatedFiles = inputsManager.getGeneratedInputFiles();
            this.time("Setup and download of input parameters with tables creation");
            LOGGER.info("7 - Retrieving Ecological Engine algorithm");
            this.agent = this.getComputationalAgent(algorithm);
            this.currentComputation.setOperatorDescription(this.agent.getDescription());
            this.currentComputation.setInfrastructure(this.agent.getInfrastructure().name());
            LOGGER.debug("Found Ecological Engine Algorithm: " + this.agent);
            this.time("Algorithm initialization");
            LOGGER.info("8 - Retrieving the a priori output of the algorithm");
            StatisticalType prioroutput = null;
            try {
                prioroutput = this.getOutput(algorithm);
            }
            catch (Exception e) {
                LOGGER.info("Warning: No a priori output for algorithm " + algorithm);
            }
            this.time("A priori output retrieval");
            LOGGER.info("9 - Running the computation and updater");
            LOGGER.info("Initializing the WPS status of the computation");
            this.updateStatus(0.0f);
            LOGGER.info("Initializing the computation");
            this.agent.init();
            LOGGER.info("Updating status");
            this.runStatusUpdater();
            LOGGER.info("Running the computation");
            this.agent.compute();
            LOGGER.info("The computation has finished. Retrieving output");
            this.time("Execution time");
            LOGGER.info("10 - Retrieving the a posteriori output of the algorithm");
            StatisticalType postoutput = this.agent.getOutput();
            LOGGER.debug("Computation Output: " + postoutput);
            this.time("Output retrieval");
            LOGGER.info("11 - Merging the a priori and a posteriori output");
            OutputsManager outputmanager = new OutputsManager(this.config, computationSession);
            this.outputs = outputmanager.createOutput(prioroutput, postoutput);
            generatedOutputTables = outputmanager.getGeneratedTables();
            if (ConfigurationManager.useStorage().booleanValue()) {
                generatedFiles.addAll(outputmanager.getGeneratedFiles());
                this.time("Output preparation for WPS document (using storage)");
            } else {
                this.time("Output preparation for WPS document (no storage manager)");
            }
            outputmanager.shutdown();
            LOGGER.info("12 - Deleting possible generated temporary tables");
            LOGGER.debug("Final Computation Output: " + this.outputs);
            this.endTime = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(System.currentTimeMillis());
            if (this.isCancelled()) {
                LOGGER.debug("Computation interrupted - no update");
                throw new Exception("Computation cancelled");
            }
            this.saveComputationOnWS(inputsManager.getProvenanceData(), outputmanager.getProvenanceData(), this.agent, generatedFiles);
            LOGGER.debug("All done");
            operationResult = UsageRecord.OperationResult.SUCCESS;
        }
        catch (Exception e) {
            operationResult = UsageRecord.OperationResult.FAILED;
            LOGGER.error("Error execution Algorithm {}", (Object)algorithm, (Object)e);
            int exitstatus = -2;
            if (this.isCancelled()) {
                exitstatus = -1;
            }
            if (inputsManager != null) {
                this.updateComputationOnWS(exitstatus, e.getMessage(), inputsManager.getProvenanceData(), generatedFiles);
            } else {
                this.updateComputationOnWS(exitstatus, e.getMessage());
            }
            if (this.isCancelled()) {
                throw new Exception("Computation cancelled");
            }
            throw e;
        }
        finally {
            LOGGER.debug("Deleting Input Tables");
            this.deleteTemporaryTables(generatedInputTables);
            LOGGER.debug("Deleting Output Tables");
            this.deleteTemporaryTables(generatedOutputTables);
            AbstractEcologicalEngineMapper.removeComputation(computationSession);
            this.time("Cleaning of resources");
            this.displayTimes();
            this.cleanResources();
            if (this.observer != null) {
                this.observer.isFinished(this);
            }
            LOGGER.debug("All done - Computation Finished");
            this.accountAlgorithmExecution(configManager, startTimeLong, System.currentTimeMillis(), operationResult);
        }
    }

    private void accountAlgorithmExecution(ConfigurationManager confManager, long start, long end, UsageRecord.OperationResult result) {
        try {
            JobUsageRecord jobUsageRecord = new JobUsageRecord();
            jobUsageRecord.setJobName(this.getAlgorithmClass().getSimpleName());
            jobUsageRecord.setConsumerId(confManager.getUsername());
            jobUsageRecord.setDuration(Long.valueOf(end - start));
            jobUsageRecord.setOperationResult(result);
            jobUsageRecord.setServiceName("DataMiner");
            jobUsageRecord.setServiceClass("WPS");
            jobUsageRecord.setHost(WPSConfig.getInstance().getWPSConfig().getServer().getHostname());
            AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
            accountingPersistence.account((Record)jobUsageRecord);
        }
        catch (Exception e) {
            LOGGER.error("error accounting algorithm execution", (Throwable)e);
        }
    }

    private void runStatusUpdater() {
        StatusUpdater updater = new StatusUpdater();
        Thread t = new Thread(updater);
        t.start();
        LOGGER.debug("Provenance manager running");
    }

    private void saveComputationOnWS(List<StoredData> inputData, List<StoredData> outputData, ComputationalAgent agent, List<File> generatedFiles) {
        LOGGER.debug("Provenance manager started for operator " + this.getClass().getCanonicalName());
        ComputationData computation = new ComputationData(this.config.getTaskID(), this.config.getAgent(), agent.getDescription(), agent.getInfrastructure().name(), this.startTime, this.endTime, "100", this.config.getTaskID(), this.config.getParam(ConfigurationManager.serviceUserNameParameterVariable), this.config.getGcubeScope(), this.getClass().getCanonicalName());
        DataspaceManager manager = new DataspaceManager(this.config, computation, inputData, outputData, generatedFiles);
        Thread t = new Thread(manager);
        t.start();
        LOGGER.debug("Provenance manager running");
    }

    private void time(String label) {
        this.times.put(label, System.currentTimeMillis());
    }

    private void displayTimes() {
        LOGGER.debug("Times Summary:");
        LOGGER.debug("Label;Elapsed(ms);Time");
        long prevtime = 0L;
        long inittime = 0L;
        for (String label : this.times.keySet()) {
            long currentTime = this.times.get(label);
            if (prevtime == 0L) {
                prevtime = currentTime;
                inittime = currentTime;
            }
            LOGGER.debug(label + ";" + (currentTime - prevtime) + ";" + new Date(currentTime));
            prevtime = currentTime;
        }
        LOGGER.debug("Total Elapsed;" + (prevtime - inittime) + ";" + new Date(prevtime));
    }

    private void cleanResources() {
        this.times = null;
        this.agent = null;
        LOGGER.debug("Managing open files");
        try {
            String checkOpenFiles = "for i in `ls -l /proc/*/fd/* 2>/dev/null | grep delete | grep tomcat | awk '{print $9}'`; do du -hL $i | awk '{print $1}' | tr '\n' ' '; ls -l $i | awk '{print $6\" \"$7\" \"$8\" \"$9\" \"$10\" \"$11\" \"$12}'; done";
            List<String> openFiles = AbstractEcologicalEngineMapper.command(checkOpenFiles, "./");
            LOGGER.debug("Open Files " + openFiles);
            if (openFiles != null) {
                for (String openFile : openFiles) {
                    if (openFile.contains("cannot access") || !openFile.contains("(deleted)")) continue;
                    String size = openFile.substring(0, openFile.indexOf(" ")).trim();
                    String pid = openFile.substring(openFile.indexOf("/proc/"), openFile.indexOf("->"));
                    pid = pid.trim();
                    if (size.equals("0")) continue;
                    LOGGER.debug("Killing " + pid + " with size " + size);
                    AbstractEcologicalEngineMapper.command(":>" + pid, "./");
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not kill files " + e.getLocalizedMessage());
        }
        System.gc();
    }

    public static List<String> command(String cmdline, String directory) {
        try {
            Process process = new ProcessBuilder("bash", "-c", cmdline).redirectErrorStream(true).directory(new File(directory)).start();
            ArrayList<String> output = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                output.add(line);
            }
            if (0 != process.waitFor()) {
                return null;
            }
            return output;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setObserver(Observer o) {
        LOGGER.debug("setting observer in {} ", (Object)this.wpsExternalID);
        this.observer = o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized boolean cancel() {
        if (!this.cancelled) {
            LOGGER.debug("COMPUTATION INTERRUPTED! ({})", (Object)this.wpsExternalID);
            try {
                if (this.agent != null) {
                    this.agent.shutdown();
                    this.agent = null;
                }
                super.update((Object)new Integer(-1));
                try {
                    this.updateComputationOnWS(-1.0f, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.gc();
                this.cancelled = true;
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("error cancelling computation with id {}", (Object)this.wpsExternalID);
                return false;
            }
        }
        LOGGER.debug("COMPUTATION ALREADY INTERRUPT! ({})", (Object)this.wpsExternalID);
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    public class StatusUpdater
    implements Runnable {
        @Override
        public void run() {
            while (AbstractEcologicalEngineMapper.this.agent != null && !AbstractEcologicalEngineMapper.this.isCancelled() && AbstractEcologicalEngineMapper.this.agent.getStatus() < 100.0f) {
                try {
                    AbstractEcologicalEngineMapper.this.updateStatus(AbstractEcologicalEngineMapper.this.agent.getStatus());
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            LOGGER.info("Status updater terminated");
        }
    }

    class RunDataspaceManager
    implements Runnable {
        List<StoredData> inputData;
        List<File> generatedData;

        public RunDataspaceManager(List<StoredData> inputData, List<File> generatedData) {
            this.inputData = inputData;
            this.generatedData = generatedData;
        }

        @Override
        public void run() {
            DataspaceManager manager = new DataspaceManager(AbstractEcologicalEngineMapper.this.config, AbstractEcologicalEngineMapper.this.currentComputation, this.inputData, null, this.generatedData);
            try {
                LOGGER.debug("Dataspace->Status updater->Writing computational info on the WS asyncronously");
                manager.writeRunningComputationData();
            }
            catch (Exception ez) {
                LOGGER.error("Dataspace->Status updater->Impossible to write computation information on the Workspace", (Throwable)ez);
            }
        }
    }
}

