/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.matrixmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.utils.CSquareCodesConverter;
import org.gcube.dataanalysis.geo.utils.VectorOperations;
import org.hibernate.SessionFactory;

public class RasterTable {
    private double[][] valuesMatrix;
    private HashMap<Double, Map<String, String>> valuesPropertiesMap;
    double x1;
    double x2;
    double y1;
    double y2;
    double z;
    double time;
    double xResolution;
    double yResolution;
    List<Tuple<Double>> coordinates;
    private AlgorithmConfiguration configuration;
    private String tablename = "rstr" + ("" + UUID.randomUUID()).replace("-", "");
    static String createTableStatementStandard = "CREATE TABLE %1$s (id serial, csquarecode character varying, x real, y real, z real, t real, fvalue character varying)";
    static String createTableStatementWithFields = "CREATE TABLE %1$s (id serial,  approx_x real, approx_y real, z real, t real, %2$s)";
    static String columnsnamesStandard = "csquarecode, x , y , z , t, fvalue";
    static String columnsnamesWithFields = "approx_x , approx_y , z , t , %1$s";
    public static String csquareColumn = "csquarecode";
    public static String valuesColumn = "fvalue";
    public static String idColumn = "id";

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public List<Tuple<Double>> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<Tuple<Double>> coordinates) {
        this.coordinates = coordinates;
    }

    public RasterTable(double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution, double[][] values, AlgorithmConfiguration configuration) {
        this.init(x1, x2, y1, y2, z, 0.0, xResolution, yResolution, values, null, configuration);
    }

    public RasterTable(double x1, double x2, double y1, double y2, double z, double time, double xResolution, double yResolution, double[][] values, AlgorithmConfiguration configuration) {
        this.init(x1, x2, y1, y2, z, time, xResolution, yResolution, values, null, configuration);
    }

    public RasterTable(double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution, double[][] values, HashMap<Double, Map<String, String>> valuesPropertiesMap, AlgorithmConfiguration configuration) {
        this.init(x1, x2, y1, y2, z, 0.0, xResolution, yResolution, values, valuesPropertiesMap, configuration);
    }

    public RasterTable(double x1, double x2, double y1, double y2, double z, double time, double xResolution, double yResolution, double[][] values, HashMap<Double, Map<String, String>> valuesPropertiesMap, AlgorithmConfiguration configuration) {
        this.init(x1, x2, y1, y2, z, time, xResolution, yResolution, values, valuesPropertiesMap, configuration);
    }

    public void init(double x1, double x2, double y1, double y2, double z, double time, double xResolution, double yResolution, double[][] values, HashMap<Double, Map<String, String>> valuesPropertiesMap, AlgorithmConfiguration configuration) {
        this.valuesMatrix = values;
        if (valuesPropertiesMap != null && valuesPropertiesMap.size() > 0) {
            this.valuesPropertiesMap = valuesPropertiesMap;
        }
        this.configuration = configuration;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.z = z;
        this.time = time;
        this.xResolution = xResolution;
        this.yResolution = yResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpGeoTable() {
        SessionFactory dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.configuration);
        try {
            AnalysisLogger.getLogger().debug((Object)"Database Initialized");
            String columnNames = columnsnamesStandard;
            String emptycolumns = "";
            if (this.valuesPropertiesMap == null) {
                AnalysisLogger.getLogger().debug((Object)"Rasterization->No properties to associate");
                DatabaseFactory.executeSQLUpdate((String)String.format(createTableStatementStandard, this.tablename), (SessionFactory)dbconnection);
            } else {
                AnalysisLogger.getLogger().debug((Object)"Managing Table with Custom Fields");
                Map<String, String> valuesMap = this.valuesPropertiesMap.values().iterator().next();
                AnalysisLogger.getLogger().debug((Object)("Rasterization->Sample of properties: " + valuesMap));
                emptycolumns = RasterTable.generateEmptyValues(valuesMap.size());
                DatabaseFactory.executeSQLUpdate((String)String.format(createTableStatementWithFields, this.tablename, RasterTable.propertiesMapToColumnString(valuesMap, true)), (SessionFactory)dbconnection);
                columnNames = String.format(columnsnamesWithFields, RasterTable.propertiesMapToColumnString(valuesMap, false));
                AnalysisLogger.getLogger().debug((Object)("Column names: " + columnNames));
            }
            AnalysisLogger.getLogger().debug((Object)("Table " + this.tablename + " created"));
            if (this.coordinates == null) {
                this.coordinates = VectorOperations.generateCoordinateTripletsInBoundingBox(this.x1, this.x2, this.y1, this.y2, this.z, this.xResolution, this.yResolution);
            }
            int triplets = this.coordinates.size();
            AnalysisLogger.getLogger().debug((Object)("Generated " + triplets + " coordinates triples"));
            List<Double> values = RasterTable.associateValueToCoordinates(this.coordinates, this.valuesMatrix);
            AnalysisLogger.getLogger().debug((Object)"Association to values completed - fulfilling buffer");
            StringBuffer sb = new StringBuffer();
            int rowcounter = 1;
            for (int i = 0; i < triplets; ++i) {
                Tuple<Double> cset = this.coordinates.get(i);
                double x = (Double)cset.getElements().get(0);
                double y = (Double)cset.getElements().get(1);
                String csquare = CSquareCodesConverter.convertAtResolution(y, x, this.xResolution);
                String valueForTable = "";
                Double value = values.get(i);
                if (this.valuesPropertiesMap == null) {
                    if (value.isNaN()) {
                        value = 0.0;
                    }
                    valueForTable = "" + value;
                } else {
                    valueForTable = value.isNaN() ? null : RasterTable.propertiesMapToDatabaseString(this.valuesPropertiesMap.get(values.get(i)));
                }
                double zVal = this.z;
                if (cset.getElements().size() > 2) {
                    zVal = (Double)cset.getElements().get(2);
                }
                String tVal = "" + this.time;
                if (cset.getElements().size() > 3) {
                    tVal = "" + cset.getElements().get(3);
                    if (Double.isNaN((Double)cset.getElements().get(3)) || Double.isInfinite((Double)cset.getElements().get(3))) {
                        tVal = "NULL";
                    }
                }
                if (valueForTable != null) {
                    ++rowcounter;
                    if (this.valuesPropertiesMap == null) {
                        sb.append("('" + csquare + "'," + x + "," + y + "," + zVal + "," + tVal + ",'" + valueForTable + "')");
                    } else {
                        sb.append("(" + x + "," + y + "," + zVal + "," + tVal + "," + valueForTable + ")");
                    }
                }
                if (rowcounter % 5000 == 0) {
                    String insertStatement = DatabaseUtils.insertFromBuffer((String)this.tablename, (String)columnNames, (StringBuffer)sb);
                    DatabaseFactory.executeSQLUpdate((String)insertStatement, (SessionFactory)dbconnection);
                    sb = new StringBuffer();
                    continue;
                }
                if (valueForTable == null) continue;
                sb.append(",");
            }
            AnalysisLogger.getLogger().debug((Object)("Inserting Final Buffer of " + sb.length() + " Values"));
            if (sb.length() > 0) {
                String insertStatement = DatabaseUtils.insertFromString((String)this.tablename, (String)columnNames, (String)sb.substring(0, sb.length() - 1));
                DatabaseFactory.executeSQLUpdate((String)insertStatement, (SessionFactory)dbconnection);
                AnalysisLogger.getLogger().debug((Object)"Insertion completed with Success!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("Error in dumping table: " + e.getLocalizedMessage()));
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
            AnalysisLogger.getLogger().debug((Object)"Raster Geo Table DB closed!");
        }
    }

    public static String propertiesMapToDatabaseString(Map<String, String> valuesMap) {
        StringBuffer sb = new StringBuffer();
        int m = valuesMap.size();
        int i = 0;
        for (String value : valuesMap.values()) {
            sb.append("'" + value.replace("'", "`") + "'");
            if (i < m - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String propertiesMapToColumnString(Map<String, String> valuesMap, boolean withtype) {
        StringBuffer sb = new StringBuffer();
        int m = valuesMap.size();
        int i = 0;
        for (String keys : valuesMap.keySet()) {
            sb.append(keys);
            if (withtype) {
                sb.append(" character varying");
            }
            if (i < m - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String generateEmptyValues(int nValues) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < nValues; ++j) {
            sb.append("NULL");
            if (j >= nValues - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTable() {
        SessionFactory dbconnection = null;
        try {
            dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.configuration);
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.tablename), (SessionFactory)dbconnection);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Impossible to delete table " + this.tablename + " : " + e.getLocalizedMessage()));
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
        }
    }

    public static List<Double> associateValueToCoordinates(List<Tuple<Double>> coordinates, double[][] data) {
        ArrayList<Double> values = new ArrayList<Double>();
        int k = 0;
        int g = 0;
        int ntriplets = coordinates.size();
        int xsteps = data[0].length - 1;
        for (int t = 0; t < ntriplets; ++t) {
            values.add(data[k][g]);
            if (g == xsteps) {
                g = 0;
                ++k;
                continue;
            }
            ++g;
        }
        return values;
    }
}

