/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.vti;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.geo.utils.CSquareCodesConverter;
import org.gcube.dataanalysis.geo.vti.GridCWP2Coordinates;
import org.gcube.dataanalysis.geo.vti.vesselsprocessing.MonthlyFishingEffortCalculator;
import org.hibernate.SessionFactory;

public class EstimateMonthlyFishingEffort
extends GridCWP2Coordinates {
    static String VesselsLatitudesColumn = "VesselsLatitudesColumn";
    static String VesselsLongitudesColumn = "VesselsLongitudesColumn";
    static String VesselsTimestampsColumn = "VesselsTimestampsColumn";
    static String VesselsHoursColumn = "VesselsActivityHoursColumn";
    static String VesselsActivityClassificationColumn = "VesselsActivityClassificationColumn";

    @Override
    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, inputTableParameter, "The table to which the algorithm will add information");
        this.inputs.add(tinput);
        ColumnType Dimension1 = new ColumnType(inputTableParameter, VesselsLatitudesColumn, "The column containing vessels latitudes", "y", false);
        ColumnType Dimension2 = new ColumnType(inputTableParameter, VesselsLongitudesColumn, "The column containing vessels longitudes", "x", false);
        ColumnType Dimension3 = new ColumnType(inputTableParameter, VesselsTimestampsColumn, "The column containing the time stamp of the vessels transmitted information", "datetime", false);
        ColumnType Dimension4 = new ColumnType(inputTableParameter, VesselsHoursColumn, "The column containing the activity hours spent by the vessels in steaming, howling or fishing", "activity_hours", false);
        ColumnType Dimension5 = new ColumnType(inputTableParameter, VesselsActivityClassificationColumn, "The column containing the a simple point-by-point activity classification as Fishing, Steaming, Howling etc.", "activity_class_speed", false);
        this.inputs.add(Dimension1);
        this.inputs.add(Dimension2);
        this.inputs.add(Dimension3);
        this.inputs.add(Dimension4);
        this.inputs.add(Dimension5);
        IOHelper.addStringInput((List)this.inputs, (String)outputTableParameter, (String)"The name of the output table", (String)"monthfish_");
        DatabaseType.addDefaultDBPars((List)this.inputs);
    }

    @Override
    public String getDescription() {
        return "An algorithm that estimates fishing exploitation at 0.5 degrees resolution from activity-classified vessels trajectories. Produces a table with csquare codes, latitudes, longitudes and resolution and associated overall fishing hours in the time frame of the vessels activity. Requires each activity point to be classified as Fishing or other. This algorithm is based on the paper 'Deriving Fishing Monthly Effort and Caught Species' (Coro et al. 2013, in proc. of OCEANS - Bergen, 2013 MTS/IEEE). Example of input table (NAFO anonymised data): http://goo.gl/3auJkM";
    }

    @Override
    protected void process() throws Exception {
        this.status = 0.0f;
        AnalysisLogger.setLogger((String)(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        long t0 = System.currentTimeMillis();
        String table = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)inputTableParameter);
        this.outTable = ("mfe_" + UUID.randomUUID()).replace("-", "");
        this.outTableLabel = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)outputTableParameter);
        AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: received parameters: " + this.config.getGeneralProperties()));
        AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: input table: " + table + " outputTable: " + this.outTable + " outLabel: " + this.outTableLabel));
        this.status = 10.0f;
        try {
            try {
                this.addInformationColumsToTable(table);
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: finished in " + (System.currentTimeMillis() - t0) + " ms"));
            }
            catch (Throwable e) {
                throw new Exception(e.getMessage());
            }
        }
        finally {
            this.status = 100.0f;
        }
    }

    @Override
    public void addInformationColumsToTable(String table) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"EstimateMonthlyFishingEffort: initializing connection");
        long t0 = System.currentTimeMillis();
        try {
            try {
                if (this.config.getParam(VesselsLatitudesColumn) == null || this.config.getParam(VesselsLongitudesColumn) == null || this.config.getParam(VesselsTimestampsColumn) == null || this.config.getParam(VesselsHoursColumn) == null || this.config.getParam(VesselsActivityClassificationColumn) == null) {
                    throw new Exception("Error with input parameters, please check that all the required inputs have been provided.");
                }
                this.connection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: database: " + this.config.getDatabaseURL()));
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: dropping table " + this.outTable + " if exists"));
                try {
                    DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.outTable), (SessionFactory)this.connection);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: table " + this.outTable + " does not exist yet"));
                }
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: creating the new table " + this.outTable));
                String csquareCol = "csquares";
                String longitudeCol = "center_longitude";
                String latitudeCol = "center_latitude";
                String resolutionCol = "resolution";
                String fishingeffortCol = "fishing_effort";
                DatabaseFactory.executeSQLUpdate((String)("create table " + this.outTable + " (" + csquareCol + " character varying, " + longitudeCol + " real, " + latitudeCol + " real, " + resolutionCol + " real, " + fishingeffortCol + " real)"), (SessionFactory)this.connection);
                String selectVinfo = "select \"" + this.config.getParam(VesselsLongitudesColumn) + "\"" + "," + "\"" + this.config.getParam(VesselsLatitudesColumn) + "\"" + "," + "\"" + this.config.getParam(VesselsTimestampsColumn) + "\"" + "," + "\"" + this.config.getParam(VesselsHoursColumn) + "\"" + "," + "\"" + this.config.getParam(VesselsActivityClassificationColumn) + "\"" + " from " + table;
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: select info: " + selectVinfo));
                List vesselsInfo = DatabaseFactory.executeSQLQuery((String)selectVinfo, (SessionFactory)this.connection);
                int ncoords = vesselsInfo.size();
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: Rebuilding effort from n. coords: " + ncoords));
                Date minDate = null;
                Date maxDate = null;
                ArrayList<Object> infoRows = new ArrayList<Object>();
                for (Object vesselInfo : vesselsInfo) {
                    Object[] vesselrow = (Object[])vesselInfo;
                    Double x = Double.parseDouble("" + vesselrow[0]);
                    Double y = Double.parseDouble("" + vesselrow[1]);
                    Date d = DateGuesser.convertDate((String)("" + vesselrow[2])).getTime();
                    if (minDate == null) {
                        String pattern = DateGuesser.getPattern((String)("" + vesselrow[2]));
                        AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: Time detected : " + d));
                        AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: Time pattern : " + pattern + " estimated from " + vesselrow[2]));
                    }
                    if (minDate == null || minDate.after(d)) {
                        minDate = d;
                    }
                    if (maxDate == null || maxDate.before(d)) {
                        maxDate = d;
                    }
                    Double hours = Double.parseDouble("" + vesselrow[3]);
                    String activity = "" + vesselrow[4];
                    Object[] infoRow = new Object[]{x, y, d, hours, activity};
                    infoRows.add(infoRow);
                }
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: Rebuilt effort:  minDate" + minDate + " maxDate " + maxDate));
                MonthlyFishingEffortCalculator mfec = new MonthlyFishingEffortCalculator();
                AnalysisLogger.getLogger().debug((Object)"EstimateMonthlyFishingEffort: Estimating monthly effort");
                Map<String, Double> fme = mfec.calculateMonthlyFishingEffort(infoRows, minDate, maxDate);
                ArrayList<String[]> values = new ArrayList<String[]>();
                for (String csquare : fme.keySet()) {
                    String[] valuesRow = new String[5];
                    valuesRow[0] = csquare;
                    valuesRow[4] = "" + fme.get(csquare);
                    CSquareCodesConverter converter = new CSquareCodesConverter();
                    converter.parse(csquare);
                    valuesRow[1] = "" + converter.getCurrentLong();
                    valuesRow[2] = "" + converter.getCurrentLat();
                    valuesRow[3] = "" + converter.getCurrentResolution();
                    values.add(valuesRow);
                }
                int fmenum = fme.size();
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: number of csquares found " + fmenum));
                String colnames = String.valueOf(csquareCol) + "," + longitudeCol + "," + latitudeCol + "," + resolutionCol + "," + fishingeffortCol;
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: inserting chunks into the table " + this.outTable));
                DatabaseUtils.insertChunksIntoTable((String)this.outTable, (String)colnames.toString(), values, (int)fme.size(), (SessionFactory)this.connection, (boolean)true);
                AnalysisLogger.getLogger().debug((Object)"EstimateMonthlyFishingEffort: inserting chunks done!");
                AnalysisLogger.getLogger().debug((Object)"EstimateMonthlyFishingEffort: finished");
            }
            catch (Throwable e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort : ERROR!: " + e.getLocalizedMessage()));
                try {
                    AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: dropping " + this.outTable));
                    DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.outTable), (SessionFactory)this.connection);
                }
                catch (Exception e1) {
                    AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort: could not drop " + this.outTable));
                }
                throw new Exception(e.getMessage());
            }
        }
        finally {
            this.shutdown();
            AnalysisLogger.getLogger().debug((Object)("EstimateMonthlyFishingEffort finished in " + (System.currentTimeMillis() - t0) + " ms"));
        }
    }
}

