/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.signals.PeriodicityDetector;
import org.gcube.dataanalysis.geo.matrixmodel.TimeSeriesExtractor;

public class TestGeoTiff {
    static String cfg = "./cfg/";

    public static void main(String[] args) throws Exception {
        String layertitle = "WorldClimBioWCS2";
        long t0 = System.currentTimeMillis();
        AnalysisLogger.setLogger((String)(String.valueOf(cfg) + AlgorithmConfiguration.defaultLoggerFile));
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setGcubeScope("/d4science.research-infrastructures.eu/gCubeApps/BiodiversityLab");
        config.setConfigPath(cfg);
        TimeSeriesExtractor intersector = new TimeSeriesExtractor(config);
        double[] signal = intersector.extractT(layertitle, 0.0, 0.0, 0.0, 0.5);
        System.out.println("ELAPSED TIME: " + (System.currentTimeMillis() - t0));
        System.out.println("Signal: " + signal.length);
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File("signal.txt")));
        double[] dArray = signal;
        int n = signal.length;
        int n2 = 0;
        while (n2 < n) {
            double si = dArray[n2];
            bw.write(String.valueOf(si) + ",");
            ++n2;
        }
        bw.close();
        PeriodicityDetector pd = new PeriodicityDetector();
        double F = pd.detectFrequency(signal, true);
        System.out.println("Detected Frequency:" + F + " indecision [" + pd.lowermeanF + " , " + pd.uppermeanF + "]");
        System.out.println("Detected Period:" + pd.meanPeriod + " indecision [" + pd.lowermeanPeriod + " , " + pd.uppermeanPeriod + "]");
        System.out.println("Detected Periodicity Strength:" + pd.periodicityStrength + " " + pd.getPeriodicityStregthInterpretation());
    }

    public static void main1(String[] args) throws Exception {
        TestGeoTiff.takeSignal();
    }

    public static void takeSignal() throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(new File("signal.txt")));
        String line = br.readLine();
        double[] signal = null;
        while (line != null) {
            String[] el = line.split(",");
            signal = new double[el.length];
            int i = 0;
            String[] stringArray = el;
            int n = el.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                signal[i] = Double.parseDouble(e);
                ++i;
                ++n2;
            }
            line = null;
        }
        br.close();
        PeriodicityDetector pd = new PeriodicityDetector();
        double F = pd.detectFrequency(signal, true);
        System.out.println("Detected Frequency:" + F + " indecision [" + pd.lowermeanF + " , " + pd.uppermeanF + "]");
        System.out.println("Detected Period:" + pd.meanPeriod + " indecision [" + pd.lowermeanPeriod + " , " + pd.uppermeanPeriod + "]");
        System.out.println("Detected Periodicity Strength:" + pd.periodicityStrength);
    }
}

