/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.transducers.charts.AbstractChartsProducer;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.geo.charts.GeoMapChart;
import org.gcube.dataanalysis.geo.charts.GeoTemporalPoint;

public class StaticGeoChartProducer
extends AbstractChartsProducer {
    protected static String longitudeParameter = "Longitude";
    protected static String latitudeParameter = "Latitude";

    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, inputTableParameter, "The input table");
        this.inputs.add(tinput);
        ColumnType p1 = new ColumnType(inputTableParameter, longitudeParameter, "The column containing longitude decimal values", "long", false);
        ColumnType p2 = new ColumnType(inputTableParameter, latitudeParameter, "The column containing latitude decimal values", "lat", false);
        ColumnTypesList q = new ColumnTypesList(inputTableParameter, quantitiesParameter, "The numeric quantities to visualize ", true);
        this.inputs.add(p1);
        this.inputs.add(p2);
        this.inputs.add(q);
        DatabaseType.addDefaultDBPars((List)this.inputs);
    }

    public String getDescription() {
        return "An algorithm producing a charts that displays quantities as colors of countries. The color indicates the sum of the values recorded in a country.";
    }

    public String InfoRetrievalQuery(String table, String[] dimensions, String quantity, String time) {
        if (quantity.length() == 0) {
            return "select distinct " + Arrays.toString(dimensions).replace("[", "").replace("]", "") + " from " + table;
        }
        return "select distinct " + Arrays.toString(dimensions).replace("[", "").replace("]", "") + " , " + quantity + " as quanta232a from " + table;
    }

    public String[] getDimensions() {
        String[] dimensions = new String[]{IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)longitudeParameter), IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)latitudeParameter)};
        return dimensions;
    }

    public LinkedHashMap<String, Object> createCharts(String[] dimensions, String quantity, String time, List<Object> rows, boolean displaychart) {
        LinkedHashMap<String, Object> charts;
        long t0;
        block15: {
            if (dimensions == null) {
                dimensions = new String[]{};
            }
            ArrayList<GeoTemporalPoint> xyvalues = new ArrayList<GeoTemporalPoint>();
            t0 = System.currentTimeMillis();
            AnalysisLogger.getLogger().debug((Object)"StaticGeoChartProducer: building Geo dataset");
            for (Object row : rows) {
                Object[] array = (Object[])row;
                Double lat = null;
                Double longitude = null;
                Double q = null;
                try {
                    longitude = Double.parseDouble("" + array[0]);
                    lat = Double.parseDouble("" + array[1]);
                    q = quantity.length() > 0 ? Double.valueOf(Double.parseDouble("" + array[2])) : Double.valueOf(0.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lat != null && longitude != null && q != null) {
                    xyvalues.add(new GeoTemporalPoint((double)longitude, (double)lat, q));
                    continue;
                }
                AnalysisLogger.getLogger().debug((Object)("StaticGeoChartProducer: skipping these values " + longitude + "," + lat + "," + q));
            }
            AnalysisLogger.getLogger().debug((Object)"StaticGeoChartProducer: producing charts");
            charts = new LinkedHashMap<String, Object>();
            try {
                String baseImageName = new File(this.config.getPersistencePath(), "" + UUID.randomUUID()).getAbsolutePath();
                String pointsImage = String.valueOf(baseImageName) + "_points.jpg";
                if (xyvalues.size() > 0) {
                    GeoMapChart.createWorldImageWithPoints(this.config.getConfigPath(), xyvalues, pointsImage);
                    charts.put("Distribution of latitudes and longitudes points", ImageIO.read(new File(pointsImage)));
                    if (quantity.length() > 0) {
                        AnalysisLogger.getLogger().debug((Object)"StaticGeoChartProducer: quantity is present, producing all the static geocharts");
                        String eezImage = String.valueOf(baseImageName) + "_eez.jpg";
                        GeoMapChart.createEEZWeightedImage(this.config.getConfigPath(), xyvalues, eezImage, this.config.getPersistencePath());
                        try {
                            charts.put("Distribution of summed quantities over Exclusive Economic Zone delimitations", ImageIO.read(new File(eezImage)));
                        }
                        catch (Exception e) {
                            AnalysisLogger.getLogger().debug((Object)"StaticGeoChartProducer: WARNING could not produce EEZ chart");
                        }
                        String faoImage = String.valueOf(baseImageName) + "_FAO.jpg";
                        GeoMapChart.createFAOAreasWeightedImage(this.config.getConfigPath(), xyvalues, faoImage, this.config.getPersistencePath());
                        try {
                            charts.put("Distribution of summed quantities over FAO Major Area delimitations", ImageIO.read(new File(faoImage)));
                        }
                        catch (Exception e) {
                            AnalysisLogger.getLogger().debug((Object)"StaticGeoChartProducer: WARNING could not produce FAO chart");
                        }
                        String worldImage = String.valueOf(baseImageName) + "_world.jpg";
                        GeoMapChart.createWorldWeightedImage(this.config.getConfigPath(), xyvalues, worldImage, this.config.getPersistencePath(), null, null);
                        try {
                            charts.put("Distribution of summed quantities over emerged lands, divided per country", ImageIO.read(new File(worldImage)));
                        }
                        catch (Exception e) {
                            AnalysisLogger.getLogger().debug((Object)"StaticGeoChartProducer: WARNING could not country chart");
                        }
                        break block15;
                    }
                    AnalysisLogger.getLogger().debug((Object)"StaticGeoChartProducer: quantity is absent, producing only one geochart");
                    break block15;
                }
                AnalysisLogger.getLogger().debug((Object)"StaticGeoChartProducer: no viable point was found");
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("StaticGeoChartProducer: error in producing GeoCharts " + e.getMessage()));
            }
        }
        AnalysisLogger.getLogger().debug((Object)("StaticGeoChartProducer: procedure finished in ms " + (System.currentTimeMillis() - t0)));
        return charts;
    }
}

