/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class JsonMapper {
    public static LinkedHashMap<String, Object> parse(String json) {
        JsonElement genericobject = new JsonParser().parse(json);
        JsonObject object = null;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (genericobject instanceof JsonObject) {
            object = (JsonObject)genericobject;
            JsonMapper.parseMap(map, object);
        } else if (genericobject instanceof JsonArray) {
            JsonArray ArrObject = (JsonArray)new JsonParser().parse(json);
            for (JsonElement element : ArrObject) {
                if (element instanceof JsonObject) {
                    if (element.isJsonPrimitive()) continue;
                    JsonMapper.parseMap(map, (JsonObject)element);
                    continue;
                }
                map.put(UUID.randomUUID().toString(), element.toString());
            }
        }
        return map;
    }

    private static void parseMap(LinkedHashMap<String, Object> map, JsonObject object) {
        Set set = object.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (map.get(key) != null) {
                key = String.valueOf(key) + UUID.randomUUID();
            }
            if (!value.isJsonPrimitive()) {
                map.put(key, JsonMapper.parse(value.toString()));
                continue;
            }
            map.put(key, value.getAsString());
        }
    }
}

