/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.vti.vesselsprocessing;

import org.gcube.dataanalysis.ecoengine.utils.Tuple;

public class VTIClassificator {
    private static int bathymetryThr = -500;

    public static String speedClassification(int classif) {
        if (classif == 1) {
            return "Hauling";
        }
        if (classif == 2) {
            return "Fishing";
        }
        if (classif == 3) {
            return "Steaming";
        }
        return "Unclassified";
    }

    public static String bathymetryClassification(int classif) {
        if (classif == 1) {
            return "Hauling";
        }
        if (classif == 2) {
            return "Trawling";
        }
        if (classif == 3) {
            return "Midwater trawling";
        }
        if (classif == 4) {
            return "Steaming";
        }
        return "Unclassified";
    }

    public static Tuple<Integer>[] classify(Tuple<String>[] pairs) {
        Tuple[] outClasses = new Tuple[pairs.length];
        int i = 0;
        Tuple<String>[] tupleArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            Tuple outTuple;
            Tuple<String> pair = tupleArray[n2];
            Double speed = Double.parseDouble((String)pair.getElements().get(0));
            Double bathymetry = Double.parseDouble((String)pair.getElements().get(1));
            Integer c1 = 1;
            Integer c2 = 1;
            if (speed > 2.0 && speed <= 5.0) {
                c1 = 2;
            } else if (speed > 5.0) {
                c1 = 3;
            }
            if (speed > 2.0 && speed <= 4.0 && bathymetry < (double)bathymetryThr) {
                c2 = 3;
            } else if (speed > 4.0 && speed <= 6.0) {
                c2 = 3;
            } else if (speed > 2.0 && speed <= 4.0 && bathymetry >= (double)bathymetryThr) {
                c2 = 2;
            } else if (speed > 6.0) {
                c2 = 4;
            }
            outClasses[i] = outTuple = new Tuple((Object[])new Integer[]{c1, c2});
            ++i;
            ++n2;
        }
        return outClasses;
    }
}

