/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import density.Maxent;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.gcube.dataanalysis.geo.connectors.asc.AscRaster;
import org.gcube.dataanalysis.geo.connectors.asc.AscRasterReader;
import org.gcube.dataanalysis.geo.matrixmodel.ASCConverter;
import org.gcube.dataanalysis.geo.matrixmodel.RasterTable;
import org.gcube.dataanalysis.geo.matrixmodel.XYExtractor;
import org.gcube.dataanalysis.geo.utils.MapUtils;

public class MaxEnt4NicheModellingTransducer
implements Transducerer {
    static String t = "TimeIndex";
    static String z = "Z";
    static String yLL = "BBox_LowerLeftLat";
    static String xLL = "BBox_LowerLeftLong";
    static String yUR = "BBox_UpperRightLat";
    static String xUR = "BBox_UpperRightLong";
    static String xRes = "XResolution";
    static String yRes = "YResolution";
    static String tableLabel = "OutputTableLabel";
    static String speciesLabel = "SpeciesName";
    static String OccurrencesTableNameParameter = "OccurrencesTable";
    static String LongitudeColumn = "LongitudeColumn";
    static String LatitudeColumn = "LatitudeColumn";
    static String Layers = "Layers";
    static String maxIterations = "MaxIterations";
    static String prevalence = "DefaultPrevalence";
    AlgorithmConfiguration config;
    float status;
    public int time;
    public double zValue;
    public double xResValue;
    public double yResValue;
    public String tableNameValue = "";
    public String tableLabelValue = "";
    public double BBxLL = -180.0;
    public double BBxUR = 180.0;
    public double BByLL = -90.0;
    public double BByUR = 90.0;
    private int maxIterationsValue;
    private double prevalenceValue;
    private double bestThreshold = 0.0;
    private double prevalenceVal = 0.0;
    private String variablesContributions = "";
    private String variablesPermutationsImportance = "";
    private String warnings = "";
    private String layerIdentities = "";
    private File warningsFile = null;
    private File projectionFile = null;
    private File asciimapsFile = null;
    LinkedHashMap<String, Image> producedImages = new LinkedHashMap();
    public List<StatisticalType> inputs = new ArrayList<StatisticalType>();
    public LinkedHashMap<String, String> outputParameters = new LinkedHashMap();
    private String[] layers;
    private String occurrencesTableName;
    private String speciesName;
    private String longitudeColumn;
    private String latitudeColumn;
    protected ResourceFactory resourceManager;

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"MaxEnt: Initialization");
    }

    public String getDescription() {
        return "A Maximum-Entropy model for species habitat modeling, based on the implementation by Shapire et al. v 3.3.3k, Princeton University, http://www.cs.princeton.edu/schapire/maxent/. In this adaptation for the D4Science infrastructure, the software accepts a table produced by the Species Product Discovery service and a set of environmental layers in various formats (NetCDF, WFS, WCS, ASC, GeoTiff) via direct links or GeoExplorer UUIDs. The user can also establish the bounding box and the spatial resolution (in decimal deg.) of the training and the projection. The application will adapt the layers to that resolution if this is higher than the native one.The output contains: a thumbnail map of the projected model, the ROC curve, the Omission/Commission chart, a table containing the raw assigned values, a threshold to transform the table into a 0-1 probability distribution, a report of the importance of the used layers in the model, ASCII representations of the input layers to check their alignment.Other processes can be later applied to the raw values to produce a GIS map (e.g. the Statistical Manager Points-to-Map process) and results can be shared. Demo video: http://goo.gl/TYYnTO and instructions http://wiki.i-marine.eu/index.php/MaxEnt";
    }

    public List<StatisticalType> getInputParameters() {
        IOHelper.addStringInput(this.inputs, (String)tableLabel, (String)"The name of the table to produce", (String)"maxent_");
        IOHelper.addStringInput(this.inputs, (String)speciesLabel, (String)"The name of the species to model and the occurrence records refer to", (String)"generic_species");
        IOHelper.addIntegerInput(this.inputs, (String)maxIterations, (String)"The number of learning iterations of the MaxEnt algorithm", (String)"1000");
        IOHelper.addDoubleInput(this.inputs, (String)prevalence, (String)"A priori probability of presence at ordinary occurrence points", (String)"0.5");
        ArrayList<TableTemplates> template = new ArrayList<TableTemplates>();
        template.add(TableTemplates.OCCURRENCE_SPECIES);
        InputTable table = new InputTable(template, OccurrencesTableNameParameter, "A geospatial table containing occurrence records, following the template of the Species Products Discovery datasets", "");
        this.inputs.add((StatisticalType)table);
        ColumnType p1 = new ColumnType(OccurrencesTableNameParameter, LongitudeColumn, "The column containing longitude values", "decimallongitude", false);
        this.inputs.add((StatisticalType)p1);
        ColumnType p2 = new ColumnType(OccurrencesTableNameParameter, LatitudeColumn, "The column containing latitude values", "decimallatitude", false);
        this.inputs.add((StatisticalType)p2);
        IOHelper.addDoubleInput(this.inputs, (String)xRes, (String)"Model projection resolution on the X axis in decimal degrees", (String)"1");
        IOHelper.addDoubleInput(this.inputs, (String)yRes, (String)"Model projection resolution on the Y axis in decimal degrees", (String)"1");
        PrimitiveTypesList listEnvLayers = new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, Layers, "The list of environmental layers to use for enriching the points. Each entry is a layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS, ASC, GeoTiff ). E.g. https://dl.dropboxusercontent.com/u/12809149/wind1.tif", false);
        this.inputs.add((StatisticalType)listEnvLayers);
        IOHelper.addDoubleInput(this.inputs, (String)z, (String)"Value of Z. Default is 0, that means environmental layers processing will be at surface level or at the first avaliable Z value in the layer", (String)"0");
        IOHelper.addIntegerInput(this.inputs, (String)t, (String)"Time Index. The default is the first time indexed in the input environmental datasets", (String)"0");
        DatabaseType.addDefaultDBPars(this.inputs);
        return this.inputs;
    }

    protected void getParameters() {
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : Externally set scope " + scope));
        if (scope == null) {
            scope = ScopeProvider.instance.get();
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: : Internally set scope " + scope));
            this.config.setGcubeScope(scope);
        }
        this.occurrencesTableName = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)OccurrencesTableNameParameter);
        this.longitudeColumn = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)LongitudeColumn);
        this.latitudeColumn = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)LatitudeColumn);
        this.speciesName = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)speciesLabel);
        this.layers = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)Layers).trim().split(AlgorithmConfiguration.getListSeparator());
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: N. of Layers to take " + this.layers.length));
        String z$ = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)z);
        String time$ = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)t);
        int n = this.time = time$ != null && time$.trim().length() > 0 ? Integer.parseInt(time$) : 0;
        if (this.time < 0) {
            this.time = 0;
        }
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : Time " + this.time));
        this.zValue = 0.0;
        if (z$ != null && z$.trim().length() > 0) {
            try {
                this.zValue = Double.parseDouble(z$);
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : Z " + this.zValue));
        this.BByLL = -90.0;
        this.BBxLL = -180.0;
        this.BByUR = 90.0;
        this.BBxUR = 180.0;
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : yLL " + this.BByLL));
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : xLL " + this.BBxLL));
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : yUR " + this.BByUR));
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : xUR " + this.BBxUR));
        this.yResValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)yRes));
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : yRes " + this.yResValue));
        this.xResValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)xRes));
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : xRes " + this.xResValue));
        this.tableLabelValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)tableLabel);
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : tableName " + this.tableNameValue));
        AnalysisLogger.getLogger().debug((Object)("MaxEnt: : tableLabel " + this.tableLabelValue));
        this.prevalenceValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)prevalence));
        this.maxIterationsValue = Integer.parseInt(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)maxIterations));
    }

    public void compute() throws Exception {
        Maxent me = null;
        try {
            this.status = 10.0f;
            AnalysisLogger.setLogger((String)(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
            this.getParameters();
            AnalysisLogger.getLogger().debug((Object)"MaxEnt: parameters initialized");
            long t0 = System.currentTimeMillis();
            String localtempFolder = new File(this.config.getPersistencePath(), "maxent" + UUID.randomUUID()).getAbsolutePath();
            if (!new File(localtempFolder).exists()) {
                new File(localtempFolder).mkdir();
            }
            String localOccurrencesFile = new File(localtempFolder, this.occurrencesTableName).getAbsolutePath();
            String localFinalOccurrencesFile = localOccurrencesFile + "_occ.csv";
            String localAsciiMapsFile = localOccurrencesFile + "_maps.txt";
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: local occurrence file to produce " + localFinalOccurrencesFile));
            AnalysisLogger.getLogger().debug((Object)"MaxEnt: initializing connection");
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: creating local file from remote table " + this.occurrencesTableName));
            DatabaseUtils.createLocalFileFromRemoteTable((String)localOccurrencesFile, (String)("(select " + this.longitudeColumn + " as longitude," + this.latitudeColumn + " as latitude from " + this.occurrencesTableName + ")"), (String)",", (String)this.config.getParam("DatabaseUserName"), (String)this.config.getParam("DatabasePassword"), (String)this.config.getParam("DatabaseURL"));
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: table " + this.occurrencesTableName + " was dumped in file: " + localOccurrencesFile));
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: preparing input for maxent in file " + localFinalOccurrencesFile));
            this.prepareInputForMaxEnt(this.speciesName, localOccurrencesFile, localFinalOccurrencesFile);
            AnalysisLogger.getLogger().debug((Object)"MaxEnt: converting layers ... ");
            int layersCount = 1;
            this.status = 30.0f;
            BufferedWriter mapwriter = new BufferedWriter(new FileWriter(new File(localAsciiMapsFile)));
            for (String layer : this.layers) {
                ASCConverter converter = new ASCConverter(this.config);
                String layerfile = new File(localtempFolder, "layer" + layersCount + ".asc").getAbsolutePath();
                AnalysisLogger.getLogger().debug((Object)("MaxEnt: converting " + layer + " into " + layerfile));
                XYExtractor extractor = new XYExtractor(this.config);
                double[][] values = extractor.extractXYGrid(layer, this.time, this.BBxLL, this.BBxUR, this.BByLL, this.BByUR, this.zValue, this.xResValue, this.yResValue);
                mapwriter.write(MapUtils.globalASCIIMap(values));
                AnalysisLogger.getLogger().debug((Object)("MaxEnt: layer name " + extractor.layerName));
                this.layerIdentities = this.layerIdentities + layer + "=" + extractor.layerName + " ";
                String converted = converter.convertToASC(layerfile, values, this.BBxLL, this.BByLL, this.xResValue, this.yResValue);
                AnalysisLogger.getLogger().debug((Object)("MaxEnt: converted into ASC file " + converted + " check: " + new File(converted).exists()));
                ++layersCount;
            }
            mapwriter.close();
            this.status = 70.0f;
            AnalysisLogger.getLogger().debug((Object)"MaxEnt: executing MaxEnt");
            me = new Maxent(localFinalOccurrencesFile, localtempFolder, localtempFolder, this.maxIterationsValue, this.prevalenceValue, -9999);
            me.executeMaxEnt();
            AnalysisLogger.getLogger().debug((Object)"MaxEnt: OK MaxEnt!");
            try {
                AnalysisLogger.getLogger().debug((Object)("MaxEnt: Result: " + me.getResult()));
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("MaxEnt: error in retrieving the result " + e.getLocalizedMessage()));
            }
            this.bestThreshold = me.getBestThr();
            this.prevalenceVal = me.getPrevalence();
            this.variablesContributions = me.getVariablesContributions().toString().replace("{", "").replace("}", "");
            this.variablesPermutationsImportance = me.getVariablesPermutationsImportance().toString().replace("{", "").replace("}", "");
            this.warnings = me.getWarnings();
            String worldFile = me.getWorldPlot();
            String rocFile = me.getROCPlot();
            String omissionsFile = me.getOmissionPlot();
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: ROC plot: " + worldFile));
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: World plot: " + rocFile));
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: Omission/Commission Plot: " + omissionsFile));
            this.producedImages.put("World Thumbnail", ImageTools.toImage((BufferedImage)ImageIO.read(new File(worldFile))));
            this.producedImages.put("ROC Curve", ImageTools.toImage((BufferedImage)ImageIO.read(new File(rocFile))));
            this.producedImages.put("Omission-Commission Curve", ImageTools.toImage((BufferedImage)ImageIO.read(new File(omissionsFile))));
            if (this.warnings != null && this.warnings.trim().length() > 0) {
                this.warningsFile = new File(localtempFolder, "Warnings_" + this.tableLabelValue + ".txt");
                FileTools.saveString((String)this.warningsFile.getAbsolutePath(), (String)this.warnings, (boolean)true, (String)"UTF-8");
            }
            this.projectionFile = new File(me.getResult());
            this.asciimapsFile = new File(localAsciiMapsFile);
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: Best Threshold: " + this.bestThreshold));
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: Prevalence: " + this.prevalenceVal));
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: Variables Contribution: " + this.variablesContributions));
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: Variables Permutations: " + this.variablesPermutationsImportance));
            if (this.warningsFile != null) {
                AnalysisLogger.getLogger().debug((Object)("MaxEnt: Warnings file: " + this.warningsFile.getAbsolutePath() + " exists " + this.warningsFile.exists()));
            }
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: Projection file: " + this.projectionFile.getAbsolutePath() + " exists " + this.projectionFile.exists()));
            this.status = 80.0f;
            AnalysisLogger.getLogger().debug((Object)"MaxEnt: Generating table");
            AscRasterReader reader = new AscRasterReader();
            AscRaster ascFile = reader.readRaster(this.projectionFile.getAbsolutePath());
            RasterTable table = new RasterTable(this.BBxLL, this.BBxUR, this.BByLL, this.BByUR, this.zValue, this.xResValue, this.yResValue, ascFile.getInvertedAxisData(), this.config);
            table.dumpGeoTable();
            this.tableNameValue = table.getTablename();
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: Generated table " + this.tableNameValue));
            this.status = 90.0f;
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: Elapsed: Whole operation completed in " + (double)(System.currentTimeMillis() - t0) / 1000.0 + "s"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("MaxEnt: ERROR!: " + e.getLocalizedMessage()));
            throw new Exception(e.getLocalizedMessage());
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareInputForMaxEnt(String speciesname, String lonlatfile, String outputFile) throws Exception {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new FileReader(new File(lonlatfile)));
            bw = new BufferedWriter(new FileWriter(new File(outputFile)));
            bw.write("species,longitude,latitude\n");
            String line = br.readLine();
            while (line != null) {
                bw.write(speciesname + "," + line + "\n");
                line = br.readLine();
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)e);
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"MaxEnt: Shutdown");
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.GENERIC);
        OutputTable p = new OutputTable(templateHspec, this.tableLabelValue, this.tableNameValue, "Output table");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Best Threshold", new PrimitiveType(String.class.getName(), (Object)("" + this.bestThreshold), PrimitiveTypes.STRING, "Best Threshold", "Best threshold for transforming MaxEnt values into 0/1 probability assignments"));
        map.put("Estimated Prevalence", new PrimitiveType(String.class.getName(), (Object)("" + this.prevalenceVal), PrimitiveTypes.STRING, "Estimated Prevalence", "The a posteriori estimated prevalence of the species"));
        map.put("Variables Contributions", new PrimitiveType(String.class.getName(), (Object)this.variablesContributions, PrimitiveTypes.STRING, "Variables contributions", "The contribution of each variable to the MaxEnt values estimates"));
        map.put("Variables Permutations Importance", new PrimitiveType(String.class.getName(), (Object)this.variablesPermutationsImportance, PrimitiveTypes.STRING, "Variables Permutations Importance", "The importance of the permutations of the variables during the training"));
        if (this.warningsFile != null) {
            map.put("Warnings generated by the MaxEnt process", new PrimitiveType(File.class.getName(), (Object)this.warningsFile, PrimitiveTypes.FILE, "Warnings generated by the MaxEnt process", "The warnings from the underlying MaxEnt model"));
        }
        map.put("ASCII Maps of the environmental layers for checking features aligments", new PrimitiveType(File.class.getName(), (Object)this.asciimapsFile, PrimitiveTypes.FILE, "ASCII Maps of the environmental layers for checking features aligments", "ASCII Maps of the environmental layers for checking features aligments"));
        PrimitiveType images = new PrimitiveType(LinkedHashMap.class.getName(), this.producedImages, PrimitiveTypes.IMAGES, "Model performance", "Model performance and projection");
        map.put("Images", images);
        map.put("OutputTable", p);
        PrimitiveType outputm = new PrimitiveType(LinkedHashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return outputm;
    }

    public float getStatus() {
        return this.status;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    public String getResources() {
        return ResourceFactory.getResources((float[])new float[]{100.0f});
    }
}

