/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.geo.algorithms.FAOOceanAreaCreator;
import org.gcube.dataanalysis.geo.utils.FAOOceanAreaConverter;

public class FAOOceanAreaCreatorQuadrant
extends FAOOceanAreaCreator {
    static String quadrantDim = "Quadrant_Column";

    @Override
    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, inputTableParameter, "The table to which the algorithm adds the csquare column");
        this.inputs.add(tinput);
        ColumnType xDimension = new ColumnType(inputTableParameter, xDim, "The column containing Longitude information", "x", false);
        ColumnType yDimension = new ColumnType(inputTableParameter, yDim, "The column containing Latitude information", "y", false);
        ColumnType quadrantDimension = new ColumnType(inputTableParameter, quadrantDim, "The column containing Quadrant information", "quadrant", false);
        this.inputs.add(xDimension);
        this.inputs.add(yDimension);
        this.inputs.add(quadrantDimension);
        IOHelper.addIntegerInput((List)this.inputs, (String)this.resolutionParameter, (String)"The resolution of the FAO Ocean Area codes", (String)"5");
        IOHelper.addStringInput((List)this.inputs, (String)outputTableParameter, (String)"The name of the output table", (String)"faooceanarea_");
        DatabaseType.addDefaultDBPars((List)this.inputs);
    }

    @Override
    public String getDescription() {
        return "An algorithm that adds a column containing the FAO Ocean Area codes associated to longitude, latitude and quadrant columns.";
    }

    @Override
    public String selectInformationForTransformation(AlgorithmConfiguration config, String table, int limit, int offset) {
        String x = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)xDim);
        String y = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)yDim);
        String quadrant = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)quadrantDim);
        String select = "select *," + x + " as loforcs01," + y + " as laforcs01," + quadrant + " from " + table + " limit " + limit + " offset " + offset;
        return select;
    }

    @Override
    public String rowToCode(Object[] rowArray) {
        String xValue = "" + rowArray[rowArray.length - 3];
        String yValue = "" + rowArray[rowArray.length - 2];
        String quadrantValue = "" + rowArray[rowArray.length - 1];
        String code = "";
        try {
            double xV = Double.parseDouble(xValue);
            double yV = Double.parseDouble(yValue);
            int quadrantV = (int)Double.parseDouble(quadrantValue);
            FAOOceanAreaConverter converter = new FAOOceanAreaConverter();
            code = converter.FAOOceanArea(quadrantV, xV, yV, (int)this.resolution);
        }
        catch (Exception e) {
            // empty catch block
        }
        return code;
    }
}

