/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.vti.vesselsprocessing;

import java.awt.geom.Point2D;
import org.gcube.dataanalysis.geo.vti.vesselsprocessing.VTIBathymetry;

public class Bathymetry {
    private static VTIBathymetry bathymetryObj;

    public static void init() throws Exception {
        bathymetryObj.open();
    }

    public static void close() throws Exception {
        bathymetryObj.close();
    }

    public static void initInstance(String bathfile) throws Exception {
        if (bathymetryObj == null) {
            bathymetryObj = new VTIBathymetry(bathfile);
            try {
                Bathymetry.init();
            }
            catch (Exception e) {
                e.printStackTrace();
                Bathymetry.close();
            }
        }
    }

    public Bathymetry(String bathfile) throws Exception {
        Bathymetry.initInstance(bathfile);
    }

    public synchronized short[] compute(Point2D.Double[] points) throws Exception {
        return bathymetryObj.getZ(points);
    }

    public static void main(String[] args) {
        VTIBathymetry vti = new VTIBathymetry("./cfg/gebco_08.nc");
        try {
            long t0 = System.currentTimeMillis();
            vti.open();
            System.out.println("file open");
            long t00 = System.currentTimeMillis();
            double z = vti.getZ(1.75, 0.25);
            System.out.println("Z:" + z);
            long t01 = System.currentTimeMillis();
            System.out.println("computation elapsed " + (t01 - t00) + " ms");
            t00 = System.currentTimeMillis();
            Point2D.Double point = new Point2D.Double(0.25, 0.75);
            point = new Point2D.Double(0.25, 0.75);
            point = new Point2D.Double(50.0, 75.0);
            point = new Point2D.Double(45.0, 0.75);
            point = new Point2D.Double(30.0, 0.75);
            point = new Point2D.Double(25.0, 0.75);
            point = new Point2D.Double(90.0, 0.75);
            point = new Point2D.Double(180.0, 180.0);
            point = new Point2D.Double(0.25, 0.75);
            Point2D.Double[] pp = new Point2D.Double[]{point, point, point, point, point, point, point, point, point};
            short[] zz = vti.getZ(pp);
            System.out.println("ZZ:" + zz);
            t01 = System.currentTimeMillis();
            System.out.println("computation elapsed " + (t01 - t00) + " ms");
            for (short z1 : zz) {
                System.out.println("Zz:" + z1);
            }
            vti.close();
            System.out.println("file closed");
            long t1 = System.currentTimeMillis();
            System.out.println("elapsed " + (t1 - t0) + " ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

