/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.charts;

import density.Grid;
import density.LazyGrid;
import density.Sample;
import density.ShrunkGrid;
import density.WorldImageProducer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.GifSequenceWriter;
import org.gcube.dataanalysis.ecoengine.utils.TimeAnalyzer;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.charts.GeoTemporalPoint;
import org.gcube.dataanalysis.geo.connectors.asc.AscRaster;
import org.gcube.dataanalysis.geo.connectors.asc.AscRasterReader;
import org.gcube.dataanalysis.geo.connectors.asc.AscRasterWriter;

public class GeoMapChart {
    public static List<Tuple<Double>> generateRandomWorldPoints() {
        ArrayList<Tuple<Double>> xyvalues = new ArrayList<Tuple<Double>>();
        for (int j = 0; j < 8000; ++j) {
            double randomx = 180.0 * Math.random() - 180.0 * Math.random();
            double randomy = 90.0 * Math.random() - 90.0 * Math.random();
            xyvalues.add((Tuple<Double>)new Tuple((Object[])new Double[]{randomx, randomy}));
        }
        return xyvalues;
    }

    public static void createWorldImageWithPoints(String configFolder, List<GeoTemporalPoint> xyvalues, String outImageFileName) throws Exception {
        String is = new File(configFolder, "templatelayerres05.asc").getAbsolutePath();
        GeoMapChart.createImage(is, outImageFileName, xyvalues, true, 100.0, 10000.0, false, false, null);
    }

    public static void createWorldImageWithPointsAndFixedTime(String configFolder, List<GeoTemporalPoint> xyvalues, String outImageFileName, Date time) throws Exception {
        String is = new File(configFolder, "templatelayerres05.asc").getAbsolutePath();
        GeoMapChart.createImage(is, outImageFileName, xyvalues, true, 100.0, 10000.0, false, false, time);
    }

    private static List<Date> extractTimefromPoints(List<GeoTemporalPoint> points) {
        ArrayList<Date> times = new ArrayList<Date>();
        HashMap<Date, String> timesh = new HashMap<Date, String>();
        for (GeoTemporalPoint p : points) {
            timesh.put(p.time, "");
        }
        for (Date t : timesh.keySet()) {
            Date d;
            int i = 0;
            Iterator iterator = times.iterator();
            while (iterator.hasNext() && !(d = (Date)iterator.next()).after(t)) {
                ++i;
            }
            times.add(i, t);
        }
        return times;
    }

    private static void createImage(String filepath, String outImageFileName, List<GeoTemporalPoint> xypoints, boolean displaypoints, double min, double max, boolean makelegend, boolean logscale, Date fixedTime) throws Exception {
        boolean logScale;
        ShrunkGrid g = new ShrunkGrid(new LazyGrid(filepath), 2000);
        double cellsize = g.getDimension().getcellsize();
        double xll = g.getDimension().getxllcorner();
        double yll = g.getDimension().getyllcorner();
        WorldImageProducer d = new WorldImageProducer((Grid)g);
        AscRaster raster = new AscRaster(cellsize, -1.0, -1.0, xll, yll);
        Date minimumTime = new Date(System.currentTimeMillis());
        Date maximumTime = new Date(0L);
        HashMap<Date, String> timeFrames = new HashMap<Date, String>();
        if (xypoints != null) {
            Sample[] samps = new Sample[xypoints.size()];
            int i = 0;
            for (GeoTemporalPoint t : xypoints) {
                double longitude = t.x;
                double latitude = t.y;
                if (minimumTime.after(t.time)) {
                    minimumTime = new Date(t.time.getTime());
                }
                if (maximumTime.before(t.time)) {
                    maximumTime = new Date(t.time.getTime());
                }
                if (timeFrames.get(t.time) == null) {
                    timeFrames.put(t.time, "");
                }
                if (fixedTime != null && t.time.compareTo(fixedTime) != 0) continue;
                samps[i] = new Sample(1, raster.latitude2Index(latitude), raster.longitude2Index(longitude), latitude, longitude, "sample");
                ++i;
            }
            if (displaypoints) {
                d.setTestSamples(samps);
            }
        }
        if (!(logScale = logscale)) {
            d.setMode(1);
        }
        d.minval = min;
        d.maxval = max;
        d.visible = false;
        d.makeLegend = makelegend;
        boolean bl = d.makeTimeline = fixedTime != null;
        if (d.makeTimeline) {
            SimpleDateFormat sdf = new SimpleDateFormat(xypoints.get((int)0).timePattern, Locale.ENGLISH);
            int timeidx = TimeAnalyzer.getTimeIndexInTimeRange((Date)maximumTime, (Date)minimumTime, (Date)fixedTime, (int)timeFrames.size());
            d.setTime(timeFrames.size(), timeidx, sdf.format(minimumTime), sdf.format(fixedTime));
        }
        d.makeImage();
        d.writeImage(outImageFileName, 1);
    }

    public static HashMap<Double, Double> createWorldWeightedImage(String configFolder, List<GeoTemporalPoint> xypoints, String outImageFileName, String tempdir, Date fixedTime, HashMap<Double, Double> weights) throws Exception {
        String is = new File(configFolder, "worldcountries_hires.asc").getAbsolutePath();
        return GeoMapChart.createWeightedImage(is, xypoints, outImageFileName, tempdir, false, fixedTime, weights);
    }

    public static void createWorldWeightedImageInTime(String configFolder, List<GeoTemporalPoint> xypoints, String outImageFileName, String tempdir, boolean cumulative) throws Exception {
        String is = new File(configFolder, "worldcountries_hires.asc").getAbsolutePath();
        GeoMapChart.createImageInTime(is, configFolder, xypoints, outImageFileName, tempdir, cumulative);
    }

    public static void createEEZWeightedImageInTime(String configFolder, List<GeoTemporalPoint> xypoints, String outImageFileName, String tempdir, boolean cumulative) throws Exception {
        String is = new File(configFolder, "eez.asc").getAbsolutePath();
        GeoMapChart.createImageInTime(is, configFolder, xypoints, outImageFileName, tempdir, cumulative);
    }

    public static void createFAOAreasWeightedImageInTime(String configFolder, List<GeoTemporalPoint> xypoints, String outImageFileName, String tempdir, boolean cumulative) throws Exception {
        String is = new File(configFolder, "faoareas.asc").getAbsolutePath();
        GeoMapChart.createImageInTime(is, configFolder, xypoints, outImageFileName, tempdir, cumulative);
    }

    public static void createImageInTime(String rastersupport, String configFolder, List<GeoTemporalPoint> xypoints, String outImageFileName, String tempdir, boolean cumulative) throws Exception {
        List<Date> times = GeoMapChart.extractTimefromPoints(xypoints);
        int i = 1;
        ArrayList<String> images = new ArrayList<String>();
        HashMap<Double, Double> weights = null;
        for (Date t : times) {
            HashMap<Double, Double> weightstemp;
            String tempimg = new File(tempdir, i + "_" + UUID.randomUUID() + ".png").getAbsolutePath();
            if (!cumulative) {
                weights = null;
            }
            if ((weightstemp = GeoMapChart.createWeightedImage(rastersupport, xypoints, tempimg, tempdir, false, t, weights)) != null) {
                images.add(tempimg);
                weights = weightstemp;
            }
            ++i;
        }
        AnalysisLogger.getLogger().debug((Object)("GeoMapChart: Writing GIF " + outImageFileName));
        GifSequenceWriter.writeGif((String)outImageFileName, images, (int)1500);
        for (String image : images) {
            new File(image).delete();
        }
    }

    public static void createPointsImageInTime(String configFolder, List<GeoTemporalPoint> xypoints, String outImageFileName, String tempdir) throws Exception {
        List<Date> times = GeoMapChart.extractTimefromPoints(xypoints);
        int i = 1;
        ArrayList<String> images = new ArrayList<String>();
        for (Date t : times) {
            String tempimg = new File(tempdir, i + "_" + UUID.randomUUID() + ".png").getAbsolutePath();
            GeoMapChart.createWorldImageWithPointsAndFixedTime(configFolder, xypoints, tempimg, t);
            images.add(tempimg);
            ++i;
        }
        AnalysisLogger.getLogger().debug((Object)"GeoMapChart: Writing GIF");
        GifSequenceWriter.writeGif((String)outImageFileName, images, (int)1500);
        for (String image : images) {
            new File(image).delete();
        }
    }

    public static void createEEZWeightedImage(String configFolder, List<GeoTemporalPoint> xypoints, String outImageFileName, String tempdir) throws Exception {
        String is = new File(configFolder, "eez.asc").getAbsolutePath();
        GeoMapChart.createWeightedImage(is, xypoints, outImageFileName, tempdir, true, null, null);
    }

    public static void createFAOAreasWeightedImage(String configFolder, List<GeoTemporalPoint> xypoints, String outImageFileName, String tempdir) throws Exception {
        String is = new File(configFolder, "faoareas.asc").getAbsolutePath();
        GeoMapChart.createWeightedImage(is, xypoints, outImageFileName, tempdir, false, null, null);
    }

    public static HashMap<Double, Double> createWeightedImage(String rasterSupportFilePath, List<GeoTemporalPoint> xypoints, String outImageFileName, String tempdir, boolean logscale, Date fixedTime, HashMap<Double, Double> previousweights) throws Exception {
        AscRasterReader reader = new AscRasterReader();
        AscRaster raster = reader.readRaster(rasterSupportFilePath);
        HashMap<Double, Double> countryweights = new HashMap<Double, Double>();
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (GeoTemporalPoint triplet : xypoints) {
            double x = triplet.x;
            double y = triplet.y;
            double weigh = triplet.weight;
            Date time = triplet.time;
            if (fixedTime != null && time.compareTo(fixedTime) != 0) continue;
            int latid = raster.latitude2Index(y);
            int lonid = raster.longitude2Index(x);
            Double value = raster.getValue(latid, lonid);
            int[] lats = new int[]{latid - 1, latid + 1};
            int[] longs = new int[]{lonid - 1, lonid + 1};
            if (Double.isNaN(value)) {
                for (int la = 0; la < lats.length; ++la) {
                    for (int lo = 0; lo < longs.length && Double.isNaN(value = Double.valueOf(raster.getValue(lats[la], longs[lo]))); ++lo) {
                    }
                    if (!Double.isNaN(value)) break;
                }
            }
            if (Double.isNaN(value)) continue;
            Double currentw = (Double)countryweights.get(value);
            if (currentw != null) {
                weigh += currentw.doubleValue();
            } else if (previousweights != null && (currentw = previousweights.get(value)) != null) {
                weigh += currentw.doubleValue();
            }
            if (weigh > max) {
                max = weigh;
            }
            if (weigh < min) {
                min = weigh;
            }
            countryweights.put(value, weigh);
        }
        if (countryweights.size() == 0) {
            return null;
        }
        if (previousweights != null) {
            for (Double country : previousweights.keySet()) {
                if (countryweights.get(country) != null) continue;
                Double pweigh = previousweights.get(country);
                countryweights.put(country, pweigh);
                if (pweigh > max) {
                    max = pweigh;
                }
                if (!(pweigh < min)) continue;
                min = pweigh;
            }
        }
        if (min == max) {
            if (max > 0.0) {
                min = 0.0;
            } else {
                max = 0.0;
            }
        }
        AscRasterWriter writer = new AscRasterWriter();
        int ncols = raster.getCols();
        int nrows = raster.getRows();
        for (int i = 0; i < nrows; ++i) {
            for (int j = 0; j < ncols; ++j) {
                double country = raster.getValue(i, j);
                if (Double.isNaN(country)) continue;
                Double weigh = (Double)countryweights.get(country);
                if (weigh != null) {
                    raster.setValue(i, j, weigh);
                    continue;
                }
                raster.setValue(i, j, 0.0);
            }
        }
        String ascfile = new File(tempdir, "" + UUID.randomUUID() + ".asc").getAbsolutePath();
        writer.writeRaster(ascfile, raster);
        GeoMapChart.createImage(ascfile, outImageFileName, xypoints, false, min, max, true, logscale, fixedTime);
        System.gc();
        boolean deleted = new File(ascfile).delete();
        AnalysisLogger.getLogger().debug((Object)("GeoMapChart: deleted ASC file " + ascfile + " :" + deleted));
        return countryweights;
    }
}

