/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

public class GridCWPConverter {
    public float outlon;
    public float outlat;
    public float gridresolution;

    public static void main(String[] args) {
        GridCWPConverter gridder = new GridCWPConverter();
        gridder.gridCodeToPair("5206064");
        System.out.println(gridder.outlon + "," + gridder.outlat + "," + gridder.gridresolution);
    }

    public void gridCodeToPair(String grid) {
        float Xr;
        char resolution = grid.charAt(0);
        int quadrant = Integer.parseInt("" + grid.charAt(1));
        float lat = Float.parseFloat(grid.substring(2, 4));
        float lon = Float.parseFloat(grid.substring(4));
        this.gridresolution = Xr = this.getResolutionX(resolution);
        float latAdj = this.adjustLat(lat, quadrant);
        float lonAdj = this.adjustLon(lon, quadrant);
        float resolutionY = this.getResolutionY(resolution);
        float resolutionX = this.getResolutionX(resolution);
        float centerLat = this.getCenterLat(latAdj, resolutionY, quadrant);
        float centerLon = this.getCenterLon(lonAdj, resolutionX, quadrant);
        this.outlat = centerLat;
        this.outlon = centerLon;
    }

    public float getCenterLat(float lat, float resolutionY, int quadrant) {
        float halfres = resolutionY / 2.0f;
        if (quadrant == 1 || quadrant == 4) {
            return lat + halfres;
        }
        return lat - halfres;
    }

    public float getCenterLon(float lon, float resolutionX, int quadrant) {
        float halfres = resolutionX / 2.0f;
        if (quadrant == 1 || quadrant == 2) {
            return lon + halfres;
        }
        return lon - halfres;
    }

    public float adjustLat(float lat, int quadrant) {
        if (quadrant == 1 || quadrant == 4) {
            return lat;
        }
        return -1.0f * lat;
    }

    public float adjustLon(float lon, int quadrant) {
        if (quadrant == 1 || quadrant == 2) {
            return lon;
        }
        return -1.0f * lon;
    }

    public float getResolutionY(char token) {
        if (token == '5') {
            return 1.0f;
        }
        if (token == '6') {
            return 5.0f;
        }
        if (token == '7') {
            return 10.0f;
        }
        if (token == '8') {
            return 20.0f;
        }
        if (token == '9') {
            return 30.0f;
        }
        if (token == '0') {
            return 0.0f;
        }
        if (token == '4') {
            return 0.5f;
        }
        if (token == '3') {
            return 0.5f;
        }
        if (token == '2') {
            return 0.22f;
        }
        if (token == '1') {
            return 0.17f;
        }
        return -1.0f;
    }

    public float getResolutionX(char token) {
        if (token == '5') {
            return 1.0f;
        }
        if (token == '6') {
            return 5.0f;
        }
        if (token == '7') {
            return 10.0f;
        }
        if (token == '8') {
            return 20.0f;
        }
        if (token == '9') {
            return 30.0f;
        }
        if (token == '0') {
            return 0.0f;
        }
        if (token == '4') {
            return 1.0f;
        }
        if (token == '3') {
            return 0.5f;
        }
        if (token == '2') {
            return 0.22f;
        }
        if (token == '1') {
            return 0.17f;
        }
        return -1.0f;
    }
}

