/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.signals.SignalProcessing;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.algorithms.XYExtraction;
import org.gcube.dataanalysis.geo.connectors.wfs.WFS;
import org.gcube.dataanalysis.geo.matrixmodel.RasterTable;
import org.gcube.dataanalysis.geo.matrixmodel.ZExtractor;

public class ZExtraction
extends XYExtraction {
    public static String x = "X";
    public static String y = "Y";
    public static String resolution = "Resolution";
    public double xValue;
    public double yValue;
    public double resolutionValue;
    public double[] signal;
    Image signalimage;
    Image spectrogramImage;

    @Override
    public String getDescription() {
        return "An algorithm to extract the Z values from a geospatial features repository (e.g. NETCDF, ASC, GeoTiff files etc. ). The algorithm analyses the repository and automatically extracts the Z values according to the resolution wanted by the user. It produces one chart of the Z values and one table containing the values.";
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        List<StatisticalType> previnputs = super.getInputParameters();
        this.inputs = new ArrayList();
        this.inputs.add(previnputs.get(0));
        this.inputs.add(previnputs.get(5));
        this.inputs.add(previnputs.get(6));
        IOHelper.addDoubleInput((List)this.inputs, (String)x, (String)"X coordinate", (String)"0");
        IOHelper.addDoubleInput((List)this.inputs, (String)y, (String)"Y coordinate", (String)"0");
        this.inputs.add(previnputs.get(8));
        IOHelper.addDoubleInput((List)this.inputs, (String)resolution, (String)"Step for Z values", (String)"100");
        DatabaseType.addDefaultDBPars((List)this.inputs);
        return this.inputs;
    }

    @Override
    protected void getParameters() {
        this.layerNameValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)layerName);
        AnalysisLogger.getLogger().debug((Object)("Extraction: Layer " + this.layerNameValue));
        this.time = Integer.parseInt(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)t));
        this.xValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)x));
        this.yValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)y));
        this.resolutionValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)resolution));
        AnalysisLogger.getLogger().debug((Object)("Extraction: T " + this.time));
        AnalysisLogger.getLogger().debug((Object)("Extraction: X " + this.xValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: Y " + this.yValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: Res " + this.resolutionValue));
        this.tableNameValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)tableName);
        this.tableLabelValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)tableLabel);
        AnalysisLogger.getLogger().debug((Object)("Extraction: tableName " + this.tableNameValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: tableLabel " + this.tableLabelValue));
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("Extraction: Externally set scope " + scope));
        if (scope == null) {
            scope = ScopeProvider.instance.get();
            this.config.setGcubeScope(scope);
        }
    }

    @Override
    public void compute() throws Exception {
        try {
            this.status = 30.0f;
            AnalysisLogger.setLogger((String)(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
            this.getParameters();
            AnalysisLogger.getLogger().debug((Object)"Extracting Time Series from layer");
            ZExtractor extractor = new ZExtractor(this.config);
            extractor.correctZ(0.0, this.layerNameValue, this.resolutionValue);
            long t0 = System.currentTimeMillis();
            this.signal = extractor.extractZ(this.layerNameValue, this.xValue, this.yValue, this.time, this.resolutionValue);
            AnalysisLogger.getLogger().debug((Object)("ELAPSED TIME: " + (System.currentTimeMillis() - t0)));
            AnalysisLogger.getLogger().debug((Object)("Signal: " + this.signal.length));
            this.status = 30.0f;
            if (this.signal.length == 1) {
                AnalysisLogger.getLogger().debug((Object)"Extractor: Signal is only one point!");
            }
            this.status = 70.0f;
            AnalysisLogger.getLogger().debug((Object)"Extractor: Matrix Extracted");
            AnalysisLogger.getLogger().debug((Object)"Extractor: ****Rasterizing grid into table****");
            double[][] matrix = new double[][]{this.signal};
            HashMap<Double, Map<String, String>> polygonsFeatures = null;
            if (extractor.currentconnector instanceof WFS) {
                polygonsFeatures = ((WFS)extractor.currentconnector).getPolygonsFeatures();
            }
            RasterTable raster = new RasterTable(this.xValue, this.xValue, this.yValue, this.yValue, this.zValue, this.time, this.resolutionValue, this.resolutionValue, matrix, polygonsFeatures, this.config);
            boolean signalRate = true;
            double[] zline = new double[this.signal.length];
            int j = 0;
            for (double z = extractor.zmin; z <= extractor.zmax; z += this.resolutionValue) {
                zline[j] = z;
                ++j;
            }
            ArrayList<Tuple<Double>> coordinates = new ArrayList<Tuple<Double>>();
            for (int i = 0; i < zline.length; ++i) {
                coordinates.add((Tuple<Double>)new Tuple((Object[])new Double[]{this.xValue, this.yValue, zline[i], this.time}));
            }
            raster.setTablename(this.tableNameValue);
            raster.setCoordinates(coordinates);
            raster.deleteTable();
            raster.dumpGeoTable();
            this.signalimage = SignalProcessing.renderSignalWithGenericTime((double[])this.signal, (double[])zline, (String)"Z");
            AnalysisLogger.getLogger().debug((Object)("Extractor: Map was dumped in table: " + this.tableNameValue));
            this.status = 80.0f;
            AnalysisLogger.getLogger().debug((Object)("Extractor: Elapsed: Whole operation completed in " + (double)(System.currentTimeMillis() - t0) / 1000.0 + "s"));
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("Extractor: ERROR!: " + e.getLocalizedMessage()));
            throw e;
        }
        finally {
            this.status = 100.0f;
        }
    }

    @Override
    public StatisticalType getOutput() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.TIMESERIES);
        OutputTable p = new OutputTable(templateHspec, this.tableLabelValue, this.tableNameValue, "Output table");
        map.put("OutputTable", p);
        if (this.signalimage != null) {
            HashMap<String, Image> producedImages = new HashMap<String, Image>();
            producedImages.put("Z Modulations Visualization", this.signalimage);
            PrimitiveType images = new PrimitiveType("Images", producedImages, PrimitiveTypes.IMAGES, "Modulations of Z", "The modulations of Z");
            map.put("Images", images);
        }
        PrimitiveType outputm = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return outputm;
    }
}

