/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.vti;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.geo.utils.GridCWPConverter;
import org.hibernate.SessionFactory;

public class GridCWP2Coordinates
extends StandardLocalInfraAlgorithm {
    static String CodeColumn = "ColumnWithCodes";
    static String inputTableParameter = "InputTable";
    static String outputTableParameter = "OutputTableName";
    String outTable = "";
    String outTableLabel = "";
    SessionFactory connection = null;
    protected double currentLong;
    protected double currentLat;
    protected double currentRes;

    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, inputTableParameter, "The table to which the algorithm will add information");
        this.inputs.add(tinput);
        ColumnType Dimension = new ColumnType(inputTableParameter, CodeColumn, "The column containing FAO Ocean Area codes in CWP format", "GRID", false);
        this.inputs.add(Dimension);
        IOHelper.addStringInput((List)this.inputs, (String)outputTableParameter, (String)"The name of the output table", (String)"cwp_");
        DatabaseType.addDefaultDBPars((List)this.inputs);
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> template = new ArrayList<TableTemplates>();
        template.add(TableTemplates.GENERIC);
        OutputTable p = new OutputTable(template, this.outTableLabel, this.outTable, "Output table");
        return p;
    }

    public String getDescription() {
        return "An algorithm that adds longitude, latitude and resolution columns analysing a column containing FAO Ocean Area codes (CWP format).";
    }

    public String selectInformationForTransformation(AlgorithmConfiguration config, String table, int limit, int offset) {
        String d = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)CodeColumn);
        String select = "select *," + d + " as loforcs01 from " + table + " limit " + limit + " offset " + offset;
        return select;
    }

    public void rowToCoords(Object[] rowArray) {
        Object grid = null;
        try {
            grid = rowArray[rowArray.length - 1];
            String gridValue = "" + (int)Double.parseDouble("" + grid);
            GridCWPConverter gridder = null;
            gridder = new GridCWPConverter();
            gridder.gridCodeToPair(gridValue);
            this.currentLat = gridder.outlat;
            this.currentLong = gridder.outlon;
            this.currentRes = gridder.gridresolution;
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Error converting grid: " + grid + " - " + e.getLocalizedMessage()));
            this.currentLat = 0.0;
            this.currentLong = 0.0;
            this.currentRes = 0.0;
        }
    }

    protected void process() throws Exception {
        this.status = 0.0f;
        AnalysisLogger.setLogger((String)(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
        long t0 = System.currentTimeMillis();
        String gridField = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)CodeColumn);
        String table = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)inputTableParameter);
        this.outTable = ("code_" + UUID.randomUUID()).replace("-", "");
        this.outTableLabel = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)outputTableParameter);
        AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: received parameters: code column " + gridField + ", table " + table + ", outputTable " + this.outTable + " outLabel " + this.outTableLabel));
        this.status = 10.0f;
        if (gridField == null || gridField.trim().length() == 0) {
            throw new Exception("Error please provide information for the code column");
        }
        try {
            this.addInformationColumsToTable(table);
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: finished in " + (System.currentTimeMillis() - t0) + " ms"));
        }
        catch (Throwable e) {
            throw new Exception(e.getMessage());
        }
        finally {
            this.status = 100.0f;
        }
    }

    public void addInformationColumsToTable(String table) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"GridCWP2Coordinates: initializing connection");
        long t0 = System.currentTimeMillis();
        try {
            this.connection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: database: " + this.config.getDatabaseURL()));
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: dropping table " + this.outTable + " if exists"));
            try {
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.outTable), (SessionFactory)this.connection);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: table " + this.outTable + " does not exist yet"));
            }
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: creating the new table " + this.outTable));
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.createBlankTableFromAnotherStatement((String)table, (String)this.outTable), (SessionFactory)this.connection);
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: adding new columns to " + this.outTable));
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.addColumnStatement((String)this.outTable, (String)"long_estim", (String)"real"), (SessionFactory)this.connection);
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.addColumnStatement((String)this.outTable, (String)"lat_estim", (String)"real"), (SessionFactory)this.connection);
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.addColumnStatement((String)this.outTable, (String)"res_estim", (String)"real"), (SessionFactory)this.connection);
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: getting columns from " + this.outTable));
            List names = DatabaseFactory.executeSQLQuery((String)DatabaseUtils.getColumnsNamesStatement((String)this.outTable), (SessionFactory)this.connection);
            StringBuffer colnames = new StringBuffer();
            int nnames = names.size();
            for (int i = 0; i < nnames; ++i) {
                colnames.append(names.get(i));
                if (i >= nnames - 1) continue;
                colnames.append(",");
            }
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: columns are: " + colnames.toString()));
            AnalysisLogger.getLogger().debug((Object)"GridCWP2Coordinates: taking chunks ... ");
            int initIdx = 0;
            int limit = 5000;
            long maxRows = DatabaseUtils.estimateNumberofRows((String)table, (SessionFactory)this.connection);
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: estimated number of rows " + maxRows));
            this.status = 20.0f;
            while (true) {
                String select = this.selectInformationForTransformation(this.config, table, limit, initIdx);
                AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: executing query: " + select));
                AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: from " + initIdx + " to " + (initIdx + limit) + " limit " + limit));
                List rows = DatabaseFactory.executeSQLQuery((String)select, (SessionFactory)this.connection);
                if (rows == null || rows.size() == 0) break;
                AnalysisLogger.getLogger().debug((Object)"GridCWP2Coordinates: transforming ");
                ArrayList<String[]> stringrows = new ArrayList<String[]>();
                for (Object row : rows) {
                    Object[] rowArray = (Object[])row;
                    this.rowToCoords(rowArray);
                    String[] stringArray = new String[nnames];
                    for (int k = 0; k < rowArray.length - 1; ++k) {
                        stringArray[k] = "" + rowArray[k];
                    }
                    stringArray[nnames - 3] = "" + this.currentLong;
                    stringArray[nnames - 2] = "" + this.currentLat;
                    stringArray[nnames - 1] = "" + this.currentRes;
                    stringrows.add(stringArray);
                }
                AnalysisLogger.getLogger().debug((Object)"GridCWP2Coordinates: inserting chunks into the table");
                DatabaseUtils.insertChunksIntoTable((String)this.outTable, (String)colnames.toString(), stringrows, (int)limit, (SessionFactory)this.connection, (boolean)true);
                this.status = Math.min(90L, 20L + (long)(70 * (initIdx += limit)) / maxRows);
                AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: status " + this.status));
            }
            AnalysisLogger.getLogger().debug((Object)"GridCWP2Coordinates: no more rows");
            AnalysisLogger.getLogger().debug((Object)"GridCWP2Coordinates: finished");
        }
        catch (Throwable e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates : ERROR!: " + e.getLocalizedMessage()));
            try {
                AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: dropping " + this.outTable));
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.outTable), (SessionFactory)this.connection);
            }
            catch (Exception e1) {
                AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates: could not drop " + this.outTable));
            }
            throw new Exception(e.getMessage());
        }
        finally {
            this.shutdown();
            AnalysisLogger.getLogger().debug((Object)("GridCWP2Coordinates finished in " + (System.currentTimeMillis() - t0) + " ms"));
        }
    }

    public void init() throws Exception {
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"GridCWP2Coordinates shutdown");
        DatabaseUtils.closeDBConnection((SessionFactory)this.connection);
    }
}

